/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.util;

import io.github.portlek.configs.LnkdManaged;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class Scalar<T>
implements Supplier<T> {
    @NotNull
    private final LnkdManaged managed;
    @NotNull
    private final Map<String, T> map;

    @Override
    public T get() {
        String chosen = this.managed.getChosen().get();
        return Optional.ofNullable(this.map.get(chosen)).orElseThrow(() -> new IllegalStateException("Cannot found match a with the file key > " + chosen));
    }

    @NotNull
    public Scalar<T> change(@NotNull T t) {
        this.map.put(this.managed.getChosen().get(), t);
        return new Scalar<T>(this.managed, this.map);
    }

    public Scalar(@NotNull LnkdManaged managed, @NotNull Map<String, T> map) {
        if (managed == null) {
            throw new NullPointerException("managed is marked non-null but is null");
        }
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        this.managed = managed;
        this.map = map;
    }
}

