/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class Languageable<T>
implements Function<String, T> {
    @NotNull
    private final Supplier<T> defaultValue;
    @NotNull
    private final Supplier<Map<String, T>> values;

    @Override
    public T apply(@NotNull String key) {
        Map<String, T> map = this.values.get();
        Optional<T> optional = Optional.ofNullable(map.get(key));
        if (optional.isPresent()) {
            return optional.get();
        }
        Iterator<Map.Entry<String, T>> iterator = map.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, T> entry = iterator.next();
            return entry.getValue();
        }
        throw new RuntimeException("The values are empty!");
    }

    @NotNull
    public Map<Object, T> getValues() {
        return Collections.unmodifiableMap(this.values.get());
    }

    public Languageable(@NotNull Supplier<T> defaultValue, @NotNull Supplier<Map<String, T>> values) {
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        this.defaultValue = defaultValue;
        this.values = values;
    }

    @NotNull
    public Supplier<T> getDefaultValue() {
        return this.defaultValue;
    }
}

