/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class GeneralUtilities {
    @NotNull
    public static String addSeparator(@NotNull String raw) {
        if (raw.isEmpty() || raw.charAt(raw.length() - 1) == '/') {
            return raw;
        }
        return raw + '/';
    }

    @NotNull
    public static <T> Optional<T> instanceOptional(@NotNull Supplier<T> supplier) {
        try {
            return Optional.ofNullable(supplier.get());
        }
        catch (Throwable exception) {
            return Optional.empty();
        }
    }

    @NotNull
    public static Optional<UUID> parseUniqueId(@NotNull String uniqueId) {
        return GeneralUtilities.instanceOptional(() -> UUID.fromString(uniqueId));
    }

    @NotNull
    public static File basedir(@NotNull Class<?> clazz) {
        return new File(clazz.getProtectionDomain().getCodeSource().getLocation().toURI());
    }

    @NotNull
    public static String calculatePath(@NotNull String regex, @NotNull String separator, @NotNull String rawpath, @NotNull String fallback) {
        if (!rawpath.isEmpty()) {
            return rawpath;
        }
        if (regex.isEmpty() || separator.isEmpty()) {
            return fallback;
        }
        return fallback.replace(regex, separator);
    }

    @NotNull
    public static String putDot(@NotNull String text) {
        if (text.isEmpty() || text.charAt(text.length() - 1) == '.') {
            return text;
        }
        return text + '.';
    }

    @NotNull
    public static void saveResource(@NotNull Class<?> clazz, @NotNull File outFile, @NotNull String path) {
        if (path.isEmpty()) {
            throw new IllegalArgumentException("ResourcePath cannot be empty");
        }
        if (!outFile.exists()) {
            outFile.getParentFile().mkdirs();
            outFile.createNewFile();
        }
        try (FileOutputStream out = new FileOutputStream(outFile);
             InputStream input = GeneralUtilities.getResource(clazz, path).orElseThrow(() -> new IllegalArgumentException("The embedded resource '" + path + "' cannot be found!"));){
            int len;
            byte[] buf = new byte[1024];
            while ((len = input.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
    }

    @NotNull
    public static Optional<InputStream> getResource(@NotNull Class<?> clazz, @NotNull String path) {
        return Optional.ofNullable(clazz.getClassLoader().getResource(path)).flatMap(url -> {
            try {
                URLConnection connection = url.openConnection();
                connection.setUseCaches(false);
                return Optional.of(connection.getInputStream());
            }
            catch (IOException iOException) {
                return Optional.empty();
            }
        });
    }

    private GeneralUtilities() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

