/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.type;

import io.github.portlek.configs.BiCons;
import io.github.portlek.configs.FileType;
import io.github.portlek.configs.Func;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.simpleyaml.configuration.file.FileConfiguration;

public abstract class FileTypeEnvelope
implements FileType {
    @NotNull
    private final String suffix;
    @NotNull
    private final Func<File, FileConfiguration> loadFunc;
    @NotNull
    private final BiCons<FileConfiguration, File> saveFunc;

    protected FileTypeEnvelope(@NotNull String suffix, @NotNull Func<File, FileConfiguration> loadFunc) {
        this(suffix, loadFunc, FileConfiguration::save);
    }

    @Override
    @NotNull
    public final String suffix() {
        return this.suffix;
    }

    @Override
    @NotNull
    public final FileConfiguration load(@NotNull File file) throws Exception {
        return this.loadFunc.apply(file);
    }

    @Override
    public final void save(@NotNull FileConfiguration configuration, @NotNull File file) throws Exception {
        this.saveFunc.accept(configuration, file);
    }

    protected FileTypeEnvelope(@NotNull String suffix, @NotNull Func<File, FileConfiguration> loadFunc, @NotNull BiCons<FileConfiguration, File> saveFunc) {
        if (suffix == null) {
            throw new NullPointerException("suffix is marked non-null but is null");
        }
        if (loadFunc == null) {
            throw new NullPointerException("loadFunc is marked non-null but is null");
        }
        if (saveFunc == null) {
            throw new NullPointerException("saveFunc is marked non-null but is null");
        }
        this.suffix = suffix;
        this.loadFunc = loadFunc;
        this.saveFunc = saveFunc;
    }
}

