/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.section;

import io.github.portlek.configs.CfgSection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SectionBuilder {
    private final Collection<Runnable> runs = new ArrayList<Runnable>();
    private final Collection<SectionBuilder> parents = new ArrayList<SectionBuilder>();
    @NotNull
    private final CfgSection section;

    private static void buildParents(@NotNull SectionBuilder builder) {
        builder.getRuns().forEach(Runnable::run);
        builder.getParents().forEach(SectionBuilder::buildParents);
    }

    @NotNull
    public SectionBuilder remove(@NotNull String path) {
        return this.add(() -> this.section.set(path, null));
    }

    @NotNull
    public <T> SectionBuilder setIfAbsentGeneric(@NotNull String path, @NotNull T fallback, @NotNull Function<String, Optional<T>> function) {
        return this.add(() -> this.section.getOrSetGeneric(path, fallback, function));
    }

    @NotNull
    public SectionBuilder setIfAbsentUniqueId(@NotNull String path, @NotNull UUID fallback) {
        return this.setIfAbsentGeneric(path, fallback, this.section::getUniqueId);
    }

    @NotNull
    public SectionBuilder setIfAbsentUniqueId(@NotNull String path, @NotNull String fallback) {
        return this.setIfAbsentUniqueId(path, UUID.fromString(fallback));
    }

    public SectionBuilder setIfAbsentString(@NotNull String path, @NotNull String fallback) {
        return this.setIfAbsentGeneric(path, fallback, this.section::getString);
    }

    @NotNull
    public SectionBuilder setIfAbsentLong(@NotNull String path, @NotNull Long fallback) {
        return this.setIfAbsentGeneric(path, fallback, this.section::getLong);
    }

    @NotNull
    public SectionBuilder setIfAbsentInteger(@NotNull String path, @NotNull Integer fallback) {
        return this.setIfAbsentGeneric(path, fallback, this.section::getInteger);
    }

    @NotNull
    public SectionBuilder setIfAbsentBoolean(@NotNull String path, @NotNull Boolean fallback) {
        return this.setIfAbsentGeneric(path, fallback, this.section::getBoolean);
    }

    @NotNull
    public SectionBuilder setIfAbsentDouble(@NotNull String path, @NotNull Double fallback) {
        return this.setIfAbsentGeneric(path, fallback, this.section::getDouble);
    }

    @NotNull
    public SectionBuilder setIfAbsentStringList(@NotNull String path, @NotNull List<String> fallback) {
        return this.setIfAbsentGeneric(path, fallback, this.section::getStringList);
    }

    @NotNull
    public SectionBuilder setIfAbsentIntegerList(@NotNull String path, @NotNull List<Integer> fallback) {
        return this.setIfAbsentGeneric(path, fallback, this.section::getIntegerList);
    }

    @NotNull
    public SectionBuilder setIfAbsentBooleanList(@NotNull String path, @NotNull List<Boolean> fallback) {
        return this.setIfAbsentGeneric(path, fallback, this.section::getBooleanList);
    }

    @NotNull
    public SectionBuilder setIfAbsentByteList(@NotNull String path, @NotNull List<Byte> fallback) {
        return this.setIfAbsentGeneric(path, fallback, this.section::getByteList);
    }

    @NotNull
    public SectionBuilder setIfAbsentCharacterList(@NotNull String path, @NotNull List<Character> fallback) {
        return this.setIfAbsentGeneric(path, fallback, this.section::getCharacterList);
    }

    @NotNull
    public SectionBuilder setIfAbsentDoubleList(@NotNull String path, @NotNull List<Double> fallback) {
        return this.setIfAbsentGeneric(path, fallback, this.section::getDoubleList);
    }

    @NotNull
    public SectionBuilder setIfAbsentFloatList(@NotNull String path, @NotNull List<Float> fallback) {
        return this.setIfAbsentGeneric(path, fallback, this.section::getFloatList);
    }

    @NotNull
    public SectionBuilder setIfAbsentLongList(@NotNull String path, @NotNull List<Long> fallback) {
        return this.setIfAbsentGeneric(path, fallback, this.section::getLongList);
    }

    @NotNull
    public SectionBuilder setIfAbsentShortList(@NotNull String path, @NotNull List<Short> fallback) {
        return this.setIfAbsentGeneric(path, fallback, this.section::getShortList);
    }

    @NotNull
    public SectionBuilder set(@NotNull String path, @Nullable Object object) {
        return this.add(() -> this.section.set(path, object));
    }

    @NotNull
    public SectionBuilder createIfAbsentSection(@NotNull String path, @NotNull Function<SectionBuilder, SectionBuilder> func) {
        return this.add(() -> this.parents.add((SectionBuilder)func.apply(new SectionBuilder(this.section.getOrCreateSection(path)))));
    }

    @NotNull
    public SectionBuilder createSection(@NotNull String path, @NotNull Function<SectionBuilder, SectionBuilder> func) {
        return this.add(() -> this.parents.add((SectionBuilder)func.apply(new SectionBuilder(this.section.createSection(path)))));
    }

    public void build() {
        boolean save = this.section.getParent().isAutoSave();
        this.section.getParent().setAutoSave(false);
        SectionBuilder.buildParents(this);
        this.section.getParent().setAutoSave(save);
    }

    @NotNull
    private Collection<Runnable> getRuns() {
        return Collections.unmodifiableCollection(this.runs);
    }

    @NotNull
    private Collection<SectionBuilder> getParents() {
        return Collections.unmodifiableCollection(this.parents);
    }

    @NotNull
    private SectionBuilder add(@NotNull Runnable run) {
        this.runs.add(run);
        return this;
    }

    public SectionBuilder(@NotNull CfgSection section) {
        if (section == null) {
            throw new NullPointerException("section is marked non-null but is null");
        }
        this.section = section;
    }
}

