/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.section;

import io.github.portlek.configs.CfgSection;
import io.github.portlek.configs.FlManaged;
import io.github.portlek.configs.provided.LanguageableProvider;
import io.github.portlek.configs.provided.ReplaceableListProvider;
import io.github.portlek.configs.provided.ReplaceableStringProvider;
import io.github.portlek.configs.util.Languageable;
import io.github.portlek.replaceable.rp.RpList;
import io.github.portlek.replaceable.rp.RpString;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simpleyaml.configuration.ConfigurationSection;

public class ConfigSection
implements CfgSection {
    @Nullable
    private ConfigurationSection section;
    @Nullable
    private FlManaged parent;

    @Override
    public final void setup(@NotNull FlManaged parent, @NotNull ConfigurationSection configurationSection) {
        this.section = configurationSection;
        this.parent = parent;
    }

    @Override
    @NotNull
    public ConfigurationSection getConfigurationSection() {
        return Objects.requireNonNull(this.section, "You have to load your class with '#load()' method");
    }

    @Override
    @NotNull
    public FlManaged getParent() {
        return Objects.requireNonNull(this.parent, "You have to load your class with '#load()' method");
    }

    static {
        CfgSection.PROVIDED.put(Languageable.class, new LanguageableProvider());
        CfgSection.addProvidedClass(RpString.class, new ReplaceableStringProvider());
        CfgSection.addProvidedClass(RpList.class, new ReplaceableListProvider());
        CfgSection.addProvidedGetMethod(UUID.class, CfgSection::getUniqueId);
        CfgSection.addProvidedSetMethod(UUID.class, (uuid, sctn, path) -> sctn.set(path, uuid.toString()));
    }
}

