/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.processors;

import io.github.portlek.configs.CfgSection;
import io.github.portlek.configs.Provided;
import io.github.portlek.configs.ProvidedSet;
import io.github.portlek.configs.annotations.Property;
import io.github.portlek.configs.util.GeneralUtilities;
import io.github.portlek.reflection.RefField;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class PropertyProceed {
    @NotNull
    private final Property property;
    @NotNull
    private final Object parentObject;
    @NotNull
    private final CfgSection parent;
    @NotNull
    private final RefField field;

    public PropertyProceed(@NotNull CfgSection parent, @NotNull Property property, @NotNull RefField field) {
        this(property, parent, parent, field);
    }

    @NotNull
    public static Optional<Object> get(@NotNull CfgSection parent, @NotNull Object fieldvalue, @NotNull String path) {
        Class<?> aClass = fieldvalue.getClass();
        return CfgSection.getProvidedClass(aClass).map(objectProvided -> objectProvided.getWithField(fieldvalue, parent, path)).orElseGet(() -> CfgSection.getProvidedGetMethod(aClass).map(func -> func.getWithField(fieldvalue, parent, path)).orElseGet(() -> parent.get(path)));
    }

    @NotNull
    public static Optional<Object> get(@NotNull CfgSection parent, @NotNull Class<Object> fieldClass, @NotNull String path) {
        return CfgSection.getProvidedClass(fieldClass).map(objectProvided -> objectProvided.get(parent, path)).orElseGet(() -> CfgSection.getProvidedGetMethod(fieldClass).map(func -> func.get(parent, path)).orElseGet(() -> parent.get(path)));
    }

    public static void set(@NotNull CfgSection parent, @NotNull Object fieldValue, @NotNull String path) {
        Class<?> clazz = fieldValue.getClass();
        Optional<Provided<?>> optional = CfgSection.getProvidedClass(clazz);
        if (optional.isPresent()) {
            optional.get().set(fieldValue, parent, path);
            return;
        }
        Optional<ProvidedSet<?>> setoptional = CfgSection.getProvidedSetMethod(clazz);
        if (setoptional.isPresent()) {
            setoptional.get().set(fieldValue, parent, path);
        } else {
            parent.set(path, fieldValue);
        }
    }

    public void load() {
        this.field.of(this.parentObject).get().ifPresent(fieldvalue -> {
            String path = GeneralUtilities.calculatePath(this.property.regex(), this.property.separator(), this.property.value(), this.field.name());
            Optional<Object> optional = PropertyProceed.get(this.parent, fieldvalue, path);
            if (optional.isPresent()) {
                this.field.of(this.parentObject).set(optional.get());
            } else {
                PropertyProceed.set(this.parent, fieldvalue, path);
            }
        });
    }

    public PropertyProceed(@NotNull Property property, @NotNull Object parentObject, @NotNull CfgSection parent, @NotNull RefField field) {
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        if (parentObject == null) {
            throw new NullPointerException("parentObject is marked non-null but is null");
        }
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        this.property = property;
        this.parentObject = parentObject;
        this.parent = parent;
        this.field = field;
    }
}

