/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.processors;

import io.github.portlek.configs.FileType;
import io.github.portlek.configs.FlManaged;
import io.github.portlek.configs.annotations.Config;
import io.github.portlek.configs.processors.FieldsProceed;
import io.github.portlek.configs.util.GeneralUtilities;
import io.github.portlek.reflection.clazz.ClassOf;
import java.io.File;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class ConfigProceed {
    @NotNull
    private final Config config;
    @NotNull
    private final Object parentObject;
    @NotNull
    private final FlManaged managed;

    public ConfigProceed(@NotNull Config config, @NotNull FlManaged managed) {
        this(config, managed, managed);
    }

    public void load() {
        Class<? extends FileType> fileTypeClass = this.config.type();
        FileType fileType = new ClassOf<FileType>(fileTypeClass).constructor(new Object[0]).map(refConstructed -> refConstructed.create(new Object[0])).filter(Optional::isPresent).map(Optional::get).orElseThrow(() -> new RuntimeException("No file type such " + fileTypeClass.getSimpleName() + '!'));
        String suffix = fileType.suffix();
        String fileName = this.config.name();
        String name = fileName.endsWith(suffix) ? fileName : fileName + suffix;
        File file = new File(GeneralUtilities.addSeparator(this.config.location().replace("%basedir%", GeneralUtilities.basedir(this.managed.getClass()).getParentFile().getAbsolutePath())), name);
        if (this.config.copyDefault() && !file.exists()) {
            GeneralUtilities.saveResource(this.parentObject.getClass(), file, GeneralUtilities.addSeparator(this.config.resourcePath()) + name);
        } else if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        this.managed.setup(file, fileType);
        new FieldsProceed(this.parentObject, this.managed).load();
        this.managed.save();
    }

    public ConfigProceed(@NotNull Config config, @NotNull Object parentObject, @NotNull FlManaged managed) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (parentObject == null) {
            throw new NullPointerException("parentObject is marked non-null but is null");
        }
        if (managed == null) {
            throw new NullPointerException("managed is marked non-null but is null");
        }
        this.config = config;
        this.parentObject = parentObject;
        this.managed = managed;
    }
}

