/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.processors;

import io.github.portlek.configs.CmprblManaged;
import io.github.portlek.configs.FlManaged;
import io.github.portlek.configs.annotations.Config;
import io.github.portlek.configs.annotations.LinkedConfig;
import io.github.portlek.configs.processors.ConfigProceed;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class ComparableConfigProceed {
    @NotNull
    private final LinkedConfig linked;
    @NotNull
    private final CmprblManaged<?> managed;

    public void load() {
        this.managed.clear();
        Arrays.stream(this.linked.value()).forEach(linkedFile -> {
            FlManaged flmanaged = this.managed.getNewManaged().get();
            flmanaged.setAutoSave(this.managed.isAutoSave());
            String key = linkedFile.key();
            this.managed.setup(key, flmanaged);
            this.managed.current(key);
            Config config = linkedFile.config();
            new ConfigProceed(config, this.managed, flmanaged).load();
        });
    }

    public ComparableConfigProceed(@NotNull LinkedConfig linked, @NotNull CmprblManaged<?> managed) {
        if (linked == null) {
            throw new NullPointerException("linked is marked non-null but is null");
        }
        if (managed == null) {
            throw new NullPointerException("managed is marked non-null but is null");
        }
        this.linked = linked;
        this.managed = managed;
    }
}

