/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.managed;

import io.github.portlek.configs.FileType;
import io.github.portlek.configs.FlManaged;
import io.github.portlek.configs.section.ConfigSection;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simpleyaml.configuration.file.FileConfiguration;

public class FileManaged
extends ConfigSection
implements FlManaged {
    private final Map<String, Object> objects = new HashMap<String, Object>();
    @Nullable
    private File file;
    @Nullable
    private FileType fileType;
    private boolean autosave = false;

    @SafeVarargs
    public FileManaged(Map.Entry<String, Object> ... objects) {
        Arrays.asList(objects).forEach(entry -> this.object((String)entry.getKey(), entry.getValue()));
    }

    @Override
    public void setup(@NotNull File file, @NotNull FileType fileType) throws Exception {
        this.setup(this, fileType.load(file));
        this.file = file;
        this.fileType = fileType;
    }

    @Override
    @NotNull
    public File getFile() {
        return Objects.requireNonNull(this.file, "You have to load your class with '#load()' method");
    }

    @Override
    @NotNull
    public FileType getFileType() {
        return Objects.requireNonNull(this.fileType, "You have to load your class with '#load()' method");
    }

    @Override
    public final void object(@NotNull String key, @NotNull Object object) {
        this.objects.put(key, object);
    }

    @Override
    @NotNull
    public final Optional<Object> object(@NotNull String id) {
        return Optional.ofNullable(this.objects.get(id));
    }

    @Override
    @NotNull
    public final Collection<Object> objects() {
        return this.objects.values();
    }

    @Override
    public final boolean isAutoSave() {
        return this.autosave;
    }

    @Override
    public final void setAutoSave(boolean autosv) {
        this.autosave = autosv;
    }

    @Override
    public final void autoSave() {
        if (this.autosave) {
            this.save();
        }
    }

    @Override
    @NotNull
    public FileConfiguration getConfigurationSection() {
        return (FileConfiguration)super.getConfigurationSection();
    }
}

