/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.bukkit.provided;

import io.github.portlek.configs.CfgSection;
import io.github.portlek.configs.Provided;
import io.github.portlek.configs.bukkit.util.SentTitle;
import io.github.portlek.configs.util.GeneralUtilities;
import io.github.portlek.replaceable.rp.RpString;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class BukkitTitleProvider
implements Provided<SentTitle> {
    @Override
    public void set(@NotNull SentTitle title, @NotNull CfgSection section, @NotNull String path) {
        String fnlpath = GeneralUtilities.putDot(path);
        section.set(fnlpath + "title", title.getTitle().getValue());
        section.set(fnlpath + "sub-title", title.getSubTitle().getValue());
        section.set(fnlpath + "fade-in", title.getFadeIn());
        section.set(fnlpath + "show-time", title.getShowTime());
        section.set(fnlpath + "fade-out", title.getFadeOut());
    }

    @Override
    @NotNull
    public Optional<SentTitle> getWithField(@NotNull SentTitle sentTitle, @NotNull CfgSection section, @NotNull String path) {
        String fnlpath = GeneralUtilities.putDot(path);
        Optional<String> title = section.getString(fnlpath + "title");
        Optional<String> subTitle = section.getString(fnlpath + "sub-title");
        Optional<Integer> fadeIn = section.getInteger(fnlpath + "fade-in");
        Optional<Integer> showTime = section.getInteger(fnlpath + "show-time");
        Optional<Integer> fadeOut = section.getInteger(fnlpath + "fade-out");
        if (!(title.isPresent() && subTitle.isPresent() && fadeIn.isPresent() && showTime.isPresent() && fadeOut.isPresent())) {
            return Optional.empty();
        }
        return Optional.of(new SentTitle((RpString)sentTitle.getTitle().value(title.get()), (RpString)sentTitle.getSubTitle().value(subTitle.get()), fadeIn.get(), showTime.get(), fadeOut.get()));
    }

    @Override
    @NotNull
    public Optional<SentTitle> get(@NotNull CfgSection section, @NotNull String path) {
        return Optional.empty();
    }
}

