/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.bukkit;

import com.cryptomorin.xseries.XMaterial;
import io.github.portlek.bukkitlocation.LocationUtil;
import io.github.portlek.configs.CfgSection;
import io.github.portlek.configs.bukkit.provided.BukkitItemStackProvider;
import io.github.portlek.configs.bukkit.provided.BukkitSoundProvider;
import io.github.portlek.configs.bukkit.provided.BukkitTitleProvider;
import io.github.portlek.configs.bukkit.util.PlayableSound;
import io.github.portlek.configs.bukkit.util.Position;
import io.github.portlek.configs.bukkit.util.SentTitle;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public final class BukkitExtensions {
    public static void registerExtensions() {
        CfgSection.addProvidedClass(ItemStack.class, new BukkitItemStackProvider());
        CfgSection.addProvidedClass(PlayableSound.class, new BukkitSoundProvider());
        CfgSection.addProvidedClass(SentTitle.class, new BukkitTitleProvider());
        CfgSection.addProvidedGetMethod(Material.class, (section, s) -> section.getString(s).map(XMaterial::matchXMaterial).filter(Optional::isPresent).map(Optional::get).flatMap(xMaterial -> Optional.ofNullable(xMaterial.parseMaterial())));
        CfgSection.addProvidedSetMethod(Material.class, (material, section, path) -> section.set(path, material.name()));
        CfgSection.addProvidedGetMethod(XMaterial.class, (section, s) -> section.getString(s).flatMap(XMaterial::matchXMaterial));
        CfgSection.addProvidedSetMethod(XMaterial.class, (xMaterial, section, path) -> section.set(path, xMaterial.name()));
        CfgSection.addProvidedGetMethod(Position.class, (section, s) -> section.getString(s).flatMap(LocationUtil::fromKey).map(Position::new));
        CfgSection.addProvidedSetMethod(Position.class, (position, section, path) -> position.parse().ifPresent(location -> section.set(path, LocationUtil.toKey(location))));
    }

    private BukkitExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

