/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs;

import io.github.portlek.configs.FlManaged;
import io.github.portlek.configs.Provided;
import io.github.portlek.configs.ProvidedGet;
import io.github.portlek.configs.ProvidedSet;
import io.github.portlek.configs.section.ConfigSection;
import io.github.portlek.configs.section.SectionBuilder;
import io.github.portlek.configs.util.GeneralUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simpleyaml.configuration.ConfigurationSection;

public interface CfgSection {
    public static final Map<Class<?>, Provided<?>> PROVIDED = new ConcurrentHashMap();
    public static final Map<Class<?>, ProvidedGet<?>> PROVIDED_GET = new ConcurrentHashMap();
    public static final Map<Class<?>, ProvidedSet<?>> PROVIDED_SET = new ConcurrentHashMap();

    @NotNull
    public static <T> Optional<Provided<T>> getProvidedClass(@NotNull Class<T> aClass) {
        return PROVIDED.keySet().stream().filter(aClass::equals).findFirst().map(clss -> PROVIDED.get(clss));
    }

    public static <T> void addProvidedGetMethod(@NotNull Class<T> aClass, @NotNull ProvidedGet<T> provide) {
        if (!PROVIDED_GET.containsKey(aClass)) {
            PROVIDED_GET.put(aClass, provide);
        }
    }

    @NotNull
    public static <T> Optional<ProvidedGet<T>> getProvidedGetMethod(@NotNull Class<T> aClass) {
        return PROVIDED_GET.keySet().stream().filter(aClass::equals).findFirst().map(clss -> PROVIDED_GET.get(clss));
    }

    public static <T> void addProvidedSetMethod(@NotNull Class<T> aClass, @NotNull ProvidedSet<T> provide) {
        if (!PROVIDED_SET.containsKey(aClass)) {
            PROVIDED_SET.put(aClass, provide);
        }
    }

    @NotNull
    public static <T> Optional<ProvidedSet<T>> getProvidedSetMethod(@NotNull Class<T> aClass) {
        return PROVIDED_SET.keySet().stream().filter(aClass::equals).findFirst().map(clss -> PROVIDED_SET.get(clss));
    }

    public static <T> void addProvidedClass(@NotNull Class<T> tclass, @NotNull Provided<T> provided) {
        if (!PROVIDED.containsKey(tclass)) {
            PROVIDED.put(tclass, provided);
        }
    }

    @NotNull
    default public SectionBuilder builder() {
        return new SectionBuilder(this);
    }

    @NotNull
    default public String getName() {
        return this.getConfigurationSection().getName();
    }

    @NotNull
    default public Set<String> getKeys(boolean deep) {
        return this.getConfigurationSection().getKeys(deep);
    }

    default public boolean contains(@NotNull String path) {
        return this.getConfigurationSection().contains(path);
    }

    default public void remove(@NotNull String path) {
        this.set(path, null);
    }

    @NotNull
    default public Optional<Object> get(@NotNull String path, @Nullable Object def) {
        return Optional.ofNullable(this.getConfigurationSection().get(path, def));
    }

    @NotNull
    default public <T> T getOrSetGeneric(@NotNull String path, @NotNull T fallback, @NotNull Function<String, Optional<T>> function) {
        return (T)function.apply(path).orElseGet(() -> {
            this.set(path, fallback);
            return fallback;
        });
    }

    @NotNull
    default public <T> Optional<T> getGeneric(@NotNull String path, @NotNull Function<String, T> function) {
        if (this.contains(path)) {
            return Optional.ofNullable(function.apply(path));
        }
        return Optional.empty();
    }

    @NotNull
    default public UUID getOrSetUniqueId(@NotNull String path, @NotNull UUID fallback) {
        return this.getOrSetGeneric(path, fallback, this::getUniqueId);
    }

    @NotNull
    default public UUID getOrSetUniqueId(@NotNull String path, @NotNull String fallback) {
        return this.getOrSetUniqueId(path, UUID.fromString(fallback));
    }

    default public String getOrSetString(@NotNull String path, @NotNull String fallback) {
        return this.getOrSetGeneric(path, fallback, this::getString);
    }

    @NotNull
    default public Long getOrSetLong(@NotNull String path, @NotNull Long fallback) {
        return this.getOrSetGeneric(path, fallback, this::getLong);
    }

    @NotNull
    default public Integer getOrSetInteger(@NotNull String path, @NotNull Integer fallback) {
        return this.getOrSetGeneric(path, fallback, this::getInteger);
    }

    @NotNull
    default public Boolean getOrSetBoolean(@NotNull String path, @NotNull Boolean fallback) {
        return this.getOrSetGeneric(path, fallback, this::getBoolean);
    }

    @NotNull
    default public Double getOrSetDouble(@NotNull String path, @NotNull Double fallback) {
        return this.getOrSetGeneric(path, fallback, this::getDouble);
    }

    @NotNull
    default public List<String> getOrSetStringList(@NotNull String path, @NotNull List<String> fallback) {
        return this.getOrSetGeneric(path, fallback, this::getStringList);
    }

    @NotNull
    default public List<Integer> getOrSetIntegerList(@NotNull String path, @NotNull List<Integer> fallback) {
        return this.getOrSetGeneric(path, fallback, this::getIntegerList);
    }

    @NotNull
    default public List<Boolean> getOrSetBooleanList(@NotNull String path, @NotNull List<Boolean> fallback) {
        return this.getOrSetGeneric(path, fallback, this::getBooleanList);
    }

    @NotNull
    default public List<Byte> getOrSetByteList(@NotNull String path, @NotNull List<Byte> fallback) {
        return this.getOrSetGeneric(path, fallback, this::getByteList);
    }

    @NotNull
    default public List<Character> getOrSetCharacterList(@NotNull String path, @NotNull List<Character> fallback) {
        return this.getOrSetGeneric(path, fallback, this::getCharacterList);
    }

    @NotNull
    default public List<Double> getOrSetDoubleList(@NotNull String path, @NotNull List<Double> fallback) {
        return this.getOrSetGeneric(path, fallback, this::getDoubleList);
    }

    @NotNull
    default public List<Float> getOrSetFloatList(@NotNull String path, @NotNull List<Float> fallback) {
        return this.getOrSetGeneric(path, fallback, this::getFloatList);
    }

    @NotNull
    default public List<Long> getOrSetLongList(@NotNull String path, @NotNull List<Long> fallback) {
        return this.getOrSetGeneric(path, fallback, this::getLongList);
    }

    @NotNull
    default public List<Short> getOrSetShortList(@NotNull String path, @NotNull List<Short> fallback) {
        return this.getOrSetGeneric(path, fallback, this::getShortList);
    }

    @NotNull
    default public List<Map<?, ?>> getOrSetMapList(@NotNull String path, @NotNull List<Map<?, ?>> fallback) {
        return this.getOrSetGeneric(path, fallback, this::getMapList);
    }

    @NotNull
    default public Optional<Object> get(@NotNull String path) {
        return Optional.ofNullable(this.getConfigurationSection().get(path));
    }

    default public void set(@NotNull String path, @Nullable Object object) {
        this.getConfigurationSection().set(path, object);
        this.getParent().autoSave();
    }

    @NotNull
    default public CfgSection getOrCreateSection(@NotNull String path) {
        return this.getSection(path).orElseGet(() -> this.createSection(path));
    }

    @NotNull
    default public Optional<CfgSection> getSection(@NotNull String path) {
        return Optional.ofNullable(this.getConfigurationSection().getConfigurationSection(path)).map(configurationsection -> {
            CfgSection configsection = this.getNewSection().get();
            configsection.setup(this.getParent(), (ConfigurationSection)configurationsection);
            return configsection;
        });
    }

    @NotNull
    default public CfgSection createSection(@NotNull String path) {
        CfgSection configsection = this.getNewSection().get();
        configsection.setup(this.getParent(), this.getConfigurationSection().createSection(path));
        this.getParent().autoSave();
        return configsection;
    }

    @NotNull
    default public Supplier<CfgSection> getNewSection() {
        return ConfigSection::new;
    }

    @NotNull
    default public Optional<UUID> getUniqueId(@NotNull String path) {
        return this.getString(path).flatMap(GeneralUtilities::parseUniqueId);
    }

    @NotNull
    default public Optional<UUID> getUniqueId(@NotNull String path, @Nullable String def) {
        Optional<UUID> uuid = this.getUniqueId(path);
        if (uuid.isPresent()) {
            return uuid;
        }
        return Optional.ofNullable(def).flatMap(defUniqueId -> {
            try {
                return Optional.of(UUID.fromString(defUniqueId));
            }
            catch (IllegalArgumentException e) {
                return Optional.empty();
            }
        });
    }

    @NotNull
    default public Optional<UUID> getUniqueId(@NotNull String path, @Nullable UUID def) {
        Optional<UUID> uuid = this.getUniqueId(path);
        if (uuid.isPresent()) {
            return uuid;
        }
        return Optional.ofNullable(def);
    }

    @NotNull
    default public Optional<String> getString(@NotNull String path) {
        return Optional.ofNullable(this.getConfigurationSection().getString(path));
    }

    @NotNull
    default public Optional<String> getString(@NotNull String path, @Nullable String def) {
        return Optional.ofNullable(this.getConfigurationSection().getString(path, def));
    }

    @NotNull
    default public String getStringOrEmpty(@NotNull String path) {
        return this.getString(path).orElse("");
    }

    @NotNull
    default public String getStringOrEmpty(@NotNull String path, @Nullable String def) {
        return this.getString(path, def).orElse("");
    }

    default public Optional<Integer> getInteger(@NotNull String path) {
        return this.getGeneric(path, this.getConfigurationSection()::getInt);
    }

    default public int getInteger(@NotNull String path, int def) {
        return this.getConfigurationSection().getInt(path, def);
    }

    default public Optional<Boolean> getBoolean(@NotNull String path) {
        return this.getGeneric(path, this.getConfigurationSection()::getBoolean);
    }

    default public boolean getBoolean(@NotNull String path, boolean def) {
        return this.getConfigurationSection().getBoolean(path, def);
    }

    default public Optional<Double> getDouble(@NotNull String path) {
        return this.getGeneric(path, this.getConfigurationSection()::getDouble);
    }

    default public double getDouble(@NotNull String path, double def) {
        return this.getConfigurationSection().getDouble(path, def);
    }

    default public Optional<Long> getLong(@NotNull String path) {
        return this.getGeneric(path, this.getConfigurationSection()::getLong);
    }

    default public long getLong(@NotNull String path, long def) {
        return this.getConfigurationSection().getLong(path, def);
    }

    @NotNull
    default public Optional<List<String>> getStringList(@NotNull String path) {
        return this.getGeneric(path, this.getConfigurationSection()::getStringList);
    }

    @NotNull
    default public Optional<List<String>> getStringList(@NotNull String path, @Nullable List<String> def) {
        Optional<List<String>> generic = this.getStringList(path);
        if (generic.isPresent()) {
            return generic;
        }
        return Optional.ofNullable(def);
    }

    @NotNull
    default public List<String> getStringListOrEmpty(@NotNull String path) {
        return this.getStringList(path).orElse(new ArrayList());
    }

    @NotNull
    default public List<String> getStringListOrEmpty(@NotNull String path, @Nullable List<String> def) {
        return this.getStringList(path, def).orElse(new ArrayList());
    }

    @NotNull
    default public Optional<List<Integer>> getIntegerList(@NotNull String path) {
        return this.getGeneric(path, this.getConfigurationSection()::getIntegerList);
    }

    @NotNull
    default public Optional<List<Integer>> getIntegerList(@NotNull String path, @Nullable List<Integer> def) {
        Optional<List<Integer>> generic = this.getIntegerList(path);
        if (generic.isPresent()) {
            return generic;
        }
        return Optional.ofNullable(def);
    }

    @NotNull
    default public List<Integer> getIntegerListOrEmpty(@NotNull String path) {
        return this.getIntegerList(path).orElse(new ArrayList());
    }

    @NotNull
    default public List<Integer> getIntegerListOrEmpty(@NotNull String path, @Nullable List<Integer> def) {
        return this.getIntegerList(path, def).orElse(new ArrayList());
    }

    @NotNull
    default public Optional<List<Boolean>> getBooleanList(@NotNull String path) {
        return this.getGeneric(path, this.getConfigurationSection()::getBooleanList);
    }

    @NotNull
    default public Optional<List<Boolean>> getBooleanList(@NotNull String path, @Nullable List<Boolean> def) {
        Optional<List<Boolean>> generic = this.getBooleanList(path);
        if (generic.isPresent()) {
            return generic;
        }
        return Optional.ofNullable(def);
    }

    @NotNull
    default public List<Boolean> getBooleanListOrEmpty(@NotNull String path) {
        return this.getBooleanList(path).orElse(new ArrayList());
    }

    @NotNull
    default public List<Boolean> getBooleanListOrEmpty(@NotNull String path, @Nullable List<Boolean> def) {
        return this.getBooleanList(path, def).orElse(new ArrayList());
    }

    @NotNull
    default public Optional<List<Double>> getDoubleList(@NotNull String path) {
        return this.getGeneric(path, this.getConfigurationSection()::getDoubleList);
    }

    @NotNull
    default public Optional<List<Double>> getDoubleList(@NotNull String path, @Nullable List<Double> def) {
        Optional<List<Double>> generic = this.getDoubleList(path);
        if (generic.isPresent()) {
            return generic;
        }
        return Optional.ofNullable(def);
    }

    @NotNull
    default public List<Double> getDoubleListOrEmpty(@NotNull String path) {
        return this.getDoubleList(path).orElse(new ArrayList());
    }

    @NotNull
    default public List<Double> getDoubleListOrEmpty(@NotNull String path, @Nullable List<Double> def) {
        return this.getDoubleList(path, def).orElse(new ArrayList());
    }

    @NotNull
    default public Optional<List<Float>> getFloatList(@NotNull String path) {
        return this.getGeneric(path, this.getConfigurationSection()::getFloatList);
    }

    @NotNull
    default public Optional<List<Float>> getFloatList(@NotNull String path, @Nullable List<Float> def) {
        Optional<List<Float>> generic = this.getFloatList(path);
        if (generic.isPresent()) {
            return generic;
        }
        return Optional.ofNullable(def);
    }

    @NotNull
    default public List<Float> getFloatListOrEmpty(@NotNull String path) {
        return this.getFloatList(path).orElse(new ArrayList());
    }

    @NotNull
    default public List<Float> getFloatListOrEmpty(@NotNull String path, @Nullable List<Float> def) {
        return this.getFloatList(path, def).orElse(new ArrayList());
    }

    @NotNull
    default public Optional<List<Long>> getLongList(@NotNull String path) {
        return this.getGeneric(path, this.getConfigurationSection()::getLongList);
    }

    @NotNull
    default public Optional<List<Long>> getLongList(@NotNull String path, @Nullable List<Long> def) {
        Optional<List<Long>> generic = this.getLongList(path);
        if (generic.isPresent()) {
            return generic;
        }
        return Optional.ofNullable(def);
    }

    @NotNull
    default public List<Long> getLongListOrEmpty(@NotNull String path) {
        return this.getLongList(path).orElse(new ArrayList());
    }

    @NotNull
    default public List<Long> getLongListOrEmpty(@NotNull String path, @Nullable List<Long> def) {
        return this.getLongList(path, def).orElse(new ArrayList());
    }

    @NotNull
    default public Optional<List<Byte>> getByteList(@NotNull String path) {
        return this.getGeneric(path, this.getConfigurationSection()::getByteList);
    }

    @NotNull
    default public Optional<List<Byte>> getByteList(@NotNull String path, @Nullable List<Byte> def) {
        Optional<List<Byte>> generic = this.getByteList(path);
        if (generic.isPresent()) {
            return generic;
        }
        return Optional.ofNullable(def);
    }

    @NotNull
    default public List<Byte> getByteListOrEmpty(@NotNull String path) {
        return this.getByteList(path).orElse(new ArrayList());
    }

    @NotNull
    default public List<Byte> getByteListOrEmpty(@NotNull String path, @Nullable List<Byte> def) {
        return this.getByteList(path, def).orElse(new ArrayList());
    }

    @NotNull
    default public Optional<List<Character>> getCharacterList(@NotNull String path) {
        return this.getGeneric(path, this.getConfigurationSection()::getCharacterList);
    }

    @NotNull
    default public Optional<List<Character>> getCharacterList(@NotNull String path, @Nullable List<Character> def) {
        Optional<List<Character>> generic = this.getCharacterList(path);
        if (generic.isPresent()) {
            return generic;
        }
        return Optional.ofNullable(def);
    }

    @NotNull
    default public List<Character> getCharacterListOrEmpty(@NotNull String path) {
        return this.getCharacterList(path).orElse(new ArrayList());
    }

    @NotNull
    default public List<Character> getCharacterListOrEmpty(@NotNull String path, @Nullable List<Character> def) {
        return this.getCharacterList(path, def).orElse(new ArrayList());
    }

    @NotNull
    default public Optional<List<Short>> getShortList(@NotNull String path) {
        return this.getGeneric(path, this.getConfigurationSection()::getShortList);
    }

    @NotNull
    default public Optional<List<Short>> getShortList(@NotNull String path, @Nullable List<Short> def) {
        Optional<List<Short>> generic = this.getShortList(path);
        if (generic.isPresent()) {
            return generic;
        }
        return Optional.ofNullable(def);
    }

    @NotNull
    default public List<Short> getShortListOrEmpty(@NotNull String path) {
        return this.getShortList(path).orElse(new ArrayList());
    }

    @NotNull
    default public List<Short> getShortListOrEmpty(@NotNull String path, @Nullable List<Short> def) {
        return this.getShortList(path, def).orElse(new ArrayList());
    }

    @NotNull
    default public Optional<List<Map<?, ?>>> getMapList(@NotNull String path) {
        return this.getGeneric(path, s -> this.getConfigurationSection().getMapList((String)s));
    }

    @NotNull
    default public Optional<List<Map<?, ?>>> getMapList(@NotNull String path, @Nullable List<Map<?, ?>> def) {
        Optional<List<Map<?, ?>>> generic = this.getMapList(path);
        if (generic.isPresent()) {
            return generic;
        }
        return Optional.ofNullable(def);
    }

    @NotNull
    default public List<Map<?, ?>> getMapListOrEmpty(@NotNull String path) {
        return this.getMapList(path).orElse(new ArrayList());
    }

    @NotNull
    default public List<Map<?, ?>> getMapListOrEmpty(@NotNull String path, @Nullable List<Map<?, ?>> def) {
        return this.getMapList(path, def).orElse(new ArrayList());
    }

    @NotNull
    default public Optional<List<UUID>> getUniqueIdList(@NotNull String path) {
        return this.getStringList(path).map(strings -> strings.stream().map(GeneralUtilities::parseUniqueId).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }

    @NotNull
    default public Optional<List<UUID>> getUniqueIdList(@NotNull String path, @Nullable List<UUID> def) {
        Optional<List<UUID>> generic = this.getUniqueIdList(path);
        if (!generic.isPresent()) {
            return generic;
        }
        return Optional.ofNullable(def);
    }

    @NotNull
    default public List<UUID> getUniqueIdListOrEmpty(@NotNull String path) {
        return this.getUniqueIdList(path).orElse(new ArrayList());
    }

    @NotNull
    default public List<UUID> getUniqueIdListOrEmpty(@NotNull String path, @Nullable List<UUID> def) {
        return this.getUniqueIdList(path, def).orElse(new ArrayList());
    }

    @NotNull
    default public Optional<List<?>> getList(@NotNull String path) {
        return this.getGeneric(path, this.getConfigurationSection()::getList);
    }

    @NotNull
    default public Optional<List<?>> getList(@NotNull String path, @Nullable List<?> def) {
        Optional<List<?>> generic = this.getList(path);
        if (generic.isPresent()) {
            return generic;
        }
        return Optional.ofNullable(def);
    }

    @NotNull
    default public List<?> getListOrEmpty(@NotNull String path) {
        return this.getList(path).orElse(new ArrayList());
    }

    @NotNull
    default public List<?> getListOrEmpty(@NotNull String path, @Nullable List<?> def) {
        return this.getList(path, def).orElse(new ArrayList());
    }

    public void setup(@NotNull FlManaged var1, @NotNull ConfigurationSection var2);

    @NotNull
    public ConfigurationSection getConfigurationSection();

    @NotNull
    public FlManaged getParent();
}

