/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.bukkitlocation;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.jetbrains.annotations.NotNull;

public final class RandomUtil {
    public static final Random RANDOM = new SecureRandom();

    @NotNull
    public static <T> List<T> chooseRandoms(@NotNull List<T> list, int limit, boolean duplicate) {
        if (list.size() <= limit && !duplicate) {
            return Collections.emptyList();
        }
        ArrayList<T> things = new ArrayList<T>();
        int limitClone = limit;
        while (limitClone > 0) {
            T thing = list.get(RandomUtil.random(list.size()));
            if (things.contains(thing) && !duplicate) continue;
            things.add(thing);
            --limitClone;
        }
        return things;
    }

    private static int random(int seed) {
        return RANDOM.nextInt(seed);
    }

    private RandomUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

