/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.bukkitlocation;

import io.github.portlek.bukkitlocation.Directions;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class DirectionUtil {
    @NotNull
    public static Directions directionOf(@NotNull Player player) {
        return DirectionUtil.directionOf(player.getLocation());
    }

    @NotNull
    public static Directions directionOf(@NotNull Location location) {
        return DirectionUtil.directionOf(location.getYaw());
    }

    @NotNull
    public static Directions directionOf(float yaw) {
        return DirectionUtil.directionOf(Arrays.asList(Directions.SOUTH, Directions.WEST, Directions.NORTH, Directions.EAST), yaw);
    }

    @NotNull
    public static Directions doubleDirectionOf(@NotNull Player player) {
        return DirectionUtil.doubleDirectionOf(player.getLocation());
    }

    @NotNull
    public static Directions doubleDirectionOf(@NotNull Location location) {
        return DirectionUtil.doubleDirectionOf(location.getYaw());
    }

    @NotNull
    public static Directions doubleDirectionOf(float yaw) {
        return DirectionUtil.doubleDirectionOf(Arrays.asList(Directions.SOUTH, Directions.SOUTHWEST, Directions.WEST, Directions.NORTHWEST, Directions.NORTH, Directions.NORTHEAST, Directions.EAST, Directions.SOUTHEAST), yaw);
    }

    @NotNull
    private static Directions directionOf(@NotNull List<Directions> directions, float yaw) {
        return directions.get((int)(yaw + 45.0f) % 360 / 90);
    }

    @NotNull
    private static Directions doubleDirectionOf(@NotNull List<Directions> directions, float yaw) {
        return directions.get((int)(yaw + 22.5f) % 360 / 45);
    }

    private DirectionUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

