/*
 * Decompiled with CFR 0.152.
 */
package io.github.bananapuncher714.nbteditor;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public final class NBTEditor {
    private static final Map<String, Class<?>> classCache;
    private static final Map<String, Method> methodCache;
    private static final Map<Class<?>, Constructor<?>> constructorCache;
    private static final Map<Class<?>, Class<?>> NBTClasses;
    private static final Map<Class<?>, Field> NBTTagFieldCache;
    private static Field NBTListData;
    private static Field NBTCompoundMap;
    private static final String VERSION;
    private static final MinecraftVersion LOCAL_VERSION;

    private static Class<?> getNBTTag(Class<?> primitiveType) {
        if (NBTClasses.containsKey(primitiveType)) {
            return NBTClasses.get(primitiveType);
        }
        return primitiveType;
    }

    private static Object getNBTVar(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        try {
            if (NBTTagFieldCache.containsKey(clazz)) {
                return NBTTagFieldCache.get(clazz).get(object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private static Method getMethod(String name) {
        return methodCache.containsKey(name) ? methodCache.get(name) : null;
    }

    private static Constructor<?> getConstructor(Class<?> clazz) {
        return constructorCache.containsKey(clazz) ? constructorCache.get(clazz) : null;
    }

    private static Class<?> getNMSClass(String name) {
        if (classCache.containsKey(name)) {
            return classCache.get(name);
        }
        try {
            return Class.forName("net.minecraft.server." + VERSION + "." + name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getMatch(String string, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static Object createItemStack(Object compound) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
        if (LOCAL_VERSION == MinecraftVersion.v1_11 || LOCAL_VERSION == MinecraftVersion.v1_12) {
            return NBTEditor.getConstructor(NBTEditor.getNMSClass("ItemStack")).newInstance(compound);
        }
        return NBTEditor.getMethod("createStack").invoke(null, compound);
    }

    public static String getVersion() {
        return VERSION;
    }

    public static MinecraftVersion getMinecraftVersion() {
        return LOCAL_VERSION;
    }

    public static ItemStack getHead(String skinURL) {
        Material material = Material.getMaterial((String)"SKULL_ITEM");
        if (material == null) {
            material = Material.getMaterial((String)"PLAYER_HEAD");
        }
        ItemStack head = new ItemStack(material, 1, 3);
        if (skinURL == null || skinURL.isEmpty()) {
            return head;
        }
        ItemMeta headMeta = head.getItemMeta();
        Object profile = null;
        try {
            profile = NBTEditor.getConstructor(NBTEditor.getNMSClass("GameProfile")).newInstance(UUID.randomUUID(), null);
            Object propertyMap = NBTEditor.getMethod("getProperties").invoke(profile, new Object[0]);
            Object textureProperty = NBTEditor.getConstructor(NBTEditor.getNMSClass("Property")).newInstance("textures", new String(Base64.getEncoder().encode(String.format("{textures:{SKIN:{\"url\":\"%s\"}}}", skinURL).getBytes())));
            NBTEditor.getMethod("put").invoke(propertyMap, "textures", textureProperty);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e1) {
            e1.printStackTrace();
        }
        if (methodCache.containsKey("setProfile")) {
            try {
                NBTEditor.getMethod("setProfile").invoke((Object)headMeta, profile);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            Field profileField = null;
            try {
                profileField = headMeta.getClass().getDeclaredField("profile");
            }
            catch (NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
            profileField.setAccessible(true);
            try {
                profileField.set(headMeta, profile);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        head.setItemMeta(headMeta);
        return head;
    }

    public static String getTexture(ItemStack head) {
        ItemMeta meta = head.getItemMeta();
        Field profileField = null;
        try {
            profileField = meta.getClass().getDeclaredField("profile");
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Item is not a player skull!");
        }
        profileField.setAccessible(true);
        try {
            Object profile = profileField.get(meta);
            if (profile == null) {
                return null;
            }
            Collection properties = (Collection)NBTEditor.getMethod("values").invoke(NBTEditor.getMethod("getProperties").invoke(profile, new Object[0]), new Object[0]);
            for (Object prop : properties) {
                if (!"textures".equals(NBTEditor.getMethod("getName").invoke(prop, new Object[0]))) continue;
                String texture = new String(Base64.getDecoder().decode((String)NBTEditor.getMethod("getValue").invoke(prop, new Object[0])));
                return NBTEditor.getMatch(texture, "\\{\"url\":\"(.*?)\"\\}");
            }
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Object getItemTag(ItemStack item, Object ... keys) {
        try {
            return NBTEditor.getTag(NBTEditor.getCompound(item), keys);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Object getCompound(ItemStack item) {
        if (item == null) {
            return null;
        }
        try {
            Object stack = null;
            stack = NBTEditor.getMethod("asNMSCopy").invoke(null, item);
            Object tag = null;
            tag = NBTEditor.getMethod("hasTag").invoke(stack, new Object[0]).equals(true) ? NBTEditor.getMethod("getTag").invoke(stack, new Object[0]) : (Object)NBTEditor.getNMSClass("NBTTagCompound").newInstance();
            return tag;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static NBTCompound getItemNBTTag(ItemStack item, Object ... keys) {
        if (item == null) {
            return null;
        }
        try {
            Object stack = null;
            stack = NBTEditor.getMethod("asNMSCopy").invoke(null, item);
            Object tag = NBTEditor.getNMSClass("NBTTagCompound").newInstance();
            tag = NBTEditor.getMethod("save").invoke(stack, tag);
            return NBTEditor.getNBTTag(tag, keys);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static ItemStack setItemTag(ItemStack item, Object value, Object ... keys) {
        if (item == null) {
            return null;
        }
        try {
            Object stack = NBTEditor.getMethod("asNMSCopy").invoke(null, item);
            Object tag = null;
            tag = NBTEditor.getMethod("hasTag").invoke(stack, new Object[0]).equals(true) ? NBTEditor.getMethod("getTag").invoke(stack, new Object[0]) : (Object)NBTEditor.getNMSClass("NBTTagCompound").newInstance();
            if (keys.length == 0 && value instanceof NBTCompound) {
                tag = ((NBTCompound)value).tag;
            } else {
                NBTEditor.setTag(tag, value, keys);
            }
            NBTEditor.getMethod("setTag").invoke(stack, tag);
            return (ItemStack)NBTEditor.getMethod("asBukkitCopy").invoke(null, stack);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static ItemStack getItemFromTag(NBTCompound compound) {
        if (compound == null) {
            return null;
        }
        try {
            Object tag = compound.tag;
            Object count = NBTEditor.getTag(tag, "Count");
            Object id = NBTEditor.getTag(tag, "id");
            if (count == null || id == null) {
                return null;
            }
            if (count instanceof Byte && id instanceof String) {
                return (ItemStack)NBTEditor.getMethod("asBukkitCopy").invoke(null, NBTEditor.createItemStack(tag));
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static Object getEntityTag(Entity entity, Object ... keys) {
        try {
            return NBTEditor.getTag(NBTEditor.getCompound(entity), keys);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Object getCompound(Entity entity) {
        if (entity == null) {
            return entity;
        }
        try {
            Object NMSEntity = NBTEditor.getMethod("getEntityHandle").invoke((Object)entity, new Object[0]);
            Object tag = NBTEditor.getNMSClass("NBTTagCompound").newInstance();
            NBTEditor.getMethod("getEntityTag").invoke(NMSEntity, tag);
            return tag;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static NBTCompound getEntityNBTTag(Entity entity, Object ... keys) {
        if (entity == null) {
            return null;
        }
        try {
            Object NMSEntity = NBTEditor.getMethod("getEntityHandle").invoke((Object)entity, new Object[0]);
            Object tag = NBTEditor.getNMSClass("NBTTagCompound").newInstance();
            NBTEditor.getMethod("getEntityTag").invoke(NMSEntity, tag);
            return NBTEditor.getNBTTag(tag, keys);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static void setEntityTag(Entity entity, Object value, Object ... keys) {
        if (entity == null) {
            return;
        }
        try {
            Object NMSEntity = NBTEditor.getMethod("getEntityHandle").invoke((Object)entity, new Object[0]);
            Object tag = NBTEditor.getNMSClass("NBTTagCompound").newInstance();
            NBTEditor.getMethod("getEntityTag").invoke(NMSEntity, tag);
            if (keys.length == 0 && value instanceof NBTCompound) {
                tag = ((NBTCompound)value).tag;
            } else {
                NBTEditor.setTag(tag, value, keys);
            }
            NBTEditor.getMethod("setEntityTag").invoke(NMSEntity, tag);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private static Object getBlockTag(Block block, Object ... keys) {
        try {
            return NBTEditor.getTag(NBTEditor.getCompound(block), keys);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Object getCompound(Block block) {
        try {
            if (block == null || !NBTEditor.getNMSClass("CraftBlockState").isInstance(block.getState())) {
                return null;
            }
            Location location = block.getLocation();
            Object blockPosition = NBTEditor.getConstructor(NBTEditor.getNMSClass("BlockPosition")).newInstance(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            Object nmsWorld = NBTEditor.getMethod("getWorldHandle").invoke((Object)location.getWorld(), new Object[0]);
            Object tileEntity = NBTEditor.getMethod("getTileEntity").invoke(nmsWorld, blockPosition);
            Object tag = NBTEditor.getNMSClass("NBTTagCompound").newInstance();
            NBTEditor.getMethod("getTileTag").invoke(tileEntity, tag);
            return tag;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static NBTCompound getBlockNBTTag(Block block, Object ... keys) {
        try {
            if (block == null || !NBTEditor.getNMSClass("CraftBlockState").isInstance(block.getState())) {
                return null;
            }
            Location location = block.getLocation();
            Object blockPosition = NBTEditor.getConstructor(NBTEditor.getNMSClass("BlockPosition")).newInstance(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            Object nmsWorld = NBTEditor.getMethod("getWorldHandle").invoke((Object)location.getWorld(), new Object[0]);
            Object tileEntity = NBTEditor.getMethod("getTileEntity").invoke(nmsWorld, blockPosition);
            Object tag = NBTEditor.getNMSClass("NBTTagCompound").newInstance();
            NBTEditor.getMethod("getTileTag").invoke(tileEntity, tag);
            return NBTEditor.getNBTTag(tag, keys);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static void setBlockTag(Block block, Object value, Object ... keys) {
        try {
            if (block == null || !NBTEditor.getNMSClass("CraftBlockState").isInstance(block.getState())) {
                return;
            }
            Location location = block.getLocation();
            Object blockPosition = NBTEditor.getConstructor(NBTEditor.getNMSClass("BlockPosition")).newInstance(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            Object nmsWorld = NBTEditor.getMethod("getWorldHandle").invoke((Object)location.getWorld(), new Object[0]);
            Object tileEntity = NBTEditor.getMethod("getTileEntity").invoke(nmsWorld, blockPosition);
            Object tag = NBTEditor.getNMSClass("NBTTagCompound").newInstance();
            NBTEditor.getMethod("getTileTag").invoke(tileEntity, tag);
            if (keys.length == 0 && value instanceof NBTCompound) {
                tag = ((NBTCompound)value).tag;
            } else {
                NBTEditor.setTag(tag, value, keys);
            }
            if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_16)) {
                NBTEditor.getMethod("setTileTag").invoke(tileEntity, NBTEditor.getMethod("getType").invoke(nmsWorld, blockPosition), tag);
            } else {
                NBTEditor.getMethod("setTileTag").invoke(tileEntity, tag);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static void setSkullTexture(Block block, String texture) {
        try {
            Object profile = NBTEditor.getConstructor(NBTEditor.getNMSClass("GameProfile")).newInstance(UUID.randomUUID(), null);
            Object propertyMap = NBTEditor.getMethod("getProperties").invoke(profile, new Object[0]);
            Object textureProperty = NBTEditor.getConstructor(NBTEditor.getNMSClass("Property")).newInstance("textures", new String(Base64.getEncoder().encode(String.format("{textures:{SKIN:{\"url\":\"%s\"}}}", texture).getBytes())));
            NBTEditor.getMethod("put").invoke(propertyMap, "textures", textureProperty);
            Location location = block.getLocation();
            Object blockPosition = NBTEditor.getConstructor(NBTEditor.getNMSClass("BlockPosition")).newInstance(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            Object nmsWorld = NBTEditor.getMethod("getWorldHandle").invoke((Object)location.getWorld(), new Object[0]);
            Object tileEntity = NBTEditor.getMethod("getTileEntity").invoke(nmsWorld, blockPosition);
            NBTEditor.getMethod("setGameProfile").invoke(tileEntity, profile);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static Object getValue(Object object, Object ... keys) {
        if (object instanceof ItemStack) {
            return NBTEditor.getItemTag((ItemStack)object, keys);
        }
        if (object instanceof Entity) {
            return NBTEditor.getEntityTag((Entity)object, keys);
        }
        if (object instanceof Block) {
            return NBTEditor.getBlockTag((Block)object, keys);
        }
        if (object instanceof NBTCompound) {
            try {
                return NBTEditor.getTag(((NBTCompound)object).tag, keys);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }
        throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, Block, or NBTCompound!");
    }

    public static NBTCompound getNBTCompound(Object object, Object ... keys) {
        if (object instanceof ItemStack) {
            return NBTEditor.getItemNBTTag((ItemStack)object, keys);
        }
        if (object instanceof Entity) {
            return NBTEditor.getEntityNBTTag((Entity)object, keys);
        }
        if (object instanceof Block) {
            return NBTEditor.getBlockNBTTag((Block)object, keys);
        }
        if (object instanceof NBTCompound) {
            try {
                return NBTEditor.getNBTTag(((NBTCompound)object).tag, keys);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (NBTEditor.getNMSClass("NBTTagCompound").isInstance(object)) {
            try {
                return NBTEditor.getNBTTag(object, keys);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }
        throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, Block, or NBTCompound!");
    }

    public static String getString(Object object, Object ... keys) {
        Object result = NBTEditor.getValue(object, keys);
        return result instanceof String ? (String)result : null;
    }

    public static int getInt(Object object, Object ... keys) {
        Object result = NBTEditor.getValue(object, keys);
        return result instanceof Integer ? (Integer)result : 0;
    }

    public static double getDouble(Object object, Object ... keys) {
        Object result = NBTEditor.getValue(object, keys);
        return result instanceof Double ? (Double)result : 0.0;
    }

    public static long getLong(Object object, Object ... keys) {
        Object result = NBTEditor.getValue(object, keys);
        return result instanceof Long ? (Long)result : 0L;
    }

    public static float getFloat(Object object, Object ... keys) {
        Object result = NBTEditor.getValue(object, keys);
        return result instanceof Float ? ((Float)result).floatValue() : 0.0f;
    }

    public static short getShort(Object object, Object ... keys) {
        Object result = NBTEditor.getValue(object, keys);
        return result instanceof Short ? (Short)result : (short)0;
    }

    public static byte getByte(Object object, Object ... keys) {
        Object result = NBTEditor.getValue(object, keys);
        return result instanceof Byte ? (Byte)result : (byte)0;
    }

    public static boolean getBoolean(Object object, Object ... keys) {
        return NBTEditor.getByte(object, keys) == 1;
    }

    public static byte[] getByteArray(Object object, Object ... keys) {
        Object result = NBTEditor.getValue(object, keys);
        return result instanceof byte[] ? (byte[])result : null;
    }

    public static int[] getIntArray(Object object, Object ... keys) {
        Object result = NBTEditor.getValue(object, keys);
        return result instanceof int[] ? (int[])result : null;
    }

    public static boolean contains(Object object, Object ... keys) {
        Object result = NBTEditor.getValue(object, keys);
        return result != null;
    }

    public static Collection<String> getKeys(Object object, Object ... keys) {
        Object compound;
        if (object instanceof ItemStack) {
            compound = NBTEditor.getCompound((ItemStack)object);
        } else if (object instanceof Entity) {
            compound = NBTEditor.getCompound((Entity)object);
        } else if (object instanceof Block) {
            compound = NBTEditor.getCompound((Block)object);
        } else if (object instanceof NBTCompound) {
            compound = ((NBTCompound)object).tag;
        } else {
            throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, Block, or NBTCompound!");
        }
        try {
            NBTCompound nbtCompound = NBTEditor.getNBTTag(compound, keys);
            Object tag = nbtCompound.tag;
            if (NBTEditor.getNMSClass("NBTTagCompound").isInstance(tag)) {
                return (Collection)NBTEditor.getMethod("getKeys").invoke(tag, new Object[0]);
            }
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getSize(Object object, Object ... keys) {
        Object compound;
        if (object instanceof ItemStack) {
            compound = NBTEditor.getCompound((ItemStack)object);
        } else if (object instanceof Entity) {
            compound = NBTEditor.getCompound((Entity)object);
        } else if (object instanceof Block) {
            compound = NBTEditor.getCompound((Block)object);
        } else if (object instanceof NBTCompound) {
            compound = ((NBTCompound)object).tag;
        } else {
            throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, Block, or NBTCompound!");
        }
        try {
            NBTCompound nbtCompound = NBTEditor.getNBTTag(compound, keys);
            if (NBTEditor.getNMSClass("NBTTagCompound").isInstance(nbtCompound.tag)) {
                return NBTEditor.getKeys(nbtCompound, new Object[0]).size();
            }
            if (NBTEditor.getNMSClass("NBTTagList").isInstance(nbtCompound.tag)) {
                return (Integer)NBTEditor.getMethod("size").invoke(nbtCompound.tag, new Object[0]);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return 0;
        }
        throw new IllegalArgumentException("Value is not a compound or list!");
    }

    public static <T> T set(T object, Object value, Object ... keys) {
        if (object instanceof ItemStack) {
            return (T)NBTEditor.setItemTag((ItemStack)object, value, keys);
        }
        if (object instanceof Entity) {
            NBTEditor.setEntityTag((Entity)object, value, keys);
        } else if (object instanceof Block) {
            NBTEditor.setBlockTag((Block)object, value, keys);
        } else if (object instanceof NBTCompound) {
            try {
                NBTEditor.setTag(((NBTCompound)object).tag, value, keys);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, Block, or NBTCompound!");
        }
        return object;
    }

    public static NBTCompound getNBTCompound(String json) {
        return NBTCompound.fromJson(json);
    }

    public static NBTCompound getEmptyNBTCompound() {
        try {
            return new NBTCompound(NBTEditor.getNMSClass("NBTTagCompound").newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void setTag(Object tag, Object value, Object ... keys) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object notCompound;
        if (value != null) {
            if (value instanceof NBTCompound) {
                notCompound = ((NBTCompound)value).tag;
            } else if (NBTEditor.getNMSClass("NBTTagList").isInstance(value) || NBTEditor.getNMSClass("NBTTagCompound").isInstance(value)) {
                notCompound = value;
            } else {
                if (value instanceof Boolean) {
                    value = (byte)((Boolean)value == true ? 1 : 0);
                }
                notCompound = NBTEditor.getConstructor(NBTEditor.getNBTTag(value.getClass())).newInstance(value);
            }
        } else {
            notCompound = null;
        }
        Object compound = tag;
        for (int index = 0; index < keys.length - 1; ++index) {
            Object key = keys[index];
            Object oldCompound = compound;
            if (key instanceof Integer) {
                compound = ((List)NBTListData.get(compound)).get((Integer)key);
            } else if (key != null) {
                compound = NBTEditor.getMethod("get").invoke(compound, (String)key);
            }
            if (compound != null && key != null) continue;
            compound = keys[index + 1] == null || keys[index + 1] instanceof Integer ? NBTEditor.getNMSClass("NBTTagList").newInstance() : NBTEditor.getNMSClass("NBTTagCompound").newInstance();
            if (oldCompound.getClass().getSimpleName().equals("NBTTagList")) {
                if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_14)) {
                    NBTEditor.getMethod("add").invoke(oldCompound, NBTEditor.getMethod("size").invoke(oldCompound, new Object[0]), compound);
                    continue;
                }
                NBTEditor.getMethod("add").invoke(oldCompound, compound);
                continue;
            }
            NBTEditor.getMethod("set").invoke(oldCompound, (String)key, compound);
        }
        if (keys.length > 0) {
            Object lastKey = keys[keys.length - 1];
            if (lastKey == null) {
                if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_14)) {
                    NBTEditor.getMethod("add").invoke(compound, NBTEditor.getMethod("size").invoke(compound, new Object[0]), notCompound);
                } else {
                    NBTEditor.getMethod("add").invoke(compound, notCompound);
                }
            } else if (lastKey instanceof Integer) {
                if (notCompound == null) {
                    NBTEditor.getMethod("listRemove").invoke(compound, (int)((Integer)lastKey));
                } else {
                    NBTEditor.getMethod("setIndex").invoke(compound, (int)((Integer)lastKey), notCompound);
                }
            } else if (notCompound == null) {
                NBTEditor.getMethod("remove").invoke(compound, (String)lastKey);
            } else {
                NBTEditor.getMethod("set").invoke(compound, (String)lastKey, notCompound);
            }
        } else if (notCompound != null) {
            // empty if block
        }
    }

    private static NBTCompound getNBTTag(Object tag, Object ... keys) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object compound = tag;
        for (Object key : keys) {
            if (compound == null) {
                return null;
            }
            if (NBTEditor.getNMSClass("NBTTagCompound").isInstance(compound)) {
                compound = NBTEditor.getMethod("get").invoke(compound, (String)key);
                continue;
            }
            if (!NBTEditor.getNMSClass("NBTTagList").isInstance(compound)) continue;
            compound = ((List)NBTListData.get(compound)).get((Integer)key);
        }
        return new NBTCompound(compound);
    }

    private static Object getTag(Object tag, Object ... keys) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (keys.length == 0) {
            return NBTEditor.getTags(tag);
        }
        Object notCompound = tag;
        for (Object key : keys) {
            if (notCompound == null) {
                return null;
            }
            if (NBTEditor.getNMSClass("NBTTagCompound").isInstance(notCompound)) {
                notCompound = NBTEditor.getMethod("get").invoke(notCompound, (String)key);
                continue;
            }
            if (NBTEditor.getNMSClass("NBTTagList").isInstance(notCompound)) {
                notCompound = ((List)NBTListData.get(notCompound)).get((Integer)key);
                continue;
            }
            return NBTEditor.getNBTVar(notCompound);
        }
        if (notCompound == null) {
            return null;
        }
        if (NBTEditor.getNMSClass("NBTTagList").isInstance(notCompound)) {
            return NBTEditor.getTags(notCompound);
        }
        if (NBTEditor.getNMSClass("NBTTagCompound").isInstance(notCompound)) {
            return NBTEditor.getTags(notCompound);
        }
        return NBTEditor.getNBTVar(notCompound);
    }

    private static Object getTags(Object tag) {
        HashMap<Object, Object> tags = new HashMap<Object, Object>();
        try {
            if (NBTEditor.getNMSClass("NBTTagCompound").isInstance(tag)) {
                Map tagCompound = (Map)NBTCompoundMap.get(tag);
                for (String key : tagCompound.keySet()) {
                    Object value = tagCompound.get(key);
                    if (NBTEditor.getNMSClass("NBTTagEnd").isInstance(value)) continue;
                    tags.put(key, NBTEditor.getTag(value, new Object[0]));
                }
            } else if (NBTEditor.getNMSClass("NBTTagList").isInstance(tag)) {
                List tagList = (List)NBTListData.get(tag);
                for (int index = 0; index < tagList.size(); ++index) {
                    Object value = tagList.get(index);
                    if (NBTEditor.getNMSClass("NBTTagEnd").isInstance(value)) continue;
                    tags.put(index, NBTEditor.getTag(value, new Object[0]));
                }
            } else {
                return NBTEditor.getNBTVar(tag);
            }
            return tags;
        }
        catch (Exception e) {
            e.printStackTrace();
            return tags;
        }
    }

    static {
        VERSION = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        LOCAL_VERSION = MinecraftVersion.get(VERSION);
        classCache = new HashMap();
        try {
            classCache.put("NBTBase", Class.forName("net.minecraft.server." + VERSION + ".NBTBase"));
            classCache.put("NBTTagCompound", Class.forName("net.minecraft.server." + VERSION + ".NBTTagCompound"));
            classCache.put("NBTTagList", Class.forName("net.minecraft.server." + VERSION + ".NBTTagList"));
            classCache.put("MojangsonParser", Class.forName("net.minecraft.server." + VERSION + ".MojangsonParser"));
            classCache.put("ItemStack", Class.forName("net.minecraft.server." + VERSION + ".ItemStack"));
            classCache.put("CraftItemStack", Class.forName("org.bukkit.craftbukkit." + VERSION + ".inventory.CraftItemStack"));
            classCache.put("CraftMetaSkull", Class.forName("org.bukkit.craftbukkit." + VERSION + ".inventory.CraftMetaSkull"));
            classCache.put("Entity", Class.forName("net.minecraft.server." + VERSION + ".Entity"));
            classCache.put("CraftEntity", Class.forName("org.bukkit.craftbukkit." + VERSION + ".entity.CraftEntity"));
            classCache.put("EntityLiving", Class.forName("net.minecraft.server." + VERSION + ".EntityLiving"));
            classCache.put("CraftWorld", Class.forName("org.bukkit.craftbukkit." + VERSION + ".CraftWorld"));
            classCache.put("CraftBlockState", Class.forName("org.bukkit.craftbukkit." + VERSION + ".block.CraftBlockState"));
            classCache.put("BlockPosition", Class.forName("net.minecraft.server." + VERSION + ".BlockPosition"));
            classCache.put("TileEntity", Class.forName("net.minecraft.server." + VERSION + ".TileEntity"));
            classCache.put("World", Class.forName("net.minecraft.server." + VERSION + ".World"));
            classCache.put("IBlockData", Class.forName("net.minecraft.server." + VERSION + ".IBlockData"));
            classCache.put("TileEntitySkull", Class.forName("net.minecraft.server." + VERSION + ".TileEntitySkull"));
            classCache.put("GameProfile", Class.forName("com.mojang.authlib.GameProfile"));
            classCache.put("Property", Class.forName("com.mojang.authlib.properties.Property"));
            classCache.put("PropertyMap", Class.forName("com.mojang.authlib.properties.PropertyMap"));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        NBTClasses = new HashMap();
        try {
            NBTClasses.put(Byte.class, Class.forName("net.minecraft.server." + VERSION + ".NBTTagByte"));
            NBTClasses.put(Boolean.class, Class.forName("net.minecraft.server." + VERSION + ".NBTTagByte"));
            NBTClasses.put(String.class, Class.forName("net.minecraft.server." + VERSION + ".NBTTagString"));
            NBTClasses.put(Double.class, Class.forName("net.minecraft.server." + VERSION + ".NBTTagDouble"));
            NBTClasses.put(Integer.class, Class.forName("net.minecraft.server." + VERSION + ".NBTTagInt"));
            NBTClasses.put(Long.class, Class.forName("net.minecraft.server." + VERSION + ".NBTTagLong"));
            NBTClasses.put(Short.class, Class.forName("net.minecraft.server." + VERSION + ".NBTTagShort"));
            NBTClasses.put(Float.class, Class.forName("net.minecraft.server." + VERSION + ".NBTTagFloat"));
            NBTClasses.put(Class.forName("[B"), Class.forName("net.minecraft.server." + VERSION + ".NBTTagByteArray"));
            NBTClasses.put(Class.forName("[I"), Class.forName("net.minecraft.server." + VERSION + ".NBTTagIntArray"));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        methodCache = new HashMap<String, Method>();
        try {
            methodCache.put("get", NBTEditor.getNMSClass("NBTTagCompound").getMethod("get", String.class));
            methodCache.put("set", NBTEditor.getNMSClass("NBTTagCompound").getMethod("set", String.class, NBTEditor.getNMSClass("NBTBase")));
            methodCache.put("hasKey", NBTEditor.getNMSClass("NBTTagCompound").getMethod("hasKey", String.class));
            methodCache.put("setIndex", NBTEditor.getNMSClass("NBTTagList").getMethod("a", Integer.TYPE, NBTEditor.getNMSClass("NBTBase")));
            if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_14)) {
                methodCache.put("getTypeId", NBTEditor.getNMSClass("NBTBase").getMethod("getTypeId", new Class[0]));
                methodCache.put("add", NBTEditor.getNMSClass("NBTTagList").getMethod("add", Integer.TYPE, NBTEditor.getNMSClass("NBTBase")));
            } else {
                methodCache.put("add", NBTEditor.getNMSClass("NBTTagList").getMethod("add", NBTEditor.getNMSClass("NBTBase")));
            }
            methodCache.put("size", NBTEditor.getNMSClass("NBTTagList").getMethod("size", new Class[0]));
            if (LOCAL_VERSION == MinecraftVersion.v1_8) {
                methodCache.put("listRemove", NBTEditor.getNMSClass("NBTTagList").getMethod("a", Integer.TYPE));
            } else {
                methodCache.put("listRemove", NBTEditor.getNMSClass("NBTTagList").getMethod("remove", Integer.TYPE));
            }
            methodCache.put("remove", NBTEditor.getNMSClass("NBTTagCompound").getMethod("remove", String.class));
            if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_13)) {
                methodCache.put("getKeys", NBTEditor.getNMSClass("NBTTagCompound").getMethod("getKeys", new Class[0]));
            } else {
                methodCache.put("getKeys", NBTEditor.getNMSClass("NBTTagCompound").getMethod("c", new Class[0]));
            }
            methodCache.put("hasTag", NBTEditor.getNMSClass("ItemStack").getMethod("hasTag", new Class[0]));
            methodCache.put("getTag", NBTEditor.getNMSClass("ItemStack").getMethod("getTag", new Class[0]));
            methodCache.put("setTag", NBTEditor.getNMSClass("ItemStack").getMethod("setTag", NBTEditor.getNMSClass("NBTTagCompound")));
            methodCache.put("asNMSCopy", NBTEditor.getNMSClass("CraftItemStack").getMethod("asNMSCopy", ItemStack.class));
            methodCache.put("asBukkitCopy", NBTEditor.getNMSClass("CraftItemStack").getMethod("asBukkitCopy", NBTEditor.getNMSClass("ItemStack")));
            methodCache.put("getEntityHandle", NBTEditor.getNMSClass("CraftEntity").getMethod("getHandle", new Class[0]));
            if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_16)) {
                methodCache.put("getEntityTag", NBTEditor.getNMSClass("Entity").getMethod("save", NBTEditor.getNMSClass("NBTTagCompound")));
                methodCache.put("setEntityTag", NBTEditor.getNMSClass("Entity").getMethod("load", NBTEditor.getNMSClass("NBTTagCompound")));
            } else {
                methodCache.put("getEntityTag", NBTEditor.getNMSClass("Entity").getMethod("c", NBTEditor.getNMSClass("NBTTagCompound")));
                methodCache.put("setEntityTag", NBTEditor.getNMSClass("Entity").getMethod("f", NBTEditor.getNMSClass("NBTTagCompound")));
            }
            methodCache.put("save", NBTEditor.getNMSClass("ItemStack").getMethod("save", NBTEditor.getNMSClass("NBTTagCompound")));
            if (LOCAL_VERSION.lessThanOrEqualTo(MinecraftVersion.v1_10)) {
                methodCache.put("createStack", NBTEditor.getNMSClass("ItemStack").getMethod("createStack", NBTEditor.getNMSClass("NBTTagCompound")));
            } else if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_13)) {
                methodCache.put("createStack", NBTEditor.getNMSClass("ItemStack").getMethod("a", NBTEditor.getNMSClass("NBTTagCompound")));
            }
            if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_16)) {
                methodCache.put("setTileTag", NBTEditor.getNMSClass("TileEntity").getMethod("load", NBTEditor.getNMSClass("IBlockData"), NBTEditor.getNMSClass("NBTTagCompound")));
                methodCache.put("getType", NBTEditor.getNMSClass("World").getMethod("getType", NBTEditor.getNMSClass("BlockPosition")));
            } else if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_12)) {
                methodCache.put("setTileTag", NBTEditor.getNMSClass("TileEntity").getMethod("load", NBTEditor.getNMSClass("NBTTagCompound")));
            } else {
                methodCache.put("setTileTag", NBTEditor.getNMSClass("TileEntity").getMethod("a", NBTEditor.getNMSClass("NBTTagCompound")));
            }
            methodCache.put("getTileEntity", NBTEditor.getNMSClass("World").getMethod("getTileEntity", NBTEditor.getNMSClass("BlockPosition")));
            methodCache.put("getWorldHandle", NBTEditor.getNMSClass("CraftWorld").getMethod("getHandle", new Class[0]));
            methodCache.put("setGameProfile", NBTEditor.getNMSClass("TileEntitySkull").getMethod("setGameProfile", NBTEditor.getNMSClass("GameProfile")));
            methodCache.put("getProperties", NBTEditor.getNMSClass("GameProfile").getMethod("getProperties", new Class[0]));
            methodCache.put("getName", NBTEditor.getNMSClass("Property").getMethod("getName", new Class[0]));
            methodCache.put("getValue", NBTEditor.getNMSClass("Property").getMethod("getValue", new Class[0]));
            methodCache.put("values", NBTEditor.getNMSClass("PropertyMap").getMethod("values", new Class[0]));
            methodCache.put("put", NBTEditor.getNMSClass("PropertyMap").getMethod("put", Object.class, Object.class));
            methodCache.put("loadNBTTagCompound", NBTEditor.getNMSClass("MojangsonParser").getMethod("parse", String.class));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            methodCache.put("getTileTag", NBTEditor.getNMSClass("TileEntity").getMethod("save", NBTEditor.getNMSClass("NBTTagCompound")));
        }
        catch (NoSuchMethodException exception) {
            try {
                methodCache.put("getTileTag", NBTEditor.getNMSClass("TileEntity").getMethod("b", NBTEditor.getNMSClass("NBTTagCompound")));
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            methodCache.put("setProfile", NBTEditor.getNMSClass("CraftMetaSkull").getDeclaredMethod("setProfile", NBTEditor.getNMSClass("GameProfile")));
            methodCache.get("setProfile").setAccessible(true);
        }
        catch (NoSuchMethodException exception) {
            // empty catch block
        }
        constructorCache = new HashMap();
        try {
            constructorCache.put(NBTEditor.getNBTTag(Byte.class), NBTEditor.getNBTTag(Byte.class).getDeclaredConstructor(Byte.TYPE));
            constructorCache.put(NBTEditor.getNBTTag(Boolean.class), NBTEditor.getNBTTag(Boolean.class).getDeclaredConstructor(Byte.TYPE));
            constructorCache.put(NBTEditor.getNBTTag(String.class), NBTEditor.getNBTTag(String.class).getDeclaredConstructor(String.class));
            constructorCache.put(NBTEditor.getNBTTag(Double.class), NBTEditor.getNBTTag(Double.class).getDeclaredConstructor(Double.TYPE));
            constructorCache.put(NBTEditor.getNBTTag(Integer.class), NBTEditor.getNBTTag(Integer.class).getDeclaredConstructor(Integer.TYPE));
            constructorCache.put(NBTEditor.getNBTTag(Long.class), NBTEditor.getNBTTag(Long.class).getDeclaredConstructor(Long.TYPE));
            constructorCache.put(NBTEditor.getNBTTag(Float.class), NBTEditor.getNBTTag(Float.class).getDeclaredConstructor(Float.TYPE));
            constructorCache.put(NBTEditor.getNBTTag(Short.class), NBTEditor.getNBTTag(Short.class).getDeclaredConstructor(Short.TYPE));
            constructorCache.put(NBTEditor.getNBTTag(Class.forName("[B")), NBTEditor.getNBTTag(Class.forName("[B")).getDeclaredConstructor(Class.forName("[B")));
            constructorCache.put(NBTEditor.getNBTTag(Class.forName("[I")), NBTEditor.getNBTTag(Class.forName("[I")).getDeclaredConstructor(Class.forName("[I")));
            for (Constructor<?> cons : constructorCache.values()) {
                cons.setAccessible(true);
            }
            constructorCache.put(NBTEditor.getNMSClass("BlockPosition"), NBTEditor.getNMSClass("BlockPosition").getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE));
            constructorCache.put(NBTEditor.getNMSClass("GameProfile"), NBTEditor.getNMSClass("GameProfile").getConstructor(UUID.class, String.class));
            constructorCache.put(NBTEditor.getNMSClass("Property"), NBTEditor.getNMSClass("Property").getConstructor(String.class, String.class));
            if (LOCAL_VERSION == MinecraftVersion.v1_11 || LOCAL_VERSION == MinecraftVersion.v1_12) {
                constructorCache.put(NBTEditor.getNMSClass("ItemStack"), NBTEditor.getNMSClass("ItemStack").getConstructor(NBTEditor.getNMSClass("NBTTagCompound")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        NBTTagFieldCache = new HashMap();
        try {
            for (Class<?> clazz : NBTClasses.values()) {
                Field data = clazz.getDeclaredField("data");
                data.setAccessible(true);
                NBTTagFieldCache.put(clazz, data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            NBTListData = NBTEditor.getNMSClass("NBTTagList").getDeclaredField("list");
            NBTListData.setAccessible(true);
            NBTCompoundMap = NBTEditor.getNMSClass("NBTTagCompound").getDeclaredField("map");
            NBTCompoundMap.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum MinecraftVersion {
        v1_8("1_8", 0),
        v1_9("1_9", 1),
        v1_10("1_10", 2),
        v1_11("1_11", 3),
        v1_12("1_12", 4),
        v1_13("1_13", 5),
        v1_14("1_14", 6),
        v1_15("1_15", 7),
        v1_16("1_16", 8),
        v1_17("1_17", 9),
        v1_18("1_18", 10),
        v1_19("1_19", 11);

        private int order;
        private String key;

        private MinecraftVersion(String key, int v) {
            this.key = key;
            this.order = v;
        }

        public boolean greaterThanOrEqualTo(MinecraftVersion other) {
            return this.order >= other.order;
        }

        public boolean lessThanOrEqualTo(MinecraftVersion other) {
            return this.order <= other.order;
        }

        public static MinecraftVersion get(String v) {
            for (MinecraftVersion k : MinecraftVersion.values()) {
                if (!v.contains(k.key)) continue;
                return k;
            }
            return null;
        }
    }

    public static final class NBTCompound {
        protected final Object tag;

        protected NBTCompound(@Nonnull Object tag) {
            this.tag = tag;
        }

        public void set(Object value, Object ... keys) {
            try {
                NBTEditor.setTag(this.tag, value, keys);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public String toJson() {
            return this.tag.toString();
        }

        public static NBTCompound fromJson(String json) {
            try {
                return new NBTCompound(NBTEditor.getMethod("loadNBTTagCompound").invoke(null, json));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return this.tag.toString();
        }

        public int hashCode() {
            return this.tag.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NBTCompound other = (NBTCompound)obj;
            return !(this.tag == null ? other.tag != null : !this.tag.equals(other.tag));
        }
    }
}

