/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries.unused;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;

public final class ZEnchantment {
    public static final ImmutableMap<String, Enchantment> ENCHANTMENTS;
    public static final ImmutableMap<String, Enchantment> ALIASENCHANTMENTS;
    private static final boolean ISFLAT;
    private static final Pattern SPACE;

    @Nonnull
    public static Optional<Enchantment> getByName(@Nonnull String enchant) {
        Validate.notEmpty((String)enchant, (String)"Enchantment name cannot be null or empty");
        Enchantment enchantment = null;
        enchant = StringUtils.deleteWhitespace((String)StringUtils.lowerCase((String)enchant, (Locale)Locale.ENGLISH));
        if (ISFLAT) {
            enchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)enchant));
        }
        if (enchantment == null) {
            enchantment = Enchantment.getByName((String)enchant);
        }
        if (enchantment == null) {
            enchantment = (Enchantment)ENCHANTMENTS.get((Object)enchant);
        }
        if (enchantment == null) {
            enchantment = (Enchantment)ALIASENCHANTMENTS.get((Object)enchant);
        }
        return Optional.ofNullable(enchantment);
    }

    @Nonnull
    public static ItemStack addEnchantFromString(@Nonnull ItemStack item, @Nonnull String enchantment) {
        Objects.requireNonNull(item, "Cannot add enchantment to null ItemStack");
        Validate.notEmpty((String)enchantment, (String)"Cannot add null or empty enchantment to item");
        String[] split = enchantment.contains(",") ? StringUtils.deleteWhitespace((String)enchantment).split(",") : SPACE.matcher(enchantment).replaceAll(" ").split(" ");
        Optional<Enchantment> enchant = ZEnchantment.getByName(split[0]);
        if (!enchant.isPresent()) {
            return item;
        }
        int lvl = 1;
        if (split.length > 1) {
            lvl = Integer.parseInt(split[1]);
        }
        item.addUnsafeEnchantment(enchant.get(), lvl);
        return item;
    }

    @Nonnull
    public static ImmutableList<String> getEnchantments() {
        return ENCHANTMENTS.keySet().asList();
    }

    @Nonnull
    public static ImmutableList<String> getEnchantmentAliases() {
        return ALIASENCHANTMENTS.keySet().asList();
    }

    @Nonnull
    public static List<String> getAllEnchantmentNames() {
        return Stream.concat(ALIASENCHANTMENTS.keySet().stream(), ENCHANTMENTS.keySet().stream()).collect(Collectors.toList());
    }

    static {
        boolean flat;
        SPACE = Pattern.compile("  +");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ImmutableMap.Builder aliasBuilder = ImmutableMap.builder();
        builder.put((Object)"alldamage", (Object)Enchantment.DAMAGE_ALL);
        builder.put((Object)"sharpness", (Object)Enchantment.DAMAGE_ALL);
        aliasBuilder.put((Object)"alldmg", (Object)Enchantment.DAMAGE_ALL);
        aliasBuilder.put((Object)"sharp", (Object)Enchantment.DAMAGE_ALL);
        aliasBuilder.put((Object)"dal", (Object)Enchantment.DAMAGE_ALL);
        builder.put((Object)"ardmg", (Object)Enchantment.DAMAGE_ARTHROPODS);
        builder.put((Object)"baneofarthropods", (Object)Enchantment.DAMAGE_ARTHROPODS);
        aliasBuilder.put((Object)"baneofarthropod", (Object)Enchantment.DAMAGE_ARTHROPODS);
        aliasBuilder.put((Object)"arthropod", (Object)Enchantment.DAMAGE_ARTHROPODS);
        aliasBuilder.put((Object)"dar", (Object)Enchantment.DAMAGE_ARTHROPODS);
        builder.put((Object)"undeaddamage", (Object)Enchantment.DAMAGE_UNDEAD);
        builder.put((Object)"smite", (Object)Enchantment.DAMAGE_UNDEAD);
        aliasBuilder.put((Object)"du", (Object)Enchantment.DAMAGE_UNDEAD);
        builder.put((Object)"digspeed", (Object)Enchantment.DIG_SPEED);
        builder.put((Object)"efficiency", (Object)Enchantment.DIG_SPEED);
        aliasBuilder.put((Object)"minespeed", (Object)Enchantment.DIG_SPEED);
        aliasBuilder.put((Object)"cutspeed", (Object)Enchantment.DIG_SPEED);
        aliasBuilder.put((Object)"ds", (Object)Enchantment.DIG_SPEED);
        aliasBuilder.put((Object)"eff", (Object)Enchantment.DIG_SPEED);
        builder.put((Object)"durability", (Object)Enchantment.DURABILITY);
        builder.put((Object)"unbreaking", (Object)Enchantment.DURABILITY);
        aliasBuilder.put((Object)"dura", (Object)Enchantment.DURABILITY);
        aliasBuilder.put((Object)"d", (Object)Enchantment.DURABILITY);
        builder.put((Object)"thorns", (Object)Enchantment.THORNS);
        builder.put((Object)"highcrit", (Object)Enchantment.THORNS);
        aliasBuilder.put((Object)"thorn", (Object)Enchantment.THORNS);
        aliasBuilder.put((Object)"highercrit", (Object)Enchantment.THORNS);
        aliasBuilder.put((Object)"t", (Object)Enchantment.THORNS);
        builder.put((Object)"fireaspect", (Object)Enchantment.FIRE_ASPECT);
        builder.put((Object)"fire", (Object)Enchantment.FIRE_ASPECT);
        aliasBuilder.put((Object)"meleefire", (Object)Enchantment.FIRE_ASPECT);
        aliasBuilder.put((Object)"meleeflame", (Object)Enchantment.FIRE_ASPECT);
        aliasBuilder.put((Object)"fa", (Object)Enchantment.FIRE_ASPECT);
        builder.put((Object)"knockback", (Object)Enchantment.KNOCKBACK);
        aliasBuilder.put((Object)"kback", (Object)Enchantment.KNOCKBACK);
        aliasBuilder.put((Object)"kb", (Object)Enchantment.KNOCKBACK);
        aliasBuilder.put((Object)"k", (Object)Enchantment.KNOCKBACK);
        builder.put((Object)"fortune", (Object)Enchantment.LOOT_BONUS_BLOCKS);
        aliasBuilder.put((Object)"blockslootbonus", (Object)Enchantment.LOOT_BONUS_BLOCKS);
        aliasBuilder.put((Object)"fort", (Object)Enchantment.LOOT_BONUS_BLOCKS);
        aliasBuilder.put((Object)"lbb", (Object)Enchantment.LOOT_BONUS_BLOCKS);
        builder.put((Object)"mobloot", (Object)Enchantment.LOOT_BONUS_MOBS);
        builder.put((Object)"looting", (Object)Enchantment.LOOT_BONUS_MOBS);
        aliasBuilder.put((Object)"mobslootbonus", (Object)Enchantment.LOOT_BONUS_MOBS);
        aliasBuilder.put((Object)"lbm", (Object)Enchantment.LOOT_BONUS_MOBS);
        builder.put((Object)"breath", (Object)Enchantment.OXYGEN);
        builder.put((Object)"respiration", (Object)Enchantment.OXYGEN);
        aliasBuilder.put((Object)"breathing", (Object)Enchantment.OXYGEN);
        aliasBuilder.put((Object)"oxygen", (Object)Enchantment.OXYGEN);
        aliasBuilder.put((Object)"o", (Object)Enchantment.OXYGEN);
        builder.put((Object)"protection", (Object)Enchantment.PROTECTION_ENVIRONMENTAL);
        builder.put((Object)"protect", (Object)Enchantment.PROTECTION_ENVIRONMENTAL);
        aliasBuilder.put((Object)"prot", (Object)Enchantment.PROTECTION_ENVIRONMENTAL);
        aliasBuilder.put((Object)"p", (Object)Enchantment.PROTECTION_ENVIRONMENTAL);
        builder.put((Object)"blastprotect", (Object)Enchantment.PROTECTION_EXPLOSIONS);
        aliasBuilder.put((Object)"explosionsprotection", (Object)Enchantment.PROTECTION_EXPLOSIONS);
        aliasBuilder.put((Object)"explosionprotection", (Object)Enchantment.PROTECTION_EXPLOSIONS);
        aliasBuilder.put((Object)"expprot", (Object)Enchantment.PROTECTION_EXPLOSIONS);
        aliasBuilder.put((Object)"blastprotection", (Object)Enchantment.PROTECTION_EXPLOSIONS);
        aliasBuilder.put((Object)"bprotection", (Object)Enchantment.PROTECTION_EXPLOSIONS);
        aliasBuilder.put((Object)"bprotect", (Object)Enchantment.PROTECTION_EXPLOSIONS);
        aliasBuilder.put((Object)"pe", (Object)Enchantment.PROTECTION_EXPLOSIONS);
        builder.put((Object)"fallprot", (Object)Enchantment.PROTECTION_FALL);
        builder.put((Object)"featherfall", (Object)Enchantment.PROTECTION_FALL);
        aliasBuilder.put((Object)"fallprotection", (Object)Enchantment.PROTECTION_FALL);
        aliasBuilder.put((Object)"featherfalling", (Object)Enchantment.PROTECTION_FALL);
        aliasBuilder.put((Object)"pfa", (Object)Enchantment.PROTECTION_FALL);
        builder.put((Object)"fireprot", (Object)Enchantment.PROTECTION_FIRE);
        builder.put((Object)"fireprotect", (Object)Enchantment.PROTECTION_FIRE);
        aliasBuilder.put((Object)"fireprotection", (Object)Enchantment.PROTECTION_FIRE);
        aliasBuilder.put((Object)"flameprotection", (Object)Enchantment.PROTECTION_FIRE);
        aliasBuilder.put((Object)"flameprotect", (Object)Enchantment.PROTECTION_FIRE);
        aliasBuilder.put((Object)"flameprot", (Object)Enchantment.PROTECTION_FIRE);
        aliasBuilder.put((Object)"pf", (Object)Enchantment.PROTECTION_FIRE);
        builder.put((Object)"projectileprotection", (Object)Enchantment.PROTECTION_PROJECTILE);
        builder.put((Object)"projprot", (Object)Enchantment.PROTECTION_PROJECTILE);
        aliasBuilder.put((Object)"pp", (Object)Enchantment.PROTECTION_PROJECTILE);
        builder.put((Object)"silktouch", (Object)Enchantment.SILK_TOUCH);
        aliasBuilder.put((Object)"softtouch", (Object)Enchantment.SILK_TOUCH);
        aliasBuilder.put((Object)"st", (Object)Enchantment.SILK_TOUCH);
        builder.put((Object)"waterworker", (Object)Enchantment.WATER_WORKER);
        builder.put((Object)"aquaaffinity", (Object)Enchantment.WATER_WORKER);
        aliasBuilder.put((Object)"watermine", (Object)Enchantment.WATER_WORKER);
        aliasBuilder.put((Object)"ww", (Object)Enchantment.WATER_WORKER);
        aliasBuilder.put((Object)"firearrow", (Object)Enchantment.ARROW_FIRE);
        builder.put((Object)"flame", (Object)Enchantment.ARROW_FIRE);
        builder.put((Object)"flamearrow", (Object)Enchantment.ARROW_FIRE);
        aliasBuilder.put((Object)"af", (Object)Enchantment.ARROW_FIRE);
        builder.put((Object)"arrowdamage", (Object)Enchantment.ARROW_DAMAGE);
        builder.put((Object)"power", (Object)Enchantment.ARROW_DAMAGE);
        aliasBuilder.put((Object)"arrowpower", (Object)Enchantment.ARROW_DAMAGE);
        aliasBuilder.put((Object)"ad", (Object)Enchantment.ARROW_DAMAGE);
        builder.put((Object)"arrowknockback", (Object)Enchantment.ARROW_KNOCKBACK);
        aliasBuilder.put((Object)"arrowkb", (Object)Enchantment.ARROW_KNOCKBACK);
        builder.put((Object)"punch", (Object)Enchantment.ARROW_KNOCKBACK);
        aliasBuilder.put((Object)"arrowpunch", (Object)Enchantment.ARROW_KNOCKBACK);
        aliasBuilder.put((Object)"ak", (Object)Enchantment.ARROW_KNOCKBACK);
        aliasBuilder.put((Object)"infinitearrows", (Object)Enchantment.ARROW_INFINITE);
        builder.put((Object)"infarrows", (Object)Enchantment.ARROW_INFINITE);
        builder.put((Object)"infinity", (Object)Enchantment.ARROW_INFINITE);
        aliasBuilder.put((Object)"infinite", (Object)Enchantment.ARROW_INFINITE);
        aliasBuilder.put((Object)"unlimited", (Object)Enchantment.ARROW_INFINITE);
        aliasBuilder.put((Object)"unlimitedarrows", (Object)Enchantment.ARROW_INFINITE);
        aliasBuilder.put((Object)"ai", (Object)Enchantment.ARROW_INFINITE);
        builder.put((Object)"luck", (Object)Enchantment.LUCK);
        aliasBuilder.put((Object)"luckofsea", (Object)Enchantment.LUCK);
        aliasBuilder.put((Object)"luckofseas", (Object)Enchantment.LUCK);
        aliasBuilder.put((Object)"rodluck", (Object)Enchantment.LUCK);
        builder.put((Object)"lure", (Object)Enchantment.LURE);
        aliasBuilder.put((Object)"rodlure", (Object)Enchantment.LURE);
        try {
            Enchantment depthStrider = Enchantment.getByName((String)"DEPTH_STRIDER");
            if (depthStrider != null) {
                builder.put((Object)"depthstrider", (Object)depthStrider);
                aliasBuilder.put((Object)"depth", (Object)depthStrider);
                aliasBuilder.put((Object)"strider", (Object)depthStrider);
            }
        }
        catch (IllegalArgumentException depthStrider) {
            // empty catch block
        }
        try {
            Enchantment mending;
            Enchantment frostWalker = Enchantment.getByName((String)"FROST_WALKER");
            if (frostWalker != null) {
                builder.put((Object)"frostwalker", (Object)frostWalker);
                aliasBuilder.put((Object)"frost", (Object)frostWalker);
                aliasBuilder.put((Object)"walker", (Object)frostWalker);
            }
            if ((mending = Enchantment.getByName((String)"MENDING")) != null) {
                builder.put((Object)"mending", (Object)mending);
            }
        }
        catch (IllegalArgumentException frostWalker) {
            // empty catch block
        }
        try {
            Enchantment sweeping;
            Enchantment vanishingCurse;
            Enchantment bindingCurse = Enchantment.getByName((String)"BINDING_CURSE");
            if (bindingCurse != null) {
                builder.put((Object)"bindingcurse", (Object)bindingCurse);
                aliasBuilder.put((Object)"bindcurse", (Object)bindingCurse);
                aliasBuilder.put((Object)"binding", (Object)bindingCurse);
                aliasBuilder.put((Object)"bind", (Object)bindingCurse);
            }
            if ((vanishingCurse = Enchantment.getByName((String)"VANISHING_CURSE")) != null) {
                builder.put((Object)"vanishingcurse", (Object)vanishingCurse);
                aliasBuilder.put((Object)"vanishcurse", (Object)vanishingCurse);
                aliasBuilder.put((Object)"vanishing", (Object)vanishingCurse);
                aliasBuilder.put((Object)"vanish", (Object)vanishingCurse);
            }
            if ((sweeping = Enchantment.getByName((String)"SWEEPING_EDGE")) != null) {
                builder.put((Object)"sweepingedge", (Object)sweeping);
                aliasBuilder.put((Object)"sweepedge", (Object)sweeping);
                aliasBuilder.put((Object)"sweeping", (Object)sweeping);
            }
        }
        catch (IllegalArgumentException bindingCurse) {
            // empty catch block
        }
        try {
            Class<?> namespacedKeyClass = Class.forName("org.bukkit.NamespacedKey");
            Class<?> enchantmentClass = Class.forName("org.bukkit.enchantments.Enchantment");
            enchantmentClass.getDeclaredMethod("getByKey", namespacedKeyClass);
            flat = true;
        }
        catch (ClassNotFoundException | NoSuchMethodException ex) {
            flat = false;
        }
        ISFLAT = flat;
        if (ISFLAT) {
            Enchantment channelling;
            Enchantment riptide;
            Enchantment impaling;
            Enchantment loyalty = Enchantment.getByName((String)"LOYALTY");
            if (loyalty != null) {
                builder.put((Object)"loyalty", (Object)loyalty);
                aliasBuilder.put((Object)"loyal", (Object)loyalty).put((Object)"return", (Object)loyalty);
            }
            if ((impaling = Enchantment.getByName((String)"IMPALING")) != null) {
                builder.put((Object)"impaling", (Object)impaling);
                aliasBuilder.put((Object)"impale", (Object)impaling).put((Object)"oceandamage", (Object)impaling).put((Object)"oceandmg", (Object)impaling);
            }
            if ((riptide = Enchantment.getByName((String)"RIPTIDE")) != null) {
                builder.put((Object)"riptide", (Object)riptide);
                aliasBuilder.put((Object)"rip", (Object)riptide);
                aliasBuilder.put((Object)"tide", (Object)riptide);
                aliasBuilder.put((Object)"launch", (Object)riptide);
            }
            if ((channelling = Enchantment.getByName((String)"CHANNELING")) != null) {
                builder.put((Object)"channelling", (Object)channelling);
                aliasBuilder.put((Object)"chanelling", (Object)channelling);
                aliasBuilder.put((Object)"channeling", (Object)channelling);
                aliasBuilder.put((Object)"chaneling", (Object)channelling);
                aliasBuilder.put((Object)"channel", (Object)channelling);
            }
            try {
                Enchantment piercing;
                Enchantment quickCharge;
                Enchantment multishot = Enchantment.getByName((String)"MULTISHOT");
                if (multishot != null) {
                    builder.put((Object)"multishot", (Object)multishot);
                    aliasBuilder.put((Object)"tripleshot", (Object)multishot);
                }
                if ((quickCharge = Enchantment.getByName((String)"QUICK_CHARGE")) != null) {
                    builder.put((Object)"quickcharge", (Object)quickCharge);
                    aliasBuilder.put((Object)"quickdraw", (Object)quickCharge);
                    aliasBuilder.put((Object)"fastcharge", (Object)quickCharge);
                    aliasBuilder.put((Object)"fastdraw", (Object)quickCharge);
                }
                if ((piercing = Enchantment.getByName((String)"PIERCING")) != null) {
                    builder.put((Object)"piercing", (Object)piercing);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        ENCHANTMENTS = builder.build();
        ALIASENCHANTMENTS = aliasBuilder.build();
    }
}

