/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries.unused;

import com.cryptomorin.xseries.ReflectionUtils;
import com.google.common.base.Enums;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class BossBar
implements Cloneable {
    public static final int MAX_BOSSBARS = 4;
    private static final MethodHandle PACKET;
    private static final MethodHandle SERIALIZER;
    private static final Object[] COLORS;
    private static final Object[] STYLES;
    private static final Object[] ACTIONS;
    private static final MethodHandle ID;
    private static final MethodHandle ACTION;
    private static final MethodHandle MESSAGE;
    private static final MethodHandle PROGRESS;
    private static final MethodHandle COLOR;
    private static final MethodHandle STYLE;
    private static final MethodHandle DARKEN_SKY;
    private static final MethodHandle PLAY_MUSIC;
    private static final MethodHandle CREATE_FOG;
    private final UUID id;
    private final Set<Property> properties = EnumSet.noneOf(Property.class);
    private final Object packet;
    private List<UUID> receivers = new ArrayList<UUID>();
    private float progress;
    private String title;
    private Color color;
    private Style style;
    private boolean visible;

    public BossBar(String title, Color color, Style style, float progress, Property ... properties) {
        this.id = UUID.randomUUID();
        this.color = color != null ? color : Color.PURPLE;
        this.style = style != null ? style : Style.PROGRESS;
        this.title = title;
        this.progress = progress;
        this.properties.addAll(Arrays.asList(properties));
        Object packet = null;
        try {
            packet = PACKET.invoke();
            ID.invoke(packet, this.id);
            MESSAGE.invoke(packet, SERIALIZER.invoke(this.title));
            PROGRESS.invoke(packet, this.progress);
            COLOR.invoke(packet, COLORS[this.color.ordinal()]);
            STYLE.invoke(packet, STYLES[this.style.ordinal()]);
            DARKEN_SKY.invoke(packet, this.hasProperty(Property.DARKEN_SKY));
            PLAY_MUSIC.invoke(packet, this.hasProperty(Property.PLAY_MUSIC));
            CREATE_FOG.invoke(packet, this.hasProperty(Property.CREATE_FOG));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.packet = packet;
    }

    public static BossBar fromConfig(ConfigurationSection section) {
        return new BossBar(ChatColor.translateAlternateColorCodes((char)'&', (String)section.getString("message")), (Color)((Object)Enums.getIfPresent(Color.class, (String)section.getString("color")).or((Object)Color.PURPLE)), (Style)((Object)Enums.getIfPresent(Style.class, (String)section.getString("style")).or((Object)Style.PROGRESS)), (float)section.getDouble("progress"), new Property[0]);
    }

    public static void removeBossBar(List<Player> players) {
        BossBar bossBar = new BossBar(null, null, null, 0.0f, new Property[0]);
        bossBar.setPlayers(players);
        bossBar.update(Action.REMOVE);
    }

    public boolean hasProperty(Property property) {
        return this.properties.contains((Object)property);
    }

    public BossBar setStyle(Style style) {
        Objects.requireNonNull(this.color, "BossBar style cannot be null");
        if (style != this.style) {
            this.style = style;
            try {
                STYLE.invoke(this.packet, STYLES[this.style.ordinal()]);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            this.update(Action.UPDATE_STYLE);
        }
        return this;
    }

    public void setPropertySilent(Property property, boolean flag) {
        Objects.requireNonNull(this.color, "Cannot set null property of BossBar");
        boolean hasProp = this.hasProperty(property);
        if (hasProp == flag) {
            return;
        }
        if (hasProp) {
            this.properties.remove((Object)property);
        } else {
            this.properties.add(property);
        }
        switch (property) {
            case DARKEN_SKY: {
                try {
                    DARKEN_SKY.invoke(this.packet, flag);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                break;
            }
            case PLAY_MUSIC: {
                try {
                    PLAY_MUSIC.invoke(this.packet, flag);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                break;
            }
            case CREATE_FOG: {
                try {
                    CREATE_FOG.invoke(this.packet, flag);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                break;
            }
        }
        this.update(Action.UPDATE_PROPERTIES);
    }

    public void setProperty(Property property, boolean flag) {
        this.setPropertySilent(property, flag);
        this.update(Action.UPDATE_PROPERTIES);
    }

    public void update(Action action) {
        try {
            ACTION.invoke(this.packet, ACTIONS[action.ordinal()]);
            for (UUID receiver : this.receivers) {
                Player player = Bukkit.getPlayer((UUID)receiver);
                if (player == null) continue;
                ReflectionUtils.sendPacket(player, this.packet);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void send() {
        this.update(Action.ADD);
    }

    public BossBar setPlayers(List<Player> players) {
        ArrayList<UUID> receivers = new ArrayList<UUID>();
        for (Player player : players) {
            receivers.add(player.getUniqueId());
        }
        this.receivers = receivers;
        return this;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public BossBar setVisible(boolean flag) {
        if (flag != this.visible) {
            this.visible = flag;
            this.update(flag ? Action.ADD : Action.REMOVE);
        }
        return this;
    }

    public Color getColor() {
        return this.color;
    }

    public BossBar setColor(Color color) {
        Objects.requireNonNull(color, "BossBar color cannot be null");
        if (color != this.color) {
            this.color = color;
            try {
                COLOR.invoke(this.packet, COLORS[this.color.ordinal()]);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            this.update(Action.UPDATE_STYLE);
        }
        return this;
    }

    public float getProgress() {
        return this.progress;
    }

    public BossBar setProgress(float progress) {
        if (progress != this.progress) {
            if (progress > 1.0f) {
                progress /= 100.0f;
            }
            this.progress = progress;
            try {
                PROGRESS.invoke(this.packet, this.progress);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            this.update(Action.UPDATE_PCT);
        }
        return this;
    }

    public List<UUID> getReceivers() {
        return this.receivers;
    }

    public BossBar setReceivers(List<UUID> receivers) {
        this.receivers = receivers;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public BossBar setTitle(String title) {
        Objects.requireNonNull(title, "Cannot set null as the BossBar message");
        if (!title.startsWith("{") || !title.endsWith("}")) {
            return this.setMessage((BaseComponent)new TextComponent(title));
        }
        if (!title.equals(this.title)) {
            this.title = title;
            try {
                MESSAGE.invoke(this.packet, SERIALIZER.invoke(this.title));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            this.update(Action.UPDATE_NAME);
        }
        return this;
    }

    public BossBar setMessage(BaseComponent component) {
        Objects.requireNonNull(component, "Cannot translate null BaseComponent for BossBar message");
        this.title = ComponentSerializer.toString((BaseComponent)component);
        try {
            MESSAGE.invoke(this.packet, SERIALIZER.invoke(this.title));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.update(Action.UPDATE_NAME);
        return this;
    }

    public Set<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(Property ... properties) {
        List<Property> prop = Arrays.asList(properties);
        for (Property property : Property.values()) {
            this.setPropertySilent(property, prop.contains((Object)property));
        }
        this.update(Action.UPDATE_PROPERTIES);
    }

    public UUID getId() {
        return this.id;
    }

    public BossBar clone() {
        return new BossBar(this.title, this.color, this.style, this.progress, this.properties.toArray(new Property[0]));
    }

    static {
        COLORS = ReflectionUtils.getNMSClass("BossBattle$BarColor").getEnumConstants();
        STYLES = ReflectionUtils.getNMSClass("BossBattle$BarStyle").getEnumConstants();
        ACTIONS = ReflectionUtils.getNMSClass("PacketPlayOutBoss$Action").getEnumConstants();
        Class<?> packetClass = ReflectionUtils.getNMSClass("PacketPlayOutBoss");
        Class<?> baseComponent = ReflectionUtils.getNMSClass("IChatBaseComponent");
        Class<?> chatSerializer = ReflectionUtils.getNMSClass("IChatBaseComponent$ChatSerializer");
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandle packet = null;
        MethodHandle serializer = null;
        MethodHandle id = null;
        MethodHandle action = null;
        MethodHandle message = null;
        MethodHandle progress = null;
        MethodHandle color = null;
        MethodHandle style = null;
        MethodHandle darkenSky = null;
        MethodHandle playMusic = null;
        MethodHandle createFog = null;
        try {
            packet = lookup.findConstructor(packetClass, MethodType.methodType(Void.TYPE));
            serializer = lookup.findStatic(chatSerializer, "a", MethodType.methodType(baseComponent, String.class));
            Field field = packetClass.getDeclaredField("a");
            field.setAccessible(true);
            id = lookup.unreflectSetter(field);
            field = packetClass.getDeclaredField("b");
            field.setAccessible(true);
            action = lookup.unreflectSetter(field);
            field = packetClass.getDeclaredField("c");
            field.setAccessible(true);
            message = lookup.unreflectSetter(field);
            field = packetClass.getDeclaredField("d");
            field.setAccessible(true);
            progress = lookup.unreflectSetter(field);
            field = packetClass.getDeclaredField("e");
            field.setAccessible(true);
            color = lookup.unreflectSetter(field);
            field = packetClass.getDeclaredField("f");
            field.setAccessible(true);
            style = lookup.unreflectSetter(field);
            field = packetClass.getDeclaredField("g");
            field.setAccessible(true);
            darkenSky = lookup.unreflectSetter(field);
            field = packetClass.getDeclaredField("h");
            field.setAccessible(true);
            playMusic = lookup.unreflectSetter(field);
            field = packetClass.getDeclaredField("i");
            field.setAccessible(true);
            createFog = lookup.unreflectSetter(field);
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
            e.printStackTrace();
        }
        PACKET = packet;
        SERIALIZER = serializer;
        ID = id;
        ACTION = action;
        MESSAGE = message;
        PROGRESS = progress;
        COLOR = color;
        STYLE = style;
        DARKEN_SKY = darkenSky;
        PLAY_MUSIC = playMusic;
        CREATE_FOG = createFog;
    }

    public static enum Property {
        DARKEN_SKY,
        PLAY_MUSIC,
        CREATE_FOG;

    }

    public static enum Color {
        PINK,
        BLUE,
        RED,
        GREEN,
        YELLOW,
        PURPLE,
        WHITE;

    }

    public static enum Style {
        PROGRESS,
        NOTCHED_6,
        NOTCHED_10,
        NOTCHED_12,
        NOTCHED_20;

    }

    private static enum Action {
        ADD,
        REMOVE,
        UPDATE_PCT,
        UPDATE_NAME,
        UPDATE_STYLE,
        UPDATE_PROPERTIES;

    }
}

