/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries.particles;

import com.cryptomorin.xseries.particles.ParticleDisplay;
import com.google.common.base.Enums;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import javax.imageio.ImageIO;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;

public final class XParticle {
    public static final double PII = Math.PI * 2;

    public static Particle getParticle(String particle) {
        return (Particle)Enums.getIfPresent(Particle.class, (String)particle).orNull();
    }

    public static Particle randomParticle(String ... particles) {
        int rand = XParticle.randInt(0, particles.length - 1);
        return XParticle.getParticle(particles[rand]);
    }

    public static double random(double min, double max) {
        return ThreadLocalRandom.current().nextDouble(min, max);
    }

    public static int randInt(int min, int max) {
        return ThreadLocalRandom.current().nextInt(min, max + 1);
    }

    public static org.bukkit.Color randomColor() {
        ThreadLocalRandom gen = ThreadLocalRandom.current();
        int randR = gen.nextInt(0, 256);
        int randG = gen.nextInt(0, 256);
        int randB = gen.nextInt(0, 256);
        return org.bukkit.Color.fromRGB((int)randR, (int)randG, (int)randB);
    }

    public static Particle.DustOptions randomDust() {
        float size = (float)XParticle.randInt(5, 10) / 10.0f;
        return new Particle.DustOptions(XParticle.randomColor(), size);
    }

    public static void blackSun(double radius, double radiusRate, double rate, double rateChange, ParticleDisplay display) {
        double j = 0.0;
        for (double i = 10.0; i > 0.0; i -= radiusRate) {
            XParticle.circle(radius + i, rate - (j += rateChange), display);
        }
    }

    public static void circle(double radius, double rate, ParticleDisplay display) {
        XParticle.circle(radius, rate, 1.0, rate, 0.0, display);
    }

    public static void circle(double radius, double radius2, double extension, double rate, double limit, ParticleDisplay display) {
        double rateDiv = Math.PI / rate;
        if (limit == 0.0) {
            limit = Math.PI * 2;
        } else if (limit == -1.0) {
            limit = Math.PI * 2 / Math.abs(extension);
        }
        for (double theta = 0.0; theta <= limit; theta += rateDiv) {
            double x = radius * Math.cos(extension * theta);
            double z = radius2 * Math.sin(extension * theta);
            if (display.isDirectional()) {
                double phi = Math.atan2(z, x);
                double directionX = Math.cos(extension * phi);
                double directionZ = Math.sin(extension * phi);
                display.offset(directionX, display.offsety, directionZ);
            }
            display.spawn(x, 0.0, z);
        }
    }

    public static void diamond(double radiusRate, double rate, double height, ParticleDisplay display) {
        double count = 0.0;
        for (double y = 0.0; y < height * 2.0; y += rate) {
            count = y < height ? (count += radiusRate) : (count -= radiusRate);
            for (double x = -count; x < count; x += rate) {
                display.spawn(x, y, 0.0);
            }
        }
    }

    public static BukkitTask circularBeam(JavaPlugin plugin, final double maxRadius, final double rate, final double radiusRate, final double extend, final ParticleDisplay display) {
        return new BukkitRunnable(){
            final double rateDiv;
            final double radiusDiv;
            final Vector dir;
            double dynamicRadius;
            {
                this.rateDiv = Math.PI / rate;
                this.radiusDiv = Math.PI / radiusRate;
                this.dir = display.location.getDirection().normalize().multiply(extend);
                this.dynamicRadius = 0.0;
            }

            public void run() {
                double radius = maxRadius * Math.sin(this.dynamicRadius);
                for (double theta = 0.0; theta < Math.PI * 2; theta += this.rateDiv) {
                    double x = radius * Math.sin(theta);
                    double z = radius * Math.cos(theta);
                    display.spawn(x, 0.0, z);
                }
                this.dynamicRadius += this.radiusDiv;
                if (this.dynamicRadius > Math.PI) {
                    this.dynamicRadius = 0.0;
                }
                display.location.add(this.dir);
            }
        }.runTaskTimerAsynchronously((Plugin)plugin, 0L, 1L);
    }

    public static void flower(int count, double radius, ParticleDisplay display, Runnable runnable) {
        for (double theta = 0.0; theta < Math.PI * 2; theta += Math.PI * 2 / (double)count) {
            double x = radius * Math.cos(theta);
            double z = radius * Math.sin(theta);
            display.location.add(x, 0.0, z);
            runnable.run();
            display.location.subtract(x, 0.0, z);
        }
    }

    public static void filledCircle(double radius, double rate, double radiusRate, ParticleDisplay display) {
        double dynamicRate = 0.0;
        for (double i = 0.1; i < radius; i += radiusRate) {
            if (i > radius) {
                i = radius;
            }
            XParticle.circle(i, dynamicRate += rate / (radius / radiusRate), display);
        }
    }

    public static BukkitTask chaoticDoublePendulum(JavaPlugin plugin, final double radius, final double gravity, final double length, final double length2, final double mass1, final double mass2, final boolean dimension3, final int speed, final ParticleDisplay display) {
        return new BukkitRunnable(){
            final Vector rotation = new Vector(0.09519977738150888, 0.07139983303613166, 0.057119866428905326);
            double theta = 1.5707963267948966;
            double theta2 = 1.5707963267948966;
            double thetaPrime = 0.0;
            double thetaPrime2 = 0.0;

            public void run() {
                int repeat = speed;
                while (repeat-- != 0) {
                    if (dimension3) {
                        display.rotate(this.rotation);
                    }
                    double totalMass = mass1 + mass2;
                    double totalMassDouble = 2.0 * totalMass;
                    double deltaTheta = this.theta - this.theta2;
                    double lenLunar = totalMassDouble - mass2 * Math.cos(2.0 * this.theta - 2.0 * this.theta2);
                    double deltaCosTheta = Math.cos(deltaTheta);
                    double deltaSinTheta = Math.sin(deltaTheta);
                    double phi = this.thetaPrime * this.thetaPrime * length;
                    double phi2 = this.thetaPrime2 * this.thetaPrime2 * length2;
                    double num1 = -gravity * totalMassDouble * Math.sin(this.theta);
                    double num2 = -mass2 * gravity * Math.sin(this.theta - 2.0 * this.theta2);
                    double num3 = -2.0 * deltaSinTheta * mass2;
                    double num4 = phi2 + phi * deltaCosTheta;
                    double len = length * lenLunar;
                    double thetaDoublePrime = (num1 + num2 + num3 * num4) / len;
                    num1 = 2.0 * deltaSinTheta;
                    num2 = phi * totalMass;
                    num3 = gravity * totalMass * Math.cos(this.theta);
                    num4 = phi2 * mass2 * deltaCosTheta;
                    len = length2 * lenLunar;
                    double thetaDoublePrime2 = num1 * (num2 + num3 + num4) / len;
                    this.thetaPrime += thetaDoublePrime;
                    this.thetaPrime2 += thetaDoublePrime2;
                    this.theta += this.thetaPrime;
                    this.theta2 += this.thetaPrime2;
                    double x = radius * Math.sin(this.theta);
                    double y = radius * Math.cos(this.theta);
                    double x2 = x + radius * Math.sin(this.theta2);
                    double y2 = y + radius * Math.cos(this.theta2);
                    display.spawn(x2, y2, 0.0);
                }
            }
        }.runTaskTimerAsynchronously((Plugin)plugin, 0L, 1L);
    }

    public static BukkitTask magicCircles(JavaPlugin plugin, final double radius, final double rate, final double radiusRate, final double distance, final ParticleDisplay display) {
        return new BukkitRunnable(){
            final double radiusDiv;
            final Vector dir;
            double dynamicRadius;
            {
                this.radiusDiv = Math.PI / radiusRate;
                this.dir = display.location.getDirection().normalize().multiply(distance);
                this.dynamicRadius = radius;
            }

            public void run() {
                double rateDiv = Math.PI / (rate * this.dynamicRadius);
                for (double theta = 0.0; theta < Math.PI * 2; theta += rateDiv) {
                    double x = this.dynamicRadius * Math.sin(theta);
                    double z = this.dynamicRadius * Math.cos(theta);
                    display.spawn(x, 0.0, z);
                }
                this.dynamicRadius += this.radiusDiv;
                display.location.add(this.dir);
            }
        }.runTaskTimerAsynchronously((Plugin)plugin, 0L, 1L);
    }

    public static void infinity(double radius, double rate, ParticleDisplay display) {
        double rateDiv = Math.PI / rate;
        for (double i = 0.0; i < Math.PI * 2; i += rateDiv) {
            double x = Math.sin(i);
            double smooth = Math.pow(x, 2.0) + 1.0;
            double curve = radius * Math.cos(i);
            double z = curve / smooth;
            double y = curve * x / smooth;
            XParticle.circle(1.0, rate, display.cloneWithLocation(x, y, z));
        }
    }

    public static void cone(double height, double radius, double rate, double circleRate, ParticleDisplay display) {
        double radiusDiv = radius / (height / rate);
        for (double i = 0.0; i < height; i += rate) {
            if ((radius -= radiusDiv) < 0.0) {
                radius = 0.0;
            }
            XParticle.circle(radius, circleRate - i, display.cloneWithLocation(0.0, i, 0.0));
        }
    }

    public static void ellipse(double radius, double otherRadius, double rate, ParticleDisplay display) {
        double rateDiv = Math.PI / rate;
        for (double theta = 0.0; theta <= Math.PI * 2; theta += rateDiv) {
            double x = radius * Math.cos(theta);
            double y = otherRadius * Math.sin(theta);
            display.spawn(x, y, 0.0);
        }
    }

    public static BukkitTask blackhole(JavaPlugin plugin, final int points, final double radius, final double rate, final int mode, final int time, final ParticleDisplay display) {
        display.directional();
        display.extra = 0.1;
        return new BukkitRunnable(){
            final double rateDiv;
            int timer;
            double theta;
            {
                this.rateDiv = Math.PI / rate;
                this.timer = time;
                this.theta = 0.0;
            }

            public void run() {
                for (int i = 0; i < points; ++i) {
                    double angle = Math.PI * 2 * ((double)i / (double)points);
                    double x = radius * Math.cos(this.theta + angle);
                    double z = radius * Math.sin(this.theta + angle);
                    double phi = Math.atan2(z, x);
                    double xDirection = -Math.cos(phi);
                    double zDirection = -Math.sin(phi);
                    display.offset(xDirection, 0.0, zDirection);
                    display.spawn(x, 0.0, z);
                    if (mode <= 1) continue;
                    x = radius * Math.cos(-this.theta + angle);
                    z = radius * Math.sin(-this.theta + angle);
                    if (mode == 2) {
                        phi = Math.atan2(z, x);
                    } else if (mode == 3) {
                        phi = Math.atan2(x, z);
                    } else if (mode == 4) {
                        Math.atan2(Math.log(x), Math.log(z));
                    }
                    xDirection = -Math.cos(phi);
                    zDirection = -Math.sin(phi);
                    display.offset(xDirection, 0.0, zDirection);
                    display.spawn(x, 0.0, z);
                }
                this.theta += this.rateDiv;
                if (--this.timer <= 0) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)plugin, 0L, 1L);
    }

    public static void rainbow(double radius, double rate, double curve, double layers, double compact, ParticleDisplay display) {
        int[][] rainbow = new int[][]{{128, 0, 128}, {75, 0, 130}, {0, 0, 255}, {0, 255, 0}, {255, 255, 0}, {255, 140, 0}, {255, 0, 0}};
        double secondRadius = radius * curve;
        for (int i = 0; i < 7; ++i) {
            int[] rgb = rainbow[i];
            display = ParticleDisplay.colored(display.location, rgb[0], rgb[1], rgb[2], 1.0f);
            int layer = 0;
            while ((double)layer < layers) {
                double rateDiv = Math.PI / (rate * (double)(i + 2));
                for (double theta = 0.0; theta <= Math.PI; theta += rateDiv) {
                    double x = radius * Math.cos(theta);
                    double y = secondRadius * Math.sin(theta);
                    display.spawn(x, y, 0.0);
                }
                radius += compact;
                ++layer;
            }
        }
    }

    public static void crescent(double radius, double rate, ParticleDisplay display) {
        double rateDiv = Math.PI / rate;
        for (double theta = Math.toRadians(45.0); theta <= Math.toRadians(325.0); theta += rateDiv) {
            double x = Math.cos(theta);
            double z = Math.sin(theta);
            display.spawn(radius * x, 0.0, radius * z);
            double smallerRadius = radius / 1.3;
            display.spawn(smallerRadius * x + 0.8, 0.0, smallerRadius * z);
        }
    }

    public static void waveFunction(double extend, double heightRange, double size, double rate, ParticleDisplay display) {
        double height = heightRange / 2.0;
        boolean increase = true;
        double increaseRandomizer = XParticle.random(heightRange / 2.0, heightRange);
        double rateDiv = Math.PI / rate;
        size *= Math.PI * 2;
        for (double x = 0.0; x <= size; x += rateDiv) {
            double xx = extend * x;
            double y1 = Math.sin(x);
            if (y1 == 1.0) {
                increase = !increase;
                increaseRandomizer = increase ? XParticle.random(heightRange / 2.0, heightRange) : XParticle.random(-heightRange, -heightRange / 2.0);
            }
            height += increaseRandomizer;
            for (double z = 0.0; z <= size; z += rateDiv) {
                double y2 = Math.cos(z);
                double yy = height * y1 * y2;
                double zz = extend * z;
                display.spawn(xx, yy, zz);
            }
        }
    }

    public static BukkitTask vortex(JavaPlugin plugin, final int points, double rate, final ParticleDisplay display) {
        final double rateDiv = Math.PI / rate;
        display.directional();
        return new BukkitRunnable(){
            double theta = 0.0;

            public void run() {
                this.theta += rateDiv;
                for (int i = 0; i < points; ++i) {
                    double multiplier = Math.PI * 2 * ((double)i / (double)points);
                    double x = Math.cos(this.theta + multiplier);
                    double z = Math.sin(this.theta + multiplier);
                    double angle = Math.atan2(z, x);
                    double xDirection = Math.cos(angle);
                    double zDirection = Math.sin(angle);
                    display.offset(xDirection, 0.0, zDirection);
                    display.spawn(x, 0.0, z);
                }
            }
        }.runTaskTimerAsynchronously((Plugin)plugin, 0L, 1L);
    }

    public static void cylinder(double height, double radius, double rate, ParticleDisplay display) {
        XParticle.filledCircle(radius, rate, 3.0, display);
        XParticle.filledCircle(radius, rate, 3.0, display.cloneWithLocation(0.0, height, 0.0));
        for (double y = 0.0; y < height; y += 0.1) {
            XParticle.circle(radius, rate, display.cloneWithLocation(0.0, y, 0.0));
        }
    }

    public static BukkitTask moveRotatingAround(JavaPlugin plugin, long update, final double rate, final double offsetx, final double offsety, final double offsetz, final Runnable runnable, final ParticleDisplay ... displays) {
        return new BukkitRunnable(){
            double rotation = 180.0;

            public void run() {
                this.rotation += rate;
                double x = Math.toRadians(90.0 + this.rotation);
                double y = Math.toRadians(60.0 + this.rotation);
                double z = Math.toRadians(30.0 + this.rotation);
                Vector vector = new Vector(offsetx * Math.PI, offsety * Math.PI, offsetz * Math.PI);
                if (offsetx != 0.0) {
                    XParticle.rotateAroundX(vector, x);
                }
                if (offsety != 0.0) {
                    XParticle.rotateAroundY(vector, y);
                }
                if (offsetz != 0.0) {
                    XParticle.rotateAroundZ(vector, z);
                }
                for (ParticleDisplay display : displays) {
                    display.location.add(vector);
                }
                runnable.run();
                for (ParticleDisplay display : displays) {
                    display.location.subtract(vector);
                }
            }
        }.runTaskTimerAsynchronously((Plugin)plugin, 0L, update);
    }

    public static BukkitTask moveAround(JavaPlugin plugin, long update, final double rate, final double endRate, final double offsetx, final double offsety, final double offsetz, final Runnable runnable, final ParticleDisplay ... displays) {
        return new BukkitRunnable(){
            double multiplier = 0.0;
            boolean opposite = false;

            public void run() {
                this.multiplier = this.opposite ? (this.multiplier -= rate) : (this.multiplier += rate);
                double x = this.multiplier * offsetx;
                double y = this.multiplier * offsety;
                double z = this.multiplier * offsetz;
                for (ParticleDisplay display : displays) {
                    display.location.add(x, y, z);
                }
                runnable.run();
                for (ParticleDisplay display : displays) {
                    display.location.subtract(x, y, z);
                }
                if (this.opposite) {
                    if (this.multiplier <= 0.0) {
                        this.opposite = !this.opposite;
                    }
                } else if (this.multiplier >= endRate) {
                    this.opposite = !this.opposite;
                }
            }
        }.runTaskTimerAsynchronously((Plugin)plugin, 0L, update);
    }

    public static BukkitTask testDisplay(JavaPlugin plugin, Runnable runnable) {
        return Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)plugin, runnable, 0L, 1L);
    }

    public static BukkitTask rotateAround(JavaPlugin plugin, long update, final double rate, final double offsetx, final double offsety, final double offsetz, final Runnable runnable, final ParticleDisplay ... displays) {
        return new BukkitRunnable(){
            double rotation = 180.0;

            public void run() {
                this.rotation += rate;
                double x = Math.toRadians((90.0 + this.rotation) * offsetx);
                double y = Math.toRadians((60.0 + this.rotation) * offsety);
                double z = Math.toRadians((30.0 + this.rotation) * offsetz);
                Vector vector = new Vector(x, y, z);
                for (ParticleDisplay display : displays) {
                    display.rotate(vector);
                }
                runnable.run();
            }
        }.runTaskTimerAsynchronously((Plugin)plugin, 0L, update);
    }

    public static BukkitTask guard(JavaPlugin plugin, long update, final double rate, final double offsetx, final double offsety, final double offsetz, final Runnable runnable, final ParticleDisplay ... displays) {
        return new BukkitRunnable(){
            double rotation = 180.0;

            public void run() {
                this.rotation += rate;
                double x = Math.toRadians((90.0 + this.rotation) * offsetx);
                double y = Math.toRadians((60.0 + this.rotation) * offsety);
                double z = Math.toRadians((30.0 + this.rotation) * offsetz);
                Vector vector = new Vector(offsetx * Math.PI, offsety * Math.PI, offsetz * Math.PI);
                XParticle.rotateAroundX(vector, x);
                XParticle.rotateAroundY(vector, y);
                XParticle.rotateAroundZ(vector, z);
                for (ParticleDisplay display : displays) {
                    display.rotation = new Vector(x, y, z);
                    display.location.add(vector);
                }
                runnable.run();
                for (ParticleDisplay display : displays) {
                    display.location.subtract(vector);
                }
            }
        }.runTaskTimerAsynchronously((Plugin)plugin, 0L, update);
    }

    public static void sphere(double radius, double rate, ParticleDisplay display) {
        double rateDiv = Math.PI / rate;
        for (double phi = 0.0; phi <= Math.PI; phi += rateDiv) {
            double y1 = radius * Math.cos(phi);
            double y2 = radius * Math.sin(phi);
            for (double theta = 0.0; theta <= Math.PI * 2; theta += rateDiv) {
                double x = Math.cos(theta) * y2;
                double z = Math.sin(theta) * y2;
                if (display.isDirectional()) {
                    double omega = Math.atan2(z, x);
                    double directionX = Math.cos(omega);
                    double directionY = Math.sin(Math.atan2(y2, y1));
                    double directionZ = Math.sin(omega);
                    display.offset(directionX, directionY, directionZ);
                }
                display.spawn(x, y1, z);
            }
        }
    }

    public static void spikeSphere(double radius, double rate, int chance, double minRandomDistance, double maxRandomDistance, ParticleDisplay display) {
        double rateDiv = Math.PI / rate;
        for (double phi = 0.0; phi <= Math.PI; phi += rateDiv) {
            double y = radius * Math.cos(phi);
            double sinPhi = radius * Math.sin(phi);
            for (double theta = 0.0; theta <= Math.PI * 2; theta += rateDiv) {
                double x = Math.cos(theta) * sinPhi;
                double z = Math.sin(theta) * sinPhi;
                if (chance != 0 && XParticle.randInt(0, chance) != 1) continue;
                Location start = display.cloneLocation(x, y, z);
                Vector endVect = start.clone().subtract(display.location).toVector().multiply(XParticle.random(minRandomDistance, maxRandomDistance));
                Location end = start.clone().add(endVect);
                XParticle.line(start, end, 0.1, display);
            }
        }
    }

    public static void ring(double rate, double radius, double tubeRadius, ParticleDisplay display) {
        double rateDiv = Math.PI / rate;
        double tubeDiv = Math.PI / tubeRadius;
        for (double theta = 0.0; theta <= Math.PI * 2; theta += rateDiv) {
            double cos = Math.cos(theta);
            double sin = Math.sin(theta);
            for (double phi = 0.0; phi <= Math.PI * 2; phi += tubeDiv) {
                double finalRadius = radius + tubeRadius * Math.cos(phi);
                double x = finalRadius * cos;
                double y = finalRadius * sin;
                double z = tubeRadius * Math.sin(phi);
                display.spawn(x, y, z);
            }
        }
    }

    public static void spread(JavaPlugin plugin, final int amount, final int rate, final Location start, final Location originEnd, final double offsetx, final double offsety, final double offsetz, final ParticleDisplay display) {
        new BukkitRunnable(){
            int count;
            {
                this.count = amount;
            }

            public void run() {
                int frame = rate;
                while (frame-- != 0) {
                    double x = XParticle.random(-offsetx, offsetx);
                    double y = XParticle.random(-offsety, offsety);
                    double z = XParticle.random(-offsetz, offsetz);
                    Location end = originEnd.clone().add(x, y, z);
                    XParticle.line(start, end, 0.1, display);
                }
                if (this.count-- == 0) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)plugin, 0L, 1L);
    }

    public static void heart(double cut, double cutAngle, double depth, double compressHeight, double rate, ParticleDisplay display) {
        for (double theta = 0.0; theta <= Math.PI * 2; theta += Math.PI / rate) {
            double phi = theta / cut;
            double cos = Math.cos(phi);
            double sin = Math.sin(phi);
            double omega = Math.pow(Math.abs(Math.sin(2.0 * cutAngle * phi)) + depth * Math.abs(Math.sin(cutAngle * phi)), 1.0 / compressHeight);
            double y = omega * (sin + cos);
            double z = omega * (cos - sin);
            display.spawn(0.0, y, z);
        }
    }

    public static void atomic(JavaPlugin plugin, final int orbits, final double radius, final double rate, final ParticleDisplay orbit) {
        new BukkitRunnable(){
            final double rateDiv;
            final double dist;
            double theta;
            {
                this.rateDiv = Math.PI / rate;
                this.dist = Math.PI / (double)orbits;
                this.theta = 0.0;
            }

            public void run() {
                int orbital = orbits;
                this.theta += this.rateDiv;
                double x = radius * Math.cos(this.theta);
                double z = radius * Math.sin(this.theta);
                double angle = 0.0;
                while (orbital > 0) {
                    orbit.rotation = new Vector(0.0, 0.0, angle);
                    orbit.spawn(x, 0.0, z);
                    --orbital;
                    angle += this.dist;
                }
            }
        }.runTaskTimerAsynchronously((Plugin)plugin, 0L, 1L);
    }

    public static BukkitTask helix(JavaPlugin plugin, final int strings, final double radius, final double rate, final double extension, final int height, final int speed, final boolean fadeUp, final boolean fadeDown, final ParticleDisplay display) {
        return new BukkitRunnable(){
            final double dist;
            final double radiusDiv;
            final double radiusDiv2;
            double dynamicRadius;
            boolean center;
            double y;
            {
                this.dist = Math.PI * 2 / (double)strings;
                this.radiusDiv = radius / ((double)height / rate);
                this.radiusDiv2 = fadeUp && fadeDown ? this.radiusDiv * 2.0 : this.radiusDiv;
                this.dynamicRadius = fadeDown ? 0.0 : radius;
                this.center = !fadeDown;
                this.y = 0.0;
            }

            public void run() {
                int repeat = speed;
                while (repeat-- > 0) {
                    this.y += rate;
                    double x = this.dynamicRadius * Math.cos(extension * this.y);
                    double z = this.dynamicRadius * Math.sin(extension * this.y);
                    if (!this.center) {
                        this.dynamicRadius += this.radiusDiv2;
                        if (this.dynamicRadius >= radius) {
                            this.center = true;
                        }
                    } else if (fadeUp) {
                        this.dynamicRadius -= this.radiusDiv2;
                    }
                    int tempString = strings;
                    double angle = 0.0;
                    while (tempString > 0) {
                        display.rotate(0.0, angle, 0.0);
                        display.spawn(x, this.y, z);
                        display.rotate(0.0, -angle, 0.0);
                        --tempString;
                        angle += this.dist;
                    }
                    if (!(this.y > (double)height)) continue;
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)plugin, 0L, 1L);
    }

    public static void lightning(Location start, Vector direction, int entries, int branches, double radius, double offset, double offsetRate, double length, double lengthRate, double branch, double branchRate, ParticleDisplay display) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (entries <= 0) {
            return;
        }
        boolean inRange = true;
        while (random.nextDouble() < branch || inRange) {
            Vector randomizer = new Vector(random.nextDouble(-radius, radius), random.nextDouble(-radius, radius), random.nextDouble(-radius, radius)).normalize().multiply(random.nextDouble(-radius, radius) * offset);
            Vector endVector = start.clone().toVector().add(direction.clone().multiply(length)).add(randomizer);
            Location end = endVector.toLocation(start.getWorld());
            if (end.distance(start) <= length) {
                inRange = true;
                continue;
            }
            inRange = false;
            int rate = (int)(start.distance(end) / 0.1);
            Vector rateDir = endVector.clone().subtract(start.toVector()).normalize().multiply(0.1);
            for (int i = 0; i < rate; ++i) {
                Location loc = start.clone().add(rateDir.clone().multiply(i));
                display.spawn(loc);
            }
            XParticle.lightning(end.clone(), direction, entries - 1, branches - 1, radius, offset * offsetRate, offsetRate, length * lengthRate, lengthRate, branch * branchRate, branchRate, display);
            if (branches > 0) continue;
            break;
        }
    }

    public static void dna(double radius, double rate, double extension, int height, int hydrogenBondDist, ParticleDisplay display, ParticleDisplay hydrogenBondDisplay) {
        int nucleotideDist = 0;
        for (double y = 0.0; y <= (double)height; y += rate) {
            ++nucleotideDist;
            double x = radius * Math.cos(extension * y);
            double z = radius * Math.sin(extension * y);
            Location nucleotide1 = display.location.clone().add(x, y, z);
            display.spawn(x, y, z);
            Location nucleotide2 = display.location.clone().subtract(x, -y, z);
            display.spawn(-x, y, -z);
            if (nucleotideDist < hydrogenBondDist) continue;
            nucleotideDist = 0;
            XParticle.line(nucleotide1, nucleotide2, rate * 2.0, hydrogenBondDisplay);
        }
    }

    public static BukkitTask dnaReplication(JavaPlugin plugin, final double radius, final double rate, final int speed, final double extension, final int height, final int hydrogenBondDist, final ParticleDisplay display) {
        final ParticleDisplay adenine = ParticleDisplay.colored(null, Color.BLUE, 1.0f);
        final ParticleDisplay thymine = ParticleDisplay.colored(null, Color.YELLOW, 1.0f);
        final ParticleDisplay guanine = ParticleDisplay.colored(null, Color.GREEN, 1.0f);
        final ParticleDisplay cytosine = ParticleDisplay.colored(null, Color.RED, 1.0f);
        return new BukkitRunnable(){
            double y = 0.0;
            int nucleotideDist = 0;

            public void run() {
                int repeat = speed;
                while (repeat-- != 0) {
                    this.y += rate;
                    ++this.nucleotideDist;
                    double x = radius * Math.cos(extension * this.y);
                    double z = radius * Math.sin(extension * this.y);
                    Location nucleotide1 = display.location.clone().add(x, this.y, z);
                    XParticle.circle(0.1, 10.0, display.cloneWithLocation(x, this.y, z));
                    Location nucleotide2 = display.location.clone().subtract(x, -this.y, z);
                    XParticle.circle(0.1, 10.0, display.cloneWithLocation(-x, this.y, -z));
                    Location midPointBond = nucleotide1.toVector().midpoint(nucleotide2.toVector()).toLocation(nucleotide1.getWorld());
                    if (this.nucleotideDist >= hydrogenBondDist) {
                        this.nucleotideDist = 0;
                        if (XParticle.randInt(0, 1) == 1) {
                            XParticle.line(nucleotide1, midPointBond, rate - 0.1, adenine);
                            XParticle.line(nucleotide2, midPointBond, rate - 0.1, thymine);
                        } else {
                            XParticle.line(nucleotide1, midPointBond, rate - 0.1, cytosine);
                            XParticle.line(nucleotide2, midPointBond, rate - 0.1, guanine);
                        }
                    }
                    if (!(this.y >= (double)height)) continue;
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)plugin, 0L, 1L);
    }

    public static void drawLine(Player player, double length, double rate, ParticleDisplay display) {
        Location eye = player.getEyeLocation();
        XParticle.line(eye, eye.clone().add(eye.getDirection().multiply(length)), rate, display);
    }

    public static BukkitTask cloud(JavaPlugin plugin, final ParticleDisplay cloud, final ParticleDisplay rain) {
        return new BukkitRunnable(){

            public void run() {
                cloud.spawn();
                rain.spawn();
            }
        }.runTaskTimerAsynchronously((Plugin)plugin, 0L, 1L);
    }

    public static void line(Location start, Location end, double rate, ParticleDisplay display) {
        double x = end.getX() - start.getX();
        double y = end.getY() - start.getY();
        double z = end.getZ() - start.getZ();
        double length = Math.sqrt(NumberConversions.square((double)x) + NumberConversions.square((double)y) + NumberConversions.square((double)z));
        x /= length;
        y /= length;
        z /= length;
        ParticleDisplay clone = display.clone();
        clone.location = start;
        for (double i = 0.0; i < length; i += rate) {
            if (i > length) {
                i = length;
            }
            clone.spawn(x * i, y * i, z * i);
        }
    }

    public static void rectangle(Location start, Location end, double rate, ParticleDisplay display) {
        display.location = start;
        double maxX = Math.max(start.getX(), end.getX());
        double minX = Math.min(start.getX(), end.getX());
        double maxY = Math.max(start.getY(), end.getY());
        double minY = Math.min(start.getY(), end.getY());
        for (double x = minX; x <= maxX; x += rate) {
            for (double y = minY; y <= maxY; y += rate) {
                display.spawn(x - minX, y - minY, 0.0);
            }
        }
    }

    public static void cage(Location start, Location end, double rate, double barRate, ParticleDisplay display) {
        double maxX = Math.max(start.getX(), end.getX());
        double minX = Math.min(start.getX(), end.getX());
        double maxZ = Math.max(start.getZ(), end.getZ());
        double minZ = Math.min(start.getZ(), end.getZ());
        double barChance = 0.0;
        for (double x = minX; x <= maxX; x += rate) {
            for (double z = minZ; z <= maxZ; z += rate) {
                Location barStart = display.spawn(x - minX, 0.0, z - minZ);
                Location barEnd = display.spawn(x - minX, 3.0, z - minZ);
                if (x != minX && !(x + rate > maxX) && z != minZ && !(z + rate > maxZ) || !((barChance += 1.0) >= barRate)) continue;
                barChance = 0.0;
                XParticle.line(barStart, barEnd, rate, display);
            }
        }
    }

    public static void filledCube(Location start, Location end, double rate, ParticleDisplay display) {
        display.location = start;
        double maxX = Math.max(start.getX(), end.getX());
        double minX = Math.min(start.getX(), end.getX());
        double maxY = Math.max(start.getY(), end.getY());
        double minY = Math.min(start.getY(), end.getY());
        double maxZ = Math.max(start.getZ(), end.getZ());
        double minZ = Math.min(start.getZ(), end.getZ());
        for (double x = minX; x <= maxX; x += rate) {
            for (double y = minY; y <= maxY; y += rate) {
                for (double z = minZ; z <= maxZ; z += rate) {
                    display.spawn(x - minX, y - minY, z - minZ);
                }
            }
        }
    }

    public static void cube(Location start, Location end, double rate, ParticleDisplay display) {
        display.location = start;
        double maxX = Math.max(start.getX(), end.getX());
        double minX = Math.min(start.getX(), end.getX());
        double maxY = Math.max(start.getY(), end.getY());
        double minY = Math.min(start.getY(), end.getY());
        double maxZ = Math.max(start.getZ(), end.getZ());
        double minZ = Math.min(start.getZ(), end.getZ());
        for (double x = minX; x <= maxX; x += rate) {
            for (double y = minY; y <= maxY; y += rate) {
                for (double z = minZ; z <= maxZ; z += rate) {
                    if (y != minY && !(y + rate > maxY) && x != minX && !(x + rate > maxX) && z != minZ && !(z + rate > maxZ)) continue;
                    display.spawn(x - minX, y - minY, z - minZ);
                }
            }
        }
    }

    public static void structuredCube(Location start, Location end, double rate, ParticleDisplay display) {
        display.location = start;
        double maxX = Math.max(start.getX(), end.getX());
        double minX = Math.min(start.getX(), end.getX());
        double maxY = Math.max(start.getY(), end.getY());
        double minY = Math.min(start.getY(), end.getY());
        double maxZ = Math.max(start.getZ(), end.getZ());
        double minZ = Math.min(start.getZ(), end.getZ());
        for (double x = minX; x <= maxX; x += rate) {
            for (double y = minY; y <= maxY; y += rate) {
                for (double z = minZ; z <= maxZ; z += rate) {
                    int components = 0;
                    if (x == minX || x + rate > maxX) {
                        ++components;
                    }
                    if (y == minY || y + rate > maxY) {
                        ++components;
                    }
                    if (z == minZ || z + rate > maxZ) {
                        ++components;
                    }
                    if (components < 2) continue;
                    display.spawn(x - minX, y - minY, z - minZ);
                }
            }
        }
    }

    public static void hypercube(Location startOrigin, Location endOrigin, double rate, double sizeRate, int cubes, ParticleDisplay display) {
        ArrayList<Location> previousPoints = null;
        for (int i = 0; i < cubes + 1; ++i) {
            ArrayList<Location> points = new ArrayList<Location>();
            Location start = startOrigin.clone().subtract((double)i * sizeRate, (double)i * sizeRate, (double)i * sizeRate);
            Location end = endOrigin.clone().add((double)i * sizeRate, (double)i * sizeRate, (double)i * sizeRate);
            display.location = start;
            double maxX = Math.max(start.getX(), end.getX());
            double minX = Math.min(start.getX(), end.getX());
            double maxY = Math.max(start.getY(), end.getY());
            double minY = Math.min(start.getY(), end.getY());
            double maxZ = Math.max(start.getZ(), end.getZ());
            double minZ = Math.min(start.getZ(), end.getZ());
            points.add(new Location(start.getWorld(), maxX, maxY, maxZ));
            points.add(new Location(start.getWorld(), minX, minY, minZ));
            points.add(new Location(start.getWorld(), maxX, minY, maxZ));
            points.add(new Location(start.getWorld(), minX, maxY, minZ));
            points.add(new Location(start.getWorld(), minX, minY, maxZ));
            points.add(new Location(start.getWorld(), maxX, minY, minZ));
            points.add(new Location(start.getWorld(), maxX, maxY, minZ));
            points.add(new Location(start.getWorld(), minX, maxY, maxZ));
            if (previousPoints != null) {
                for (int p = 0; p < 8; ++p) {
                    Location current = (Location)points.get(p);
                    Location previous = (Location)previousPoints.get(p);
                    XParticle.line(previous, current, rate, display);
                }
            }
            previousPoints = points;
            for (double x = minX; x <= maxX; x += rate) {
                for (double y = minY; y <= maxY; y += rate) {
                    for (double z = minZ; z <= maxZ; z += rate) {
                        int components = 0;
                        if (x == minX || x + rate > maxX) {
                            ++components;
                        }
                        if (y == minY || y + rate > maxY) {
                            ++components;
                        }
                        if (z == minZ || z + rate > maxZ) {
                            ++components;
                        }
                        if (components < 2) continue;
                        display.spawn(x - minX, y - minY, z - minZ);
                    }
                }
            }
        }
    }

    public static BukkitTask tesseract(JavaPlugin plugin, final double size, final double rate, final double speed, final long ticks, final ParticleDisplay display) {
        final double[][] positions = new double[][]{{-1.0, -1.0, -1.0, 1.0}, {1.0, -1.0, -1.0, 1.0}, {1.0, 1.0, -1.0, 1.0}, {-1.0, 1.0, -1.0, 1.0}, {-1.0, -1.0, 1.0, 1.0}, {1.0, -1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {-1.0, 1.0, 1.0, 1.0}, {-1.0, -1.0, -1.0, -1.0}, {1.0, -1.0, -1.0, -1.0}, {1.0, 1.0, -1.0, -1.0}, {-1.0, 1.0, -1.0, -1.0}, {-1.0, -1.0, 1.0, -1.0}, {1.0, -1.0, 1.0, -1.0}, {1.0, 1.0, 1.0, -1.0}, {-1.0, 1.0, 1.0, -1.0}};
        final ArrayList<int[]> connections = new ArrayList<int[]>();
        int level = 1;
        for (int h = 0; h <= level; ++h) {
            int start;
            for (int i = start = 8 * h; i < start + 4; ++i) {
                connections.add(new int[]{i, (i + 1) % 4 + start});
                connections.add(new int[]{i + 4, (i + 1) % 4 + 4 + start});
                connections.add(new int[]{i, i + 4});
            }
        }
        for (int i = 0; i < (level + 1) * 4; ++i) {
            connections.add(new int[]{i, i + 8});
        }
        return new BukkitRunnable(){
            double angle = 0.0;
            long repeat = 0L;

            public void run() {
                double cos = Math.cos(this.angle);
                double sin = Math.sin(this.angle);
                double[][] rotationXY = new double[][]{{cos, -sin, 0.0, 0.0}, {sin, cos, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
                double[][] rotationZW = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, cos, -sin}, {0.0, 0.0, sin, cos}};
                double[][] projected3D = new double[positions.length][4];
                for (int i = 0; i < positions.length; ++i) {
                    double[] point = positions[i];
                    double[] rotated = XParticle.matrix(rotationXY, point);
                    rotated = XParticle.matrix(rotationZW, rotated);
                    int distance = 2;
                    double w = 1.0 / ((double)distance - rotated[3]);
                    double[][] projection = new double[][]{{w, 0.0, 0.0, 0.0}, {0.0, w, 0.0, 0.0}, {0.0, 0.0, w, 0.0}};
                    double[] projected = XParticle.matrix(projection, rotated);
                    int proj = 0;
                    while (proj < projected.length) {
                        int n = proj++;
                        projected[n] = projected[n] * size;
                    }
                    projected3D[i] = projected;
                    display.spawn(projected[0], projected[1], projected[2]);
                }
                for (int[] connection : connections) {
                    double[] pointA = projected3D[connection[0]];
                    double[] pointB = projected3D[connection[1]];
                    Location start = display.cloneLocation(pointA[0], pointA[1], pointA[2]);
                    Location end = display.cloneLocation(pointB[0], pointB[1], pointB[2]);
                    XParticle.line(start, end, rate, display);
                }
                if (++this.repeat > ticks) {
                    this.cancel();
                } else {
                    this.angle += speed;
                }
            }
        }.runTaskTimerAsynchronously((Plugin)plugin, 0L, 1L);
    }

    private static double[] matrix(double[][] a, double[] m) {
        double[][] b = new double[4][1];
        b[0][0] = m[0];
        b[1][0] = m[1];
        b[2][0] = m[2];
        b[3][0] = m[3];
        int colsA = a[0].length;
        int rowsA = a.length;
        int colsB = b[0].length;
        int rowsB = b.length;
        double[][] result = new double[rowsA][rowsB];
        for (int i = 0; i < rowsA; ++i) {
            for (int j = 0; j < colsB; ++j) {
                float sum = 0.0f;
                for (int k = 0; k < colsA; ++k) {
                    sum = (float)((double)sum + a[i][k] * b[k][j]);
                }
                result[i][j] = sum;
            }
        }
        double[] v = new double[4];
        v[0] = result[0][0];
        v[1] = result[1][0];
        v[2] = result[2][0];
        if (result.length > 3) {
            v[3] = result[3][0];
        }
        return v;
    }

    public static void mandelbrot(double size, double zoom, double rate, double x0, double y0, int color, ParticleDisplay display) {
        for (double y = -size; y < size; y += rate) {
            for (double x = -size; x < size; x += rate) {
                int iteration;
                double zy = 0.0;
                double zx = 0.0;
                double cX = (x - x0) / zoom;
                double cY = (y - y0) / zoom;
                for (iteration = color; zx * zx + zy * zy <= 4.0 && iteration > 0; --iteration) {
                    double xtemp = zx * zx - zy * zy + cX;
                    zy = 2.0 * zx * zy + cY;
                    zx = xtemp;
                }
                if (iteration != 0) continue;
                display.spawn(x, y, 0.0);
            }
        }
    }

    public static void julia(double size, double zoom, int colorScheme, double moveX, double moveY, ParticleDisplay display) {
        display.particle = Particle.REDSTONE;
        double cx = -0.7;
        double cy = 0.27015;
        for (double x = -size; x < size; x += 0.1) {
            for (double y = -size; y < size; y += 0.1) {
                int i;
                double zx = 1.5 * (size - size / 2.0) / (0.5 * zoom * size) + moveX;
                double zy = (y - size / 2.0) / (0.5 * zoom * size) + moveY;
                for (i = colorScheme; zx * zx + zy * zy < 4.0 && i > 0; --i) {
                    double xtemp = zx * zx - zy * zy + cx;
                    zy = 2.0 * zx * zy + cy;
                    zx = xtemp;
                }
                Color color = new Color((i << 21) + (i << 10) + i * 8);
                display.data = new float[]{color.getRed(), color.getGreen(), color.getBlue(), 0.8f};
                display.spawn(x, y, 0.0);
            }
        }
    }

    public static void star(JavaPlugin plugin, final int points, int spikes, double rate, final double spikeLength, final double coreRadius, final double neuron, final boolean prototype, final int speed, final ParticleDisplay display) {
        final double pointsRate = Math.PI * 2 / (double)points;
        final double rateDiv = Math.PI / rate;
        final ThreadLocalRandom random = prototype ? null : ThreadLocalRandom.current();
        for (int i = 0; i < spikes * 2; ++i) {
            final double spikeAngle = (double)i * Math.PI / (double)spikes;
            new BukkitRunnable(){
                double vein = 0.0;
                double theta = 0.0;

                public void run() {
                    int repeat = speed;
                    while (repeat-- != 0) {
                        this.theta += rateDiv;
                        double height = (prototype ? this.vein : random.nextDouble(0.0, neuron)) * spikeLength;
                        if (prototype) {
                            this.vein += neuron;
                        }
                        Vector vector = new Vector(Math.cos(this.theta), 0.0, Math.sin(this.theta));
                        vector.multiply((spikeLength - height) * coreRadius / spikeLength);
                        vector.setY(coreRadius + height);
                        XParticle.rotateAroundX(vector, spikeAngle);
                        for (int j = 0; j < points; ++j) {
                            XParticle.rotateAroundY(vector, pointsRate);
                            display.spawn(vector);
                        }
                        if (!(this.theta >= Math.PI * 2)) continue;
                        this.cancel();
                    }
                }
            }.runTaskTimerAsynchronously((Plugin)plugin, 0L, 1L);
        }
    }

    public static void eye(double radius, double radius2, double rate, double extension, ParticleDisplay display) {
        double rateDiv = Math.PI / rate;
        double limit = Math.PI / extension;
        double x = 0.0;
        for (double i = 0.0; i < limit; i += rateDiv) {
            double y = radius * Math.sin(extension * i);
            double y2 = radius2 * Math.sin(extension * -i);
            display.spawn(x, y, 0.0);
            display.spawn(x, y2, 0.0);
            x += 0.1;
        }
    }

    public static void illuminati(double size, double extension, ParticleDisplay display) {
        XParticle.polygon(3, 1, size, 1.0 / (size * 30.0), 0.0, display);
        XParticle.eye(size / 4.0, size / 4.0, 30.0, extension, display.cloneWithLocation(0.3, 0.0, size / 1.8).rotate(1.5707963267948966, 1.5707963267948966, 0.0));
        XParticle.circle(size / 5.0, size * 5.0, display.cloneWithLocation(0.3, 0.0, 0.0));
    }

    public static void polygon(int points, int connection, double size, double rate, double extend, ParticleDisplay display) {
        for (int point = 0; point < points; ++point) {
            double angle = Math.toRadians(360.0 / (double)points * (double)point);
            double nextAngle = Math.toRadians(360.0 / (double)points * (double)(point + connection));
            double x = Math.cos(angle) * size;
            double z = Math.sin(angle) * size;
            double x2 = Math.cos(nextAngle) * size;
            double z2 = Math.sin(nextAngle) * size;
            double deltaX = x2 - x;
            double deltaZ = z2 - z;
            for (double pos = 0.0; pos < 1.0 + extend; pos += rate) {
                display.spawn(x + deltaX * pos, 0.0, z + deltaZ * pos);
            }
        }
    }

    public static Vector rotateAroundX(Vector vector, double angle) {
        if (angle == 0.0) {
            return vector;
        }
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double y = vector.getY() * cos - vector.getZ() * sin;
        double z = vector.getY() * sin + vector.getZ() * cos;
        return vector.setY(y).setZ(z);
    }

    public static Vector rotateAroundY(Vector vector, double angle) {
        if (angle == 0.0) {
            return vector;
        }
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x = vector.getX() * cos + vector.getZ() * sin;
        double z = vector.getX() * -sin + vector.getZ() * cos;
        return vector.setX(x).setZ(z);
    }

    public static Vector rotateAroundZ(Vector vector, double angle) {
        if (angle == 0.0) {
            return vector;
        }
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x = vector.getX() * cos - vector.getY() * sin;
        double y = vector.getX() * sin + vector.getY() * cos;
        return vector.setX(x).setY(y);
    }

    public static Vector rotateAround(Vector vector, double x, double y, double z) {
        XParticle.rotateAroundX(vector, x);
        XParticle.rotateAroundY(vector, y);
        XParticle.rotateAroundZ(vector, z);
        return vector;
    }

    public static void neopaganPentagram(double size, double rate, double extend, ParticleDisplay star, ParticleDisplay circle) {
        XParticle.polygon(5, 2, size, rate, extend, star);
        XParticle.circle(size + 0.5, rate * 1000.0, circle);
    }

    public static void atom(int orbits, double radius, double rate, ParticleDisplay orbit, ParticleDisplay nucleus) {
        double dist = Math.PI / (double)orbits;
        double angle = 0.0;
        while (orbits > 0) {
            orbit.rotation = new Vector(0.0, 0.0, angle);
            XParticle.circle(radius, rate, orbit);
            --orbits;
            angle += dist;
        }
        XParticle.sphere(radius / 3.0, rate / 2.0, nucleus);
    }

    public static void meguminExplosion(JavaPlugin plugin, double size, ParticleDisplay display) {
        XParticle.polygon(10, 4, size, 0.02, 0.3, display);
        XParticle.polygon(10, 3, size / (size - 1.0), 0.5, 0.0, display);
        XParticle.circle(size, 40.0, display);
        XParticle.spread(plugin, 30, 2, display.location, display.location.clone().add(0.0, 10.0, 0.0), 5.0, 5.0, 5.0, display);
    }

    public static void explosionWave(JavaPlugin plugin, final double rate, final ParticleDisplay display, final ParticleDisplay secDisplay) {
        new BukkitRunnable(){
            final double addition = 0.3141592653589793;
            final double rateDiv = Math.PI / rate;
            double times = 0.7853981633974483;

            public void run() {
                this.times += 0.3141592653589793;
                for (double theta = 0.0; theta <= Math.PI * 2; theta += this.rateDiv) {
                    double x = this.times * Math.cos(theta);
                    double y = 2.0 * Math.exp(-0.1 * this.times) * Math.sin(this.times) + 1.5;
                    double z = this.times * Math.sin(theta);
                    display.spawn(x, y, z);
                    x = this.times * Math.cos(theta += 0.04908738521234052);
                    z = this.times * Math.sin(theta);
                    secDisplay.spawn(x, y, z);
                }
                if (this.times > 20.0) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)plugin, 0L, 1L);
    }

    private static BufferedImage getImage(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try {
            return ImageIO.read(Files.newInputStream(path, StandardOpenOption.READ));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static CompletableFuture<BufferedImage> getScaledImage(Path path, int width, int height) {
        return CompletableFuture.supplyAsync(() -> {
            BufferedImage image = XParticle.getImage(path);
            if (image == null) {
                return null;
            }
            int finalHeight = height;
            int finalWidth = width;
            if (image.getWidth() > image.getHeight()) {
                finalHeight = width * image.getHeight() / image.getWidth();
            } else {
                finalWidth = height * image.getWidth() / image.getHeight();
            }
            BufferedImage resizedImg = new BufferedImage(width, height, 2);
            Graphics2D graphics = resizedImg.createGraphics();
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.drawImage(image, 0, 0, finalWidth, finalHeight, null);
            graphics.dispose();
            return resizedImg;
        });
    }

    public static CompletableFuture<Map<double[], org.bukkit.Color>> renderImage(Path path, int resizedWidth, int resizedHeight, double compact) {
        return XParticle.getScaledImage(path, resizedWidth, resizedHeight).thenCompose(image -> XParticle.renderImage(image, resizedWidth, resizedHeight, compact));
    }

    public static CompletableFuture<Map<double[], org.bukkit.Color>> renderImage(BufferedImage image, int resizedWidth, int resizedHeight, double compact) {
        return CompletableFuture.supplyAsync(() -> {
            if (image == null) {
                return null;
            }
            int width = image.getWidth();
            int height = image.getHeight();
            double centerX = (double)width / 2.0;
            double centerY = (double)height / 2.0;
            HashMap<double[], org.bukkit.Color> rendered = new HashMap<double[], org.bukkit.Color>();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int pixel = image.getRGB(x, y);
                    if (pixel >> 24 == 0) continue;
                    Color color = new Color(pixel);
                    int r = color.getRed();
                    int g = color.getGreen();
                    int b = color.getBlue();
                    double[] coords = new double[]{((double)x - centerX) * compact, ((double)y - centerY) * compact};
                    org.bukkit.Color bukkitColor = org.bukkit.Color.fromRGB((int)r, (int)g, (int)b);
                    rendered.put(coords, bukkitColor);
                }
            }
            return rendered;
        });
    }

    public static BukkitTask displayRenderedImage(JavaPlugin plugin, final Map<double[], org.bukkit.Color> render, final Callable<Location> location, final int repeat, long period, final int quality, final int speed, final float size) {
        return new BukkitRunnable(){
            int times;
            {
                this.times = repeat;
            }

            public void run() {
                try {
                    XParticle.displayRenderedImage(render, (Location)location.call(), quality, speed, size);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (this.times-- < 1) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)plugin, 0L, period);
    }

    public static void displayRenderedImage(Map<double[], org.bukkit.Color> render, Location location, int quality, int speed, float size) {
        World world = location.getWorld();
        for (Map.Entry<double[], org.bukkit.Color> pixel : render.entrySet()) {
            Particle.DustOptions data = new Particle.DustOptions(pixel.getValue(), size);
            double[] pixelLoc = pixel.getKey();
            Location loc = new Location(world, location.getX() - pixelLoc[0], location.getY() - pixelLoc[1], location.getZ());
            world.spawnParticle(Particle.REDSTONE, loc, quality, 0.0, 0.0, 0.0, (double)speed, (Object)data);
        }
    }

    public static void saveImage(BufferedImage image, Path path) {
        try {
            ImageIO.write((RenderedImage)image, "png", Files.newOutputStream(path, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static CompletableFuture<BufferedImage> stringToImage(Font font, Color color, String str) {
        return CompletableFuture.supplyAsync(() -> {
            BufferedImage image = new BufferedImage(1, 1, 2);
            Graphics2D graphics = image.createGraphics();
            graphics.setFont(font);
            FontRenderContext context = graphics.getFontMetrics().getFontRenderContext();
            Rectangle2D frame = font.getStringBounds(str, context);
            graphics.dispose();
            image = new BufferedImage((int)Math.ceil(frame.getWidth()), (int)Math.ceil(frame.getHeight()), 2);
            graphics = image.createGraphics();
            graphics.setColor(color);
            graphics.setFont(font);
            graphics.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            graphics.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
            graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            FontMetrics metrics = graphics.getFontMetrics();
            graphics.drawString(str, 0, metrics.getAscent());
            graphics.dispose();
            return image;
        });
    }
}

