/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries.particles;

import com.cryptomorin.xseries.particles.XParticle;
import java.awt.Color;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class ParticleDisplay {
    private static final boolean ISFLAT = XParticle.getParticle("FOOTSTEP") == null;
    @Nonnull
    public Particle particle;
    public Location location;
    public Callable<Location> locationCaller;
    public int count;
    public double offsetx;
    public double offsety;
    public double offsetz;
    public double extra;
    public Vector rotation;
    public Object data;

    public ParticleDisplay(@Nonnull Particle particle, @Nullable Callable<Location> locationCaller, @Nullable Location location, int count, double offsetx, double offsety, double offsetz, double extra) {
        this.particle = particle;
        this.location = location;
        this.locationCaller = locationCaller;
        this.count = count;
        this.offsetx = offsetx;
        this.offsety = offsety;
        this.offsetz = offsetz;
        this.extra = extra;
    }

    public ParticleDisplay(@Nonnull Particle particle, @Nullable Location location, int count, double offsetx, double offsety, double offsetz) {
        this(particle, null, location, count, offsetx, offsety, offsetz, 0.0);
    }

    public ParticleDisplay(@Nonnull Particle particle, @Nullable Location location, int count) {
        this(particle, location, count, 0.0, 0.0, 0.0);
    }

    public ParticleDisplay(@Nonnull Particle particle, @Nullable Location location) {
        this(particle, location, 0);
    }

    @Nonnull
    public static ParticleDisplay colored(@Nullable Location location, int r, int g, int b, float size) {
        ParticleDisplay dust = new ParticleDisplay(Particle.REDSTONE, null, location, 1, 0.0, 0.0, 0.0, 0.0);
        dust.data = new float[]{r, g, b, size};
        return dust;
    }

    @Nonnull
    public static ParticleDisplay colored(@Nullable Location location, @Nonnull Color color, float size) {
        return ParticleDisplay.colored(location, color.getRed(), color.getGreen(), color.getBlue(), size);
    }

    @Nonnull
    public static ParticleDisplay simple(@Nullable Location location, @Nonnull Particle particle) {
        Objects.requireNonNull(particle, "Cannot build ParticleDisplay with null particle");
        return new ParticleDisplay(particle, null, location, 1, 0.0, 0.0, 0.0, 0.0);
    }

    @Nonnull
    public static ParticleDisplay display(@Nonnull Location location, @Nonnull Particle particle) {
        Objects.requireNonNull(location, "Cannot display particle in null location");
        ParticleDisplay display = ParticleDisplay.simple(location, particle);
        display.spawn();
        return display;
    }

    @Nonnull
    public static ParticleDisplay fromConfig(@Nullable Location location, @Nonnull ConfigurationSection config) {
        String[] colors;
        String[] rotations;
        String[] offsets;
        Objects.requireNonNull(config, "Cannot parse ParticleDisplay from a null config section");
        Particle particle = XParticle.getParticle(config.getString("particle"));
        if (particle == null) {
            particle = Particle.FLAME;
        }
        int count = config.getInt("count");
        double extra = config.getDouble("extra");
        double offsetx = 0.0;
        double offsety = 0.0;
        double offsetz = 0.0;
        String offset = config.getString("offset");
        if (offset != null && (offsets = StringUtils.split((String)StringUtils.deleteWhitespace((String)offset), (char)',')).length > 0) {
            offsetx = NumberUtils.toDouble((String)offsets[0]);
            if (offsets.length > 1) {
                offsety = NumberUtils.toDouble((String)offsets[1]);
                if (offsets.length > 2) {
                    offsetz = NumberUtils.toDouble((String)offsets[2]);
                }
            }
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        String rotation = config.getString("rotation");
        if (rotation != null && (rotations = StringUtils.split((String)StringUtils.deleteWhitespace((String)rotation), (char)',')).length > 0) {
            x = NumberUtils.toDouble((String)rotations[0]);
            if (rotations.length > 1) {
                y = NumberUtils.toDouble((String)rotations[1]);
                if (rotations.length > 2) {
                    z = NumberUtils.toDouble((String)rotations[2]);
                }
            }
        }
        float[] rgbs = null;
        String color = config.getString("color");
        if (color != null && (colors = StringUtils.split((String)StringUtils.deleteWhitespace((String)rotation), (char)',')).length >= 3) {
            rgbs = new float[]{NumberUtils.toInt((String)colors[0]), NumberUtils.toInt((String)colors[1]), NumberUtils.toInt((String)colors[2]), colors.length > 3 ? NumberUtils.toFloat((String)colors[0]) : 1.0f};
        }
        Vector rotate = new Vector(x, y, z);
        ParticleDisplay display = new ParticleDisplay(particle, null, location, count, offsetx, offsety, offsetz, extra);
        display.rotation = rotate;
        display.data = rgbs;
        return display;
    }

    @Nonnull
    public static Location rotate(@Nonnull Location location, double x, double y, double z, @Nonnull Vector rotation) {
        if (rotation != null) {
            Vector rotate = new Vector(x, y, z);
            XParticle.rotateAround(rotate, rotation.getX(), rotation.getY(), rotation.getZ());
            return ParticleDisplay.cloneLocation(location).add(rotate);
        }
        return ParticleDisplay.cloneLocation(location).add(x, y, z);
    }

    @Nonnull
    private static Location cloneLocation(@Nonnull Location location) {
        return new Location(location.getWorld(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    @Nonnull
    public ParticleDisplay withCount(int count) {
        this.count = count;
        return this;
    }

    @Nonnull
    public ParticleDisplay withExtra(double extra) {
        this.extra = extra;
        return this;
    }

    @Nonnull
    public ParticleDisplay withColor(@Nonnull Color color, float size) {
        this.data = new float[]{color.getRed(), color.getGreen(), color.getBlue(), size};
        return this;
    }

    @Nonnull
    public ParticleDisplay withEntity(@Nullable Entity entity) {
        return this.withLocationCaller(() -> ((Entity)entity).getLocation());
    }

    @Nonnull
    public ParticleDisplay withLocationCaller(@Nullable Callable<Location> locationCaller) {
        this.locationCaller = locationCaller;
        return this;
    }

    @Nullable
    public Location getLocation() {
        try {
            return this.locationCaller == null ? this.location : this.locationCaller.call();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nonnull
    public ParticleDisplay faceEntity(@Nonnull Entity entity) {
        Objects.requireNonNull(entity, "Cannot face null entity");
        Location loc = entity.getLocation();
        this.rotation = new Vector(Math.toRadians(loc.getPitch() + 90.0f), Math.toRadians(-loc.getYaw()), 0.0);
        return this;
    }

    @Nullable
    public Location cloneLocation(double x, double y, double z) {
        if (this.location == null) {
            return null;
        }
        return ParticleDisplay.cloneLocation(this.location).add(x, y, z);
    }

    @Nonnull
    public ParticleDisplay cloneWithLocation(double x, double y, double z) {
        ParticleDisplay display = this.clone();
        if (this.location == null) {
            return display;
        }
        display.location.add(x, y, z);
        return display;
    }

    @Nonnull
    public ParticleDisplay clone() {
        ParticleDisplay display = new ParticleDisplay(this.particle, this.locationCaller, this.location == null ? null : ParticleDisplay.cloneLocation(this.location), this.count, this.offsetx, this.offsety, this.offsetz, this.extra);
        if (this.rotation != null) {
            display.rotation = this.rotation.clone();
        }
        display.data = this.data;
        return display;
    }

    @Nonnull
    public ParticleDisplay rotate(@Nonnull Vector vector) {
        Objects.requireNonNull(vector, "Cannot rotate ParticleDisplay with null vector");
        if (this.rotation == null) {
            this.rotation = vector;
        } else {
            this.rotation.add(vector);
        }
        return this;
    }

    @Nonnull
    public ParticleDisplay rotate(double x, double y, double z) {
        this.rotate(new Vector(x, y, z));
        return this;
    }

    @Nonnull
    public ParticleDisplay offset(double x, double y, double z) {
        this.offsetx = x;
        this.offsety = y;
        this.offsetz = z;
        return this;
    }

    @Nonnull
    public ParticleDisplay directional() {
        this.count = 0;
        return this;
    }

    public boolean isDirectional() {
        return this.count == 0;
    }

    public void spawn() {
        this.spawn(this.getLocation(), false);
    }

    public void spawn(boolean rotate) {
        this.spawn(this.getLocation(), rotate);
    }

    public void spawn(@Nonnull Location location) {
        this.spawn(location, false);
    }

    public void spawn(@Nonnull Vector location) {
        Objects.requireNonNull(location, "Cannot add xyz of null vector to ParticleDisplay");
        this.spawn(location.getX(), location.getY(), location.getZ());
    }

    @Nonnull
    public Location spawn(double x, double y, double z) {
        Location loc = ParticleDisplay.rotate(this.getLocation(), x, y, z, this.rotation);
        this.spawn(loc, false);
        return loc;
    }

    public void spawn(@Nonnull Location loc, boolean rotate) {
        if (rotate) {
            loc = ParticleDisplay.rotate(this.getLocation(), loc.getX(), loc.getY(), loc.getZ(), this.rotation);
        }
        if (this.data != null) {
            if (this.data instanceof float[]) {
                float[] datas = (float[])this.data;
                if (ISFLAT) {
                    Particle.DustOptions dust = new Particle.DustOptions(org.bukkit.Color.fromRGB((int)((int)datas[0]), (int)((int)datas[1]), (int)((int)datas[2])), datas[3]);
                    loc.getWorld().spawnParticle(this.particle, loc, this.count, this.offsetx, this.offsety, this.offsetz, this.extra, (Object)dust);
                } else {
                    loc.getWorld().spawnParticle(this.particle, loc, this.count, (double)((int)datas[0]), (double)((int)datas[1]), (double)((int)datas[2]), (double)datas[3]);
                }
            }
        } else {
            loc.getWorld().spawnParticle(this.particle, loc, this.count, this.offsetx, this.offsety, this.offsetz, this.extra);
        }
    }
}

