/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries;

import com.cryptomorin.xseries.SkullUtils;
import com.cryptomorin.xseries.XEnchantment;
import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.XPotion;
import com.google.common.base.Enums;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.TropicalFish;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.SuspiciousStewMeta;
import org.bukkit.inventory.meta.TropicalFishBucketMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;

public class XItemStack {
    /*
     * WARNING - void declaration
     */
    public static void serialize(@Nonnull ItemStack item, @Nonnull ConfigurationSection config) {
        Objects.requireNonNull(item, "Cannot serialize a null item");
        Objects.requireNonNull(config, "Cannot serialize item from a null configuration section.");
        ItemMeta meta = item.getItemMeta();
        if (meta.hasDisplayName()) {
            config.set("name", (Object)ChatColor.stripColor((String)meta.getDisplayName()));
        }
        if (meta.hasLore()) {
            ArrayList<String> lines = new ArrayList<String>();
            for (String lore : meta.getLore()) {
                lines.add(ChatColor.stripColor((String)lore));
            }
            config.set("lore", lines);
        }
        if (item.getAmount() > 1) {
            config.set("amount", (Object)item.getAmount());
        }
        if (XMaterial.isNewVersion()) {
            Object damageable;
            if (meta instanceof Damageable && (damageable = (Damageable)meta).hasDamage()) {
                config.set("damage", (Object)damageable.getDamage());
            }
        } else if (XMaterial.isDamageable(item.getType().name())) {
            config.set("damage", (Object)item.getDurability());
        }
        config.set("material", (Object)item.getType().name());
        if (meta.hasCustomModelData()) {
            config.set("custom-model", (Object)meta.getCustomModelData());
        }
        if (meta.isUnbreakable()) {
            config.set("unbreakable", (Object)true);
        }
        for (Map.Entry entry : meta.getEnchants().entrySet()) {
            String entry2 = "enchants." + XEnchantment.matchXEnchantment((Enchantment)entry.getKey()).name();
            config.set(entry2, entry.getValue());
        }
        if (meta.getItemFlags().size() != 0) {
            ArrayList flags = new ArrayList();
            for (ItemFlag flag : meta.getItemFlags()) {
                flags.add(flag.name());
            }
            config.set("flags", (Object)flags);
        }
        if (XMaterial.supports(9) && meta.hasAttributeModifiers()) {
            for (Map.Entry entry : meta.getAttributeModifiers().entries()) {
                String path = "attributes." + ((Attribute)entry.getKey()).name() + '.';
                AttributeModifier modifier = (AttributeModifier)entry.getValue();
                config.set((String)path + "id", (Object)modifier.getUniqueId().toString());
                config.set((String)path + "name", (Object)modifier.getName());
                config.set((String)path + "amount", (Object)modifier.getAmount());
                config.set((String)path + "operation", (Object)modifier.getOperation().name());
                config.set((String)path + "slot", (Object)modifier.getSlot().name());
            }
        }
        if (meta instanceof SkullMeta) {
            if (XMaterial.isNewVersion()) {
                config.set("skull", (Object)((SkullMeta)meta).getOwningPlayer().getUniqueId().toString());
            } else {
                config.set("skull", (Object)((SkullMeta)meta).getOwner());
            }
        } else if (meta instanceof BannerMeta) {
            BannerMeta banner = (BannerMeta)meta;
            ConfigurationSection configurationSection = config.createSection("patterns");
            for (Pattern pattern : banner.getPatterns()) {
                configurationSection.set(pattern.getPattern().name(), (Object)pattern.getColor().name());
            }
        } else if (meta instanceof LeatherArmorMeta) {
            LeatherArmorMeta leather = (LeatherArmorMeta)meta;
            Color color = leather.getColor();
            config.set("color", (Object)(color.getRed() + ", " + color.getGreen() + ", " + color.getBlue()));
        } else if (meta instanceof PotionMeta) {
            PotionMeta potion = (PotionMeta)meta;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (PotionEffect effect : potion.getCustomEffects()) {
                arrayList.add(effect.getType().getName() + ", " + effect.getDuration() + ", " + effect.getAmplifier());
            }
            config.set("effects", arrayList);
            PotionData potionData = potion.getBasePotionData();
            config.set("base-effect", (Object)(potionData.getType().name() + ", " + potionData.isExtended() + ", " + potionData.isUpgraded()));
            if (potion.hasColor()) {
                config.set("color", (Object)potion.getColor().asRGB());
            }
        } else if (meta instanceof FireworkMeta) {
            FireworkMeta firework = (FireworkMeta)meta;
            config.set("power", (Object)firework.getPower());
            int n = 0;
            for (FireworkEffect fw : firework.getEffects()) {
                ConfigurationSection fwc = config.getConfigurationSection("firework." + n);
                fwc.set("type", (Object)fw.getType().name());
                ArrayList<String> colors = new ArrayList<String>();
                for (Color color : fw.getColors()) {
                    colors.add(color.getRed() + ", " + color.getGreen() + ", " + color.getBlue());
                }
                fwc.set("colors", colors);
                colors.clear();
                for (Color color : fw.getFadeColors()) {
                    colors.add(color.getRed() + ", " + color.getGreen() + ", " + color.getBlue());
                }
                fwc.set("fade-colors", colors);
            }
        } else if (XMaterial.supports(14)) {
            if (meta instanceof CrossbowMeta) {
                CrossbowMeta crossbow = (CrossbowMeta)meta;
                boolean bl = false;
                for (ItemStack projectiles : crossbow.getChargedProjectiles()) {
                    void var4_16;
                    XItemStack.serialize(projectiles, config.getConfigurationSection("projectiles." + (int)var4_16));
                    ++var4_16;
                }
            } else if (meta instanceof TropicalFishBucketMeta) {
                TropicalFishBucketMeta tropical = (TropicalFishBucketMeta)meta;
                config.set("pattern", (Object)tropical.getPattern().name());
                config.set("color", (Object)tropical.getBodyColor().name());
                config.set("pattern-color", (Object)tropical.getPatternColor().name());
            } else if (meta instanceof SuspiciousStewMeta) {
                SuspiciousStewMeta stew = (SuspiciousStewMeta)meta;
                ArrayList<String> arrayList = new ArrayList<String>();
                for (PotionEffect effect : stew.getCustomEffects()) {
                    arrayList.add(effect.getType().getName() + ", " + effect.getDuration() + ", " + effect.getAmplifier());
                }
                config.set("effects", arrayList);
            }
        }
    }

    @Nullable
    public static ItemStack deserialize(@Nonnull ConfigurationSection config) {
        ConfigurationSection attributes;
        List lores;
        int modelData;
        PotionEffect effect;
        int damage;
        Objects.requireNonNull(config, "Cannot deserialize item to a null configuration section.");
        String material = config.getString("material");
        if (material == null) {
            return null;
        }
        Optional<XMaterial> matOpt = XMaterial.matchXMaterial(material);
        if (!matOpt.isPresent()) {
            return null;
        }
        ItemStack item = matOpt.get().parseItem();
        if (item == null) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        int amount = config.getInt("amount");
        if (amount > 1) {
            item.setAmount(amount);
        }
        if (XMaterial.isNewVersion()) {
            if (meta instanceof Damageable && (damage = config.getInt("damage")) > 0) {
                ((Damageable)meta).setDamage(damage);
            }
        } else {
            damage = config.getInt("damage");
            if (damage > 0) {
                item.setDurability((short)damage);
            }
        }
        if (matOpt.get() == XMaterial.PLAYER_HEAD) {
            String skull = config.getString("skull");
            if (skull != null) {
                SkullUtils.applySkin(meta, skull);
            }
        } else if (meta instanceof BannerMeta) {
            BannerMeta banner = (BannerMeta)meta;
            ConfigurationSection patterns = config.getConfigurationSection("patterns");
            if (patterns != null) {
                for (String pattern : patterns.getKeys(false)) {
                    PatternType type = PatternType.getByIdentifier((String)pattern);
                    if (type == null) {
                        type = (PatternType)Enums.getIfPresent(PatternType.class, (String)pattern.toUpperCase(Locale.ENGLISH)).or((Object)PatternType.BASE);
                    }
                    DyeColor color = (DyeColor)Enums.getIfPresent(DyeColor.class, (String)patterns.getString(pattern).toUpperCase(Locale.ENGLISH)).or((Object)DyeColor.WHITE);
                    banner.addPattern(new Pattern(color, type));
                }
            }
        } else if (meta instanceof LeatherArmorMeta) {
            LeatherArmorMeta leather = (LeatherArmorMeta)meta;
            String colorStr = config.getString("color");
            if (colorStr != null) {
                leather.setColor(XItemStack.parseColor(colorStr));
            }
        } else if (meta instanceof PotionMeta) {
            PotionMeta potion = (PotionMeta)meta;
            for (String effects : config.getStringList("effects")) {
                effect = XPotion.parsePotionEffectFromString(effects);
                potion.addCustomEffect(effect, true);
            }
            String baseEffect = config.getString("base-effect");
            if (!Strings.isNullOrEmpty((String)baseEffect)) {
                String[] split = StringUtils.split((String)baseEffect, (char)',');
                PotionType type = (PotionType)Enums.getIfPresent(PotionType.class, (String)split[0].trim().toUpperCase(Locale.ENGLISH)).or((Object)PotionType.UNCRAFTABLE);
                boolean extended = split.length != 1 && Boolean.parseBoolean(split[1].trim());
                boolean upgraded = split.length > 2 && Boolean.parseBoolean(split[2].trim());
                PotionData potionData = new PotionData(type, extended, upgraded);
                potion.setBasePotionData(potionData);
            }
            if (config.contains("color")) {
                potion.setColor(Color.fromRGB((int)config.getInt("color")));
            }
        } else if (meta instanceof BlockStateMeta) {
            BlockStateMeta bsm = (BlockStateMeta)meta;
            BlockState state = bsm.getBlockState();
            if (state instanceof CreatureSpawner) {
                CreatureSpawner spawner = (CreatureSpawner)state;
                spawner.setSpawnedType((EntityType)Enums.getIfPresent(EntityType.class, (String)config.getString("spawner").toUpperCase(Locale.ENGLISH)).orNull());
                spawner.update(true);
                bsm.setBlockState((BlockState)spawner);
            } else if (state instanceof Banner) {
                Banner banner = (Banner)state;
                ConfigurationSection patterns = config.getConfigurationSection("patterns");
                if (patterns != null) {
                    for (String pattern : patterns.getKeys(false)) {
                        PatternType type = PatternType.getByIdentifier((String)pattern);
                        if (type == null) {
                            type = (PatternType)Enums.getIfPresent(PatternType.class, (String)pattern.toUpperCase(Locale.ENGLISH)).or((Object)PatternType.BASE);
                        }
                        DyeColor color = (DyeColor)Enums.getIfPresent(DyeColor.class, (String)patterns.getString(pattern).toUpperCase(Locale.ENGLISH)).or((Object)DyeColor.WHITE);
                        banner.addPattern(new Pattern(color, type));
                    }
                    banner.update(true);
                    bsm.setBlockState((BlockState)banner);
                }
            }
        } else if (meta instanceof FireworkMeta) {
            FireworkMeta firework = (FireworkMeta)meta;
            firework.setPower(config.getInt("power"));
            ConfigurationSection fireworkSection = config.getConfigurationSection("firework");
            if (fireworkSection != null) {
                FireworkEffect.Builder builder = FireworkEffect.builder();
                for (String fws : fireworkSection.getKeys(false)) {
                    ConfigurationSection fw = config.getConfigurationSection("firework." + fws);
                    builder.flicker(fw.getBoolean("flicker"));
                    builder.trail(fw.getBoolean("trail"));
                    builder.with((FireworkEffect.Type)Enums.getIfPresent(FireworkEffect.Type.class, (String)fw.getString("type").toUpperCase(Locale.ENGLISH)).or((Object)FireworkEffect.Type.STAR));
                    ArrayList colors = new ArrayList();
                    for (String colorStr : fw.getStringList("colors")) {
                        colors.add(XItemStack.parseColor(colorStr));
                    }
                    builder.withColor((Iterable)colors);
                    colors.clear();
                    for (String colorStr : fw.getStringList("fade-colors")) {
                        colors.add(XItemStack.parseColor(colorStr));
                    }
                    builder.withFade((Iterable)colors);
                    firework.addEffect(builder.build());
                }
            }
        } else if (XMaterial.supports(14)) {
            if (meta instanceof CrossbowMeta) {
                CrossbowMeta crossbow = (CrossbowMeta)meta;
                for (String projectiles : config.getConfigurationSection("projectiles").getKeys(false)) {
                    ItemStack projectile = XItemStack.deserialize(config.getConfigurationSection("projectiles." + projectiles));
                    crossbow.addChargedProjectile(projectile);
                }
            } else if (meta instanceof TropicalFishBucketMeta) {
                String pattern;
                TropicalFishBucketMeta tropical = (TropicalFishBucketMeta)meta;
                DyeColor color = (DyeColor)Enums.getIfPresent(DyeColor.class, (String)config.getString("color")).or((Object)DyeColor.WHITE);
                DyeColor patternColor = (DyeColor)Enums.getIfPresent(DyeColor.class, (String)config.getString("pattern-color")).or((Object)DyeColor.WHITE);
                pattern = (TropicalFish.Pattern)Enums.getIfPresent(TropicalFish.Pattern.class, (String)config.getString("pattern")).or((Object)TropicalFish.Pattern.BETTY);
                tropical.setBodyColor(color);
                tropical.setPatternColor(patternColor);
                tropical.setPattern((TropicalFish.Pattern)pattern);
            }
        } else if (XMaterial.supports(15) && meta instanceof SuspiciousStewMeta) {
            SuspiciousStewMeta stew = (SuspiciousStewMeta)meta;
            for (String effects : config.getStringList("effects")) {
                effect = XPotion.parsePotionEffectFromString(effects);
                stew.addCustomEffect(effect, true);
            }
        }
        String name = config.getString("name");
        if (!Strings.isNullOrEmpty((String)name)) {
            String translated = ChatColor.translateAlternateColorCodes((char)'&', (String)name);
            meta.setDisplayName(translated);
        }
        if (XMaterial.supports(11)) {
            meta.setUnbreakable(config.getBoolean("unbreakable"));
        }
        if (XMaterial.supports(14) && (modelData = config.getInt("model-data")) != 0) {
            meta.setCustomModelData(Integer.valueOf(modelData));
        }
        if (!(lores = config.getStringList("lore")).isEmpty()) {
            ArrayList<String> translatedLore = new ArrayList<String>();
            String lastColors = "";
            for (String lore : lores) {
                if (lore.isEmpty()) {
                    translatedLore.add(" ");
                    continue;
                }
                for (String singleLore : StringUtils.splitPreserveAllTokens((String)lore, (char)'\n')) {
                    if (singleLore.isEmpty()) {
                        translatedLore.add(" ");
                        continue;
                    }
                    singleLore = lastColors + ChatColor.translateAlternateColorCodes((char)'&', (String)singleLore);
                    translatedLore.add(singleLore);
                    lastColors = ChatColor.getLastColors((String)singleLore);
                }
            }
            meta.setLore(translatedLore);
        } else {
            String lore = config.getString("lore");
            if (!Strings.isNullOrEmpty((String)lore)) {
                ArrayList translatedLore = new ArrayList();
                String lastColors = "";
                for (String singleLore : StringUtils.splitPreserveAllTokens((String)lore, (char)'\n')) {
                    if (singleLore.isEmpty()) {
                        translatedLore.add(" ");
                        continue;
                    }
                    singleLore = lastColors + ChatColor.translateAlternateColorCodes((char)'&', (String)singleLore);
                    translatedLore.add(singleLore);
                    lastColors = ChatColor.getLastColors((String)singleLore);
                }
                meta.setLore((List)translatedLore);
            }
        }
        ConfigurationSection enchants = config.getConfigurationSection("enchants");
        if (enchants != null) {
            for (String ench : enchants.getKeys(false)) {
                Optional<XEnchantment> enchant = XEnchantment.matchXEnchantment(ench);
                enchant.ifPresent(xEnchantment -> meta.addEnchant(xEnchantment.parseEnchantment(), enchants.getInt(ench), true));
            }
        }
        List flags = config.getStringList("flags");
        for (String flag : flags) {
            if ((flag = flag.toUpperCase(Locale.ENGLISH)).equals("ALL")) {
                meta.addItemFlags(ItemFlag.values());
                break;
            }
            ItemFlag itemFlag = (ItemFlag)Enums.getIfPresent(ItemFlag.class, (String)flag).orNull();
            if (itemFlag == null) continue;
            meta.addItemFlags(new ItemFlag[]{itemFlag});
        }
        if (XMaterial.supports(9) && (attributes = config.getConfigurationSection("attributes")) != null) {
            for (String attribute : attributes.getKeys(false)) {
                Attribute attributeInst = (Attribute)Enums.getIfPresent(Attribute.class, (String)attribute.toUpperCase(Locale.ENGLISH)).orNull();
                if (attributeInst == null) continue;
                String attribId = attributes.getString("id");
                UUID id = attribId != null ? UUID.fromString(attribId) : UUID.randomUUID();
                AttributeModifier modifier = new AttributeModifier(id, attributes.getString("name"), (double)attributes.getInt("amount"), (AttributeModifier.Operation)Enums.getIfPresent(AttributeModifier.Operation.class, (String)attributes.getString("operation")).or((Object)AttributeModifier.Operation.ADD_NUMBER), (EquipmentSlot)Enums.getIfPresent(EquipmentSlot.class, (String)attributes.getString("slot")).or((Object)EquipmentSlot.HAND));
                meta.addAttributeModifier(attributeInst, modifier);
            }
        }
        item.setItemMeta(meta);
        return item;
    }

    @Nonnull
    public static Color parseColor(@Nullable String str) {
        if (Strings.isNullOrEmpty((String)str)) {
            return Color.BLACK;
        }
        String[] rgb = StringUtils.split((String)StringUtils.deleteWhitespace((String)str), (char)',');
        if (rgb.length < 3) {
            return Color.WHITE;
        }
        return Color.fromRGB((int)NumberUtils.toInt((String)rgb[0], (int)0), (int)NumberUtils.toInt((String)rgb[1], (int)0), (int)NumberUtils.toInt((String)rgb[2], (int)0));
    }

    @Nonnull
    public static List<ItemStack> giveOrDrop(@Nonnull Player player, ItemStack ... items) {
        return XItemStack.giveOrDrop(player, false, items);
    }

    @Nonnull
    public static List<ItemStack> giveOrDrop(@Nonnull Player player, boolean split, ItemStack ... items) {
        if (items == null || items.length == 0) {
            return new ArrayList<ItemStack>();
        }
        List<ItemStack> leftOvers = XItemStack.addItems((Inventory)player.getInventory(), split, items);
        World world = player.getWorld();
        Location location = player.getLocation();
        for (ItemStack drop : leftOvers) {
            world.dropItemNaturally(location, drop);
        }
        return leftOvers;
    }

    @Nonnull
    public static List<ItemStack> addItems(@Nonnull Inventory inventory, boolean split, ItemStack ... items) {
        Objects.requireNonNull(inventory, "Cannot add items to null inventory");
        Objects.requireNonNull(items, "Cannot add null items to inventory");
        ArrayList<ItemStack> leftOvers = new ArrayList<ItemStack>(items.length);
        int lastEmpty = 0;
        int invSize = inventory.getSize();
        block0: for (ItemStack item : items) {
            int partialIndex = 0;
            while (true) {
                int firstPartial;
                if ((firstPartial = XItemStack.firstPartial(inventory, item, partialIndex)) == -1) {
                    if (lastEmpty != -1) {
                        lastEmpty = XItemStack.firstEmpty(inventory, lastEmpty);
                    }
                    if (lastEmpty == -1) {
                        leftOvers.add(item);
                        continue block0;
                    }
                    partialIndex = lastEmpty;
                    int maxSize = split ? item.getMaxStackSize() : inventory.getMaxStackSize();
                    int amount = item.getAmount();
                    if (amount <= maxSize) {
                        inventory.setItem(lastEmpty, item);
                        continue block0;
                    }
                    ItemStack copy = item.clone();
                    copy.setAmount(maxSize);
                    inventory.setItem(lastEmpty, copy);
                    item.setAmount(amount - maxSize);
                    if (++lastEmpty != invSize) continue;
                    lastEmpty = -1;
                    continue;
                }
                ItemStack partialItem = inventory.getItem(firstPartial);
                int maxAmount = partialItem.getMaxStackSize();
                int partialAmount = partialItem.getAmount();
                int amount = item.getAmount();
                int sum = amount + partialAmount;
                if (sum <= maxAmount) {
                    partialItem.setAmount(sum);
                    inventory.setItem(firstPartial, partialItem);
                    continue block0;
                }
                partialItem.setAmount(maxAmount);
                inventory.setItem(firstPartial, partialItem);
                item.setAmount(sum - maxAmount);
                if (sum < maxAmount) continue;
                partialIndex = firstPartial + 1;
            }
        }
        return leftOvers;
    }

    public static int firstPartial(@Nonnull Inventory inventory, @Nullable ItemStack item, int beginIndex) {
        if (item != null) {
            ItemStack[] items = inventory.getStorageContents();
            int len = items.length;
            if (beginIndex < 0 || beginIndex >= len) {
                throw new IndexOutOfBoundsException("Begin Index: " + beginIndex + ", Size: " + len);
            }
            while (beginIndex < len) {
                ItemStack cItem = items[beginIndex];
                if (cItem != null && cItem.getAmount() < cItem.getMaxStackSize() && cItem.isSimilar(item)) {
                    return beginIndex;
                }
                ++beginIndex;
            }
        }
        return -1;
    }

    @Nonnull
    public static List<ItemStack> stack(@Nonnull Collection<ItemStack> items) {
        Objects.requireNonNull(items, "Cannot stack null items");
        ArrayList<ItemStack> stacked = new ArrayList<ItemStack>();
        for (ItemStack item : items) {
            if (item == null) continue;
            boolean add = true;
            for (ItemStack stack : stacked) {
                if (!stack.isSimilar(item)) continue;
                stack.setAmount(stack.getAmount() + item.getAmount());
                add = false;
                break;
            }
            if (!add) continue;
            stacked.add(item.clone());
        }
        return stacked;
    }

    public static int firstEmpty(@Nonnull Inventory inventory, int beginIndex) {
        ItemStack[] items = inventory.getStorageContents();
        int len = items.length;
        if (beginIndex < 0 || beginIndex >= len) {
            throw new IndexOutOfBoundsException("Begin Index: " + beginIndex + ", Size: " + len);
        }
        while (beginIndex < len) {
            if (items[beginIndex] == null) {
                return beginIndex;
            }
            ++beginIndex;
        }
        return -1;
    }
}

