/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.event.protocollib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketEvent;
import java.util.Set;
import java.util.function.BiConsumer;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.event.common.Subscription;
import tr.com.infumia.event.common.SubscriptionBuilder;
import tr.com.infumia.event.protocollib.ProtocolHandlerList;

public interface ProtocolSubscriptionBuilder
extends SubscriptionBuilder<Plugin, PacketEvent, Subscription, ProtocolHandlerList, ProtocolSubscriptionBuilder> {
    @NotNull
    public static ProtocolSubscriptionBuilder newBuilder(@NotNull ListenerPriority priority, PacketType ... packets) {
        return new Impl(priority, Set.of(packets));
    }

    @NotNull
    public ProtocolSubscriptionBuilder exceptionConsumer(@NotNull BiConsumer<PacketEvent, Throwable> var1);

    @NotNull
    default public ProtocolSubscriptionBuilder self() {
        return this;
    }

    public static final class Impl
    extends SubscriptionBuilder.Base<Plugin, PacketEvent, Subscription, ProtocolHandlerList, ProtocolSubscriptionBuilder>
    implements ProtocolSubscriptionBuilder,
    Get {
        @NotNull
        BiConsumer<PacketEvent, Throwable> exceptionConsumer = (__, throwable) -> throwable.printStackTrace();
        @NotNull
        ListenerPriority priority;
        @NotNull
        Set<PacketType> types;

        @NotNull
        public ProtocolHandlerList handlers() {
            return ProtocolHandlerList.simple(this);
        }

        private Impl(@NotNull ListenerPriority priority, @NotNull Set<PacketType> types) {
            if (priority == null) {
                throw new NullPointerException("priority is marked non-null but is null");
            }
            if (types == null) {
                throw new NullPointerException("types is marked non-null but is null");
            }
            this.priority = priority;
            this.types = types;
        }

        @Override
        @NotNull
        public BiConsumer<PacketEvent, Throwable> exceptionConsumer() {
            return this.exceptionConsumer;
        }

        @Override
        public Impl exceptionConsumer(@NotNull BiConsumer<PacketEvent, Throwable> exceptionConsumer) {
            if (exceptionConsumer == null) {
                throw new NullPointerException("exceptionConsumer is marked non-null but is null");
            }
            this.exceptionConsumer = exceptionConsumer;
            return this;
        }

        @Override
        @NotNull
        public ListenerPriority priority() {
            return this.priority;
        }

        @Override
        @NotNull
        public Set<PacketType> types() {
            return this.types;
        }
    }

    public static interface Get
    extends SubscriptionBuilder.Get<PacketEvent, Subscription> {
        @NotNull
        public BiConsumer<PacketEvent, Throwable> exceptionConsumer();

        @NotNull
        public ListenerPriority priority();

        @NotNull
        public Set<PacketType> types();
    }
}

