/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.event.protocollib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketContainer;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.event.protocollib.ProtocolSubscriptionBuilder;

public interface Protocol {
    public static void broadcastPacket(@NotNull PacketContainer packet) {
        Protocol.manager().broadcastServerPacket(packet);
    }

    public static void broadcastPacket(@NotNull Iterable<Player> players, @NotNull PacketContainer packet) {
        for (Player player : players) {
            Protocol.sendPacket(player, packet);
        }
    }

    @NotNull
    public static ProtocolManager manager() {
        return ProtocolLibrary.getProtocolManager();
    }

    public static void sendPacket(@NotNull Player player, @NotNull PacketContainer packet) {
        try {
            Protocol.manager().sendServerPacket(player, packet);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static ProtocolSubscriptionBuilder subscribe(@NotNull ListenerPriority priority, PacketType ... packets) {
        return ProtocolSubscriptionBuilder.newBuilder(priority, packets);
    }

    @NotNull
    public static ProtocolSubscriptionBuilder subscribe(PacketType ... packets) {
        return Protocol.subscribe(ListenerPriority.NORMAL, packets);
    }
}

