/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.event.protocollib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.event.common.Subscription;
import tr.com.infumia.event.protocollib.Protocol;
import tr.com.infumia.event.protocollib.ProtocolSubscriptionBuilder;

final class EventListener
extends PacketAdapter
implements Subscription {
    private final AtomicBoolean active = new AtomicBoolean(true);
    private final AtomicLong callCount = new AtomicLong();
    @NotNull
    private final BiConsumer<PacketEvent, Throwable> exceptionConsumer;
    @NotNull
    private final Predicate<PacketEvent>[] filters;
    @NotNull
    private final BiConsumer<Subscription, PacketEvent>[] handlers;
    @NotNull
    private final BiPredicate<Subscription, PacketEvent>[] midExpiryTests;
    @NotNull
    private final BiPredicate<Subscription, PacketEvent>[] postExpiryTests;
    @NotNull
    private final BiPredicate<Subscription, PacketEvent>[] preExpiryTests;
    @NotNull
    private final Set<PacketType> types;

    EventListener(@NotNull Plugin plugin, @NotNull ProtocolSubscriptionBuilder.Get getter, @NotNull List<BiConsumer<Subscription, PacketEvent>> handlers) {
        super(plugin, getter.priority(), getter.types());
        this.types = getter.types();
        this.exceptionConsumer = getter.exceptionConsumer();
        this.filters = (Predicate[])getter.filters().toArray(Predicate[]::new);
        this.preExpiryTests = (BiPredicate[])getter.preExpiryTests().toArray(BiPredicate[]::new);
        this.midExpiryTests = (BiPredicate[])getter.midExpiryTests().toArray(BiPredicate[]::new);
        this.postExpiryTests = (BiPredicate[])getter.postExpiryTests().toArray(BiPredicate[]::new);
        this.handlers = (BiConsumer[])handlers.toArray(BiConsumer[]::new);
    }

    public boolean active() {
        return this.active.get();
    }

    public long callCounter() {
        return this.callCount.get();
    }

    public void unregister() {
        if (!this.active.getAndSet(false)) {
            return;
        }
        Protocol.manager().removePacketListener((PacketListener)this);
    }

    public boolean closed() {
        return !this.active.get();
    }

    public void onPacketReceiving(@NotNull PacketEvent event) {
        this.onPacket(event);
    }

    public void onPacketSending(@NotNull PacketEvent event) {
        this.onPacket(event);
    }

    @NotNull
    Subscription register() {
        Protocol.manager().addPacketListener((PacketListener)this);
        return this;
    }

    private void onPacket(@NotNull PacketEvent event) {
        if (!this.types.contains(event.getPacketType())) {
            return;
        }
        if (!this.active.get()) {
            return;
        }
        for (BiPredicate<Subscription, PacketEvent> biPredicate : this.preExpiryTests) {
            if (!biPredicate.test(this, event)) continue;
            this.unregister();
            return;
        }
        try {
            for (Predicate<PacketEvent> predicate : this.filters) {
                if (predicate.test(event)) continue;
                return;
            }
            for (BiPredicate<Subscription, PacketEvent> biPredicate : this.midExpiryTests) {
                if (!biPredicate.test(this, event)) continue;
                this.unregister();
                return;
            }
            for (BiConsumer<Subscription, PacketEvent> biConsumer : this.handlers) {
                biConsumer.accept(this, event);
            }
            this.callCount.incrementAndGet();
        }
        catch (Throwable t) {
            this.exceptionConsumer.accept(event, t);
        }
        for (BiPredicate<Subscription, PacketEvent> biPredicate : this.postExpiryTests) {
            if (!biPredicate.test(this, event)) continue;
            this.unregister();
            return;
        }
    }

    @NotNull
    public Set<PacketType> types() {
        return this.types;
    }
}

