/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.string.util;

import org.apache.commons.lang.StringUtils;
import org.apache.taglibs.string.util.XmlW;

public final class StringW {
    public static String quoteRegularExpression(String str) {
        char[] chrs = str.toCharArray();
        int sz = chrs.length;
        StringBuffer buffer = new StringBuffer(2 * sz);
        int i = 0;
        while (i < sz) {
            switch (chrs[i]) {
                case '$': 
                case '*': 
                case '+': 
                case '.': 
                case '/': 
                case '?': 
                case '[': 
                case ']': 
                case '^': {
                    buffer.append("\\");
                }
            }
            buffer.append(chrs[i]);
            ++i;
        }
        return buffer.toString();
    }

    public static String wordWrap(String str) {
        return StringW.wordWrap(str, 80, "\n", "-");
    }

    public static String wordWrap(String str, int width) {
        return StringW.wordWrap(str, width, "\n", "-");
    }

    public static String wordWrap(String str, int width, String delim, String split) {
        int sz = str.length();
        StringBuffer buffer = new StringBuffer(sz / ++width * delim.length() + sz);
        width -= delim.length();
        int idx = -1;
        String substr = null;
        int i = 0;
        while (i < sz) {
            if (i > sz - width) {
                buffer.append(str.substring(i));
                break;
            }
            substr = str.substring(i, i + width);
            idx = substr.indexOf(delim);
            if (idx != -1) {
                buffer.append(substr.substring(0, idx));
                buffer.append(delim);
                i -= width - idx - delim.length();
                if (substr.length() > idx + 1 && substr.charAt(idx + 1) != '\n' && Character.isWhitespace(substr.charAt(idx + 1))) {
                    ++i;
                }
            } else {
                idx = -1;
                char[] chrs = substr.toCharArray();
                int j = width;
                while (j > 0) {
                    if (Character.isWhitespace(chrs[j - 1])) {
                        idx = j;
                        break;
                    }
                    --j;
                }
                if (idx == -1) {
                    int j2 = width;
                    while (j2 > 0) {
                        if (chrs[j2 - 1] == '-') {
                            idx = j2;
                            break;
                        }
                        --j2;
                    }
                    if (idx == -1) {
                        buffer.append(substr);
                        buffer.append(delim);
                    } else {
                        if (idx != width) {
                            ++idx;
                        }
                        buffer.append(substr.substring(0, idx));
                        buffer.append(delim);
                        i -= width - idx;
                    }
                } else {
                    buffer.append(substr.substring(0, idx));
                    buffer.append(StringUtils.repeat((String)" ", (int)(width - idx)));
                    buffer.append(delim);
                    i -= width - idx;
                }
            }
            i += width;
        }
        return buffer.toString();
    }

    public static String truncateNicely(String str, int lower, int upper, String appendToEnd) {
        str = XmlW.removeXml(str);
        if (upper < lower) {
            upper = lower;
        }
        if (str.length() > upper) {
            int loc = str.lastIndexOf(32, upper);
            str = loc >= lower ? str.substring(0, loc) : str.substring(0, upper);
            str = str + appendToEnd;
        }
        return str;
    }
}

