/*
 * Decompiled with CFR 0.152.
 */
package manifold.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.script.Bindings;
import manifold.util.ManEscapeUtil;
import manifold.util.Pair;
import manifold.util.ReservedWordMapping;

public class JsonUtil {
    public static String makeIdentifier(String name) {
        String identifier = ReservedWordMapping.getIdentifierForName(name);
        if (!identifier.equals(name)) {
            return identifier;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (i == 0 && Character.isDigit(c)) {
                sb.append('_').append(c);
                continue;
            }
            if (c == '_' || c == '$' || Character.isLetterOrDigit(c)) {
                sb.append(c);
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }

    public static String toJson(Bindings thisBindings) {
        StringBuilder sb = new StringBuilder();
        JsonUtil.toJson(thisBindings, sb, 0);
        return sb.toString();
    }

    public static void toJson(Bindings thisBindings, StringBuilder sb, int indent) {
        int iKey = 0;
        if (JsonUtil.isNewLine(sb)) {
            JsonUtil.indent(sb, indent);
        }
        sb.append("{\n");
        if (thisBindings.size() > 0) {
            for (String key : thisBindings.keySet()) {
                JsonUtil.indent(sb, indent + 2);
                sb.append('\"').append(key).append('\"').append(": ");
                Object value = thisBindings.get(key);
                if (value instanceof Bindings) {
                    JsonUtil.toJson((Bindings)value, sb, indent + 2);
                } else if (value instanceof List) {
                    JsonUtil.listToJson(sb, indent + 2, (List)value);
                } else {
                    JsonUtil.appendValue(sb, value);
                }
                JsonUtil.appendCommaNewLine(sb, iKey < thisBindings.size() - 1);
                ++iKey;
            }
        }
        JsonUtil.indent(sb, indent);
        sb.append("}");
    }

    public static String toJson(Object value) {
        StringBuilder target = new StringBuilder();
        JsonUtil.toJson(target, 0, value);
        return target.toString();
    }

    public static void toJson(StringBuilder target, int margin, Object value) {
        if (value instanceof Pair) {
            value = ((Pair)value).getSecond();
        }
        if (value instanceof Bindings) {
            JsonUtil.toJson((Bindings)value, target, margin);
        } else if (value instanceof List) {
            JsonUtil.listToJson(target, margin, (List)value);
        } else {
            JsonUtil.appendValue(target, value);
        }
    }

    private static boolean isNewLine(StringBuilder sb) {
        return sb.length() > 0 && sb.charAt(sb.length() - 1) == '\n';
    }

    public static void listToJson(StringBuilder sb, int indent, List value) {
        sb.append('[');
        if (value.size() > 0) {
            sb.append("\n");
            int iSize = value.size();
            for (int i = 0; i < iSize; ++i) {
                Object comp = value.get(i);
                if (comp instanceof Bindings) {
                    JsonUtil.toJson((Bindings)comp, sb, indent + 2);
                } else if (comp instanceof List) {
                    JsonUtil.listToJson(sb, indent + 2, (List)comp);
                } else {
                    JsonUtil.indent(sb, indent + 2);
                    JsonUtil.appendValue(sb, comp);
                }
                JsonUtil.appendCommaNewLine(sb, i < iSize - 1);
            }
        }
        JsonUtil.indent(sb, indent);
        sb.append("]");
    }

    public static String listToJson(List list) {
        StringBuilder sb = new StringBuilder();
        JsonUtil.listToJson(sb, 0, list);
        return sb.toString();
    }

    private static void appendCommaNewLine(StringBuilder sb, boolean bComma) {
        if (bComma) {
            sb.append(',');
        }
        sb.append("\n");
    }

    private static void indent(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
    }

    public static StringBuilder appendValue(StringBuilder sb, Object comp) {
        if (comp instanceof String) {
            sb.append('\"');
            sb.append(ManEscapeUtil.escapeForJavaStringLiteral((String)comp));
            sb.append('\"');
        } else if (comp instanceof Integer || comp instanceof Long || comp instanceof Double || comp instanceof Float || comp instanceof Short || comp instanceof Character || comp instanceof Byte || comp instanceof Boolean) {
            sb.append(comp);
        } else if (comp == null) {
            sb.append("null");
        } else {
            throw new IllegalStateException("Unsupported expando type: " + comp.getClass());
        }
        return sb;
    }

    public static String toXml(Object jsonValue) {
        StringBuilder sb = new StringBuilder();
        JsonUtil.toXml(jsonValue, "object", sb, 0);
        return sb.toString();
    }

    public static void toXml(Object jsonValue, String name, StringBuilder target, int indent) {
        if (jsonValue instanceof Bindings) {
            JsonUtil.toXml((Bindings)jsonValue, name, target, indent);
        } else if (jsonValue instanceof List) {
            JsonUtil.toXml((List)jsonValue, name, target, indent);
        } else {
            JsonUtil.toXml(String.valueOf(jsonValue), name, target, indent);
        }
    }

    private static void toXml(Bindings bindings, String name, StringBuilder target, int indent) {
        JsonUtil.indent(target, indent);
        target.append('<').append(name);
        if (bindings.size() > 0) {
            target.append(">\n");
            for (String key : bindings.keySet()) {
                Object value = bindings.get(key);
                if (value instanceof Pair) {
                    value = ((Pair)value).getSecond();
                }
                if (value instanceof Bindings) {
                    JsonUtil.toXml((Bindings)value, key, target, indent + 2);
                    continue;
                }
                if (value instanceof List) {
                    JsonUtil.toXml((List)value, key, target, indent + 2);
                    continue;
                }
                JsonUtil.toXml(String.valueOf(value), key, target, indent + 2);
            }
            JsonUtil.indent(target, indent);
            target.append("</").append(name).append(">\n");
        } else {
            target.append("/>\n");
        }
    }

    private static void toXml(List value, String name, StringBuilder target, int indent) {
        int len = value.size();
        JsonUtil.indent(target, indent);
        target.append("<").append(name);
        if (len > 0) {
            target.append(">\n");
            for (Object comp : value) {
                if (comp instanceof Pair) {
                    comp = ((Pair)comp).getSecond();
                }
                if (comp instanceof Bindings) {
                    JsonUtil.toXml((Bindings)comp, "li", target, indent + 4);
                    continue;
                }
                if (comp instanceof List) {
                    JsonUtil.toXml((List)comp, "li", target, indent + 4);
                    continue;
                }
                JsonUtil.indent(target, indent + 4);
                target.append("<li>").append(comp).append("</li>\n");
            }
            JsonUtil.indent(target, indent + 2);
            target.append("</").append(name).append(">\n");
        } else {
            target.append("/>\n");
        }
    }

    private static void toXml(String value, String name, StringBuilder target, int indent) {
        JsonUtil.indent(target, indent);
        target.append('<').append(name).append(">");
        target.append(value);
        target.append("</").append(name).append(">\n");
    }

    public static <E extends Bindings> Object deepCopyValue(Object value, Function<Integer, E> bindingsSupplier) {
        if (value instanceof Bindings) {
            Bindings dataBindings = (Bindings)value;
            Bindings copy = (Bindings)bindingsSupplier.apply(dataBindings.size());
            dataBindings.forEach((k, v) -> copy.put((String)k, JsonUtil.deepCopyValue(v, bindingsSupplier)));
            return copy;
        }
        if (value instanceof List) {
            List list = (List)value;
            ArrayList copy = new ArrayList(list.size());
            list.forEach(e -> copy.add(JsonUtil.deepCopyValue(e, bindingsSupplier)));
            return copy;
        }
        return value;
    }
}

