/*
 * Decompiled with CFR 0.152.
 */
package manifold.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.LocalDateTime;

public class DebugLogUtil {
    public static void log(String path, String msg) {
        DebugLogUtil.log(path, msg, false);
    }

    public static void log(String path, String msg, boolean append) {
        try (PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(path, append)));){
            pw.write(LocalDateTime.now() + ": " + msg + "\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void log(String path, Throwable t) {
        DebugLogUtil.log(path, t, false);
    }

    public static void log(String path, Throwable t, boolean append) {
        try (PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(path, append)));){
            pw.write(LocalDateTime.now() + "\n");
            t.printStackTrace(pw);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getStackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }
}

