/*
 * Decompiled with CFR 0.152.
 */
package manifold.js;

import java.util.Objects;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFile;
import manifold.api.gen.SrcClass;
import manifold.internal.javac.SourceJavaFileObject;
import manifold.js.JavascriptClass;
import manifold.js.JavascriptProgram;
import manifold.js.JavascriptTemplate;
import manifold.js.parser.Parser;
import manifold.js.parser.TemplateParser;
import manifold.js.parser.TemplateTokenizer;
import manifold.js.parser.Token;
import manifold.js.parser.Tokenizer;
import manifold.js.parser.tree.ParseError;
import manifold.js.parser.tree.ProgramNode;
import manifold.js.parser.tree.template.JSTNode;
import manifold.util.JavacDiagnostic;

class JavascriptCodeGen {
    private final IFile _file;
    private final String _fqn;

    JavascriptCodeGen(IFile file, String topLevelFqn) {
        this._file = file;
        this._fqn = topLevelFqn;
    }

    SrcClass make(DiagnosticListener<JavaFileObject> errorHandler) {
        if (Objects.equals(this._file.getExtension(), "jst")) {
            TemplateParser parser = new TemplateParser(new TemplateTokenizer(this._file, true));
            return JavascriptTemplate.genClass(this._fqn, (JSTNode)parser.parse());
        }
        Parser parser = new Parser(new Tokenizer(this._file));
        ProgramNode programNode = (ProgramNode)parser.parse();
        this.reportErrors(errorHandler, programNode);
        if (parser.isES6Class()) {
            return JavascriptClass.genClass(this._fqn, programNode);
        }
        return JavascriptProgram.genProgram(this._fqn, programNode);
    }

    private void reportErrors(DiagnosticListener<JavaFileObject> errorHandler, ProgramNode programNode) {
        if (programNode.errorCount() > 0) {
            SourceJavaFileObject file;
            try {
                file = new SourceJavaFileObject(this._file.toURI());
            }
            catch (Exception e) {
                file = null;
            }
            for (ParseError error : programNode.getErrorList()) {
                Token token = error.getToken();
                errorHandler.report(new JavacDiagnostic(file, Diagnostic.Kind.ERROR, token.getOffset(), token.getLineNumber(), token.getCol(), error.getMessage()));
            }
        }
    }
}

