/*
 * Decompiled with CFR 0.152.
 */
package manifold.io.extensions.java.io.OutputStream;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import manifold.ext.api.Extension;
import manifold.ext.api.This;
import manifold.io.extensions.java.io.Writer.ManWriterExt;

@Extension
public class ManOutputStreamExt {
    public static BufferedOutputStream buffered(@This OutputStream thiz) {
        return ManOutputStreamExt.buffered(thiz, 8192);
    }

    public static BufferedOutputStream buffered(@This OutputStream thiz, int bufferSize) {
        return thiz instanceof BufferedOutputStream ? (BufferedOutputStream)thiz : new BufferedOutputStream(thiz, bufferSize);
    }

    public static OutputStreamWriter writer(@This OutputStream thiz) {
        return ManOutputStreamExt.writer(thiz, StandardCharsets.UTF_8);
    }

    public static OutputStreamWriter writer(@This OutputStream thiz, Charset charset) {
        return new OutputStreamWriter(thiz, charset);
    }

    public static BufferedWriter bufferedWriter(@This OutputStream thiz) {
        return ManOutputStreamExt.bufferedWriter(thiz, StandardCharsets.UTF_8);
    }

    public static BufferedWriter bufferedWriter(@This OutputStream thiz, Charset charset) {
        return ManWriterExt.buffered(ManOutputStreamExt.writer(thiz, charset));
    }
}

