/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import manifold.api.fs.IDirectory;
import manifold.api.host.IManifoldHost;

public class WriterJavaFileObject
extends SimpleJavaFileObject {
    private OutputStream _outputStream;

    public WriterJavaFileObject(IManifoldHost host, String fqn) {
        super(WriterJavaFileObject.getUriFrom(host, fqn), JavaFileObject.Kind.CLASS);
    }

    public WriterJavaFileObject(IManifoldHost host, String pkg, String filename) {
        super(WriterJavaFileObject.getUriFrom(host, pkg, filename), JavaFileObject.Kind.OTHER);
    }

    private static URI getUriFrom(IManifoldHost host, String fqn) {
        String outRelativePath = fqn.replace('.', File.separatorChar) + ".class";
        IDirectory outputPath = host.getSingleModule().getOutputPath().stream().findFirst().orElse(null);
        File file = new File(outputPath.getPath().getFileSystemPathString(), outRelativePath);
        return file.toURI();
    }

    private static URI getUriFrom(IManifoldHost host, String fqn, String filename) {
        String outRelativePath = fqn.replace('.', File.separatorChar) + File.separatorChar + filename;
        IDirectory outputPath = host.getSingleModule().getOutputPath().stream().findFirst().orElse(null);
        File file = new File(outputPath.getPath().getFileSystemPathString(), outRelativePath);
        return file.toURI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream openOutputStream() throws IOException {
        this.throwIfInUse();
        WriterJavaFileObject writerJavaFileObject = this;
        synchronized (writerJavaFileObject) {
            this.throwIfInUse();
            File file = new File(this.toUri());
            if (!file.isFile()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            this._outputStream = new BufferedOutputStream(new FileOutputStream(file));
            return this._outputStream;
        }
    }

    private void throwIfInUse() throws IOException {
        if (this._outputStream != null) {
            throw new IOException("OutputStream in use");
        }
    }

    @Override
    public InputStream openInputStream() throws IOException {
        throw new UnsupportedOperationException();
    }
}

