/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.host;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import manifold.api.fs.IDirectory;
import manifold.api.fs.IFileSystem;
import manifold.internal.host.SingleModuleManifoldHost;
import manifold.util.SourcePathUtil;

public class JavacManifoldHost
extends SingleModuleManifoldHost {
    public void initialize(Set<String> sourcePath, List<String> classpath, List<String> outputPath) {
        List<String> cp = classpath.stream().filter(e -> !SourcePathUtil.excludeFromSourcePath(e)).collect(Collectors.toList());
        Set sp = sourcePath.stream().filter(e -> !SourcePathUtil.excludeFromSourcePath(e)).collect(Collectors.toSet());
        int i = 0;
        for (String p : outputPath) {
            if (cp.contains(p)) continue;
            cp.add(i++, p);
        }
        ArrayList<String> all = new ArrayList<String>();
        for (String p : sp) {
            if (all.contains(p)) continue;
            all.add(p);
        }
        for (String p : cp) {
            if (all.contains(p)) continue;
            all.add(p);
        }
        this.initPaths(cp, all, outputPath);
    }

    private void initPaths(List<String> classpath, List<String> sourcePath, List<String> outputPath) {
        IFileSystem fs = this.getFileSystem();
        List<IDirectory> cp = classpath.stream().map(path -> fs.getIDirectory(new File((String)path))).collect(Collectors.toList());
        List<IDirectory> sp = sourcePath.stream().map(path -> fs.getIDirectory(new File((String)path))).collect(Collectors.toList());
        List<IDirectory> op = outputPath.stream().map(path -> fs.getIDirectory(new File((String)path))).collect(Collectors.toList());
        this.createSingleModule(cp, sp, op);
    }
}

