/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import manifold.ext.api.ICoercionProvider;
import manifold.util.concurrent.LocklessLazyVar;

public class CoercionProviders {
    private static final LocklessLazyVar<List<ICoercionProvider>> _coercionProviders = LocklessLazyVar.make(CoercionProviders::loadCoercionProviders);

    public static List<ICoercionProvider> get() {
        return _coercionProviders.get();
    }

    private static List<ICoercionProvider> loadCoercionProviders() {
        try {
            List<ICoercionProvider> providers = CoercionProviders.loadCoercionProviders(CoercionProviders.class.getClassLoader());
            providers.addAll(CoercionProviders.loadCoercionProviders(Thread.currentThread().getContextClassLoader()));
            return providers;
        }
        catch (ServiceConfigurationError e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    private static List<ICoercionProvider> loadCoercionProviders(ClassLoader cl) {
        ArrayList<ICoercionProvider> providers = new ArrayList<ICoercionProvider>();
        ServiceLoader<ICoercionProvider> loader = ServiceLoader.load(ICoercionProvider.class, cl);
        for (ICoercionProvider provider : loader) {
            providers.add(provider);
        }
        return providers;
    }
}

