/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.type;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import manifold.api.type.IIncrementalCompileDriver;

public class BasicIncrementalCompileDriver
implements IIncrementalCompileDriver {
    private final boolean _incremental;
    private final Map<File, Set<String>> _typesToFile;

    public BasicIncrementalCompileDriver(boolean incremental) {
        this._incremental = incremental;
        this._typesToFile = new ConcurrentHashMap<File, Set<String>>();
    }

    @Override
    public boolean isIncremental() {
        return this._incremental;
    }

    @Override
    public Collection<File> getChangedFiles() {
        String manFilesProp = System.getProperty("manifold.source.files");
        if (manFilesProp == null) {
            return Collections.emptySet();
        }
        ArrayList<String> paths = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(manFilesProp, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            paths.add(tokenizer.nextToken());
        }
        return paths.stream().map(File::new).collect(Collectors.toList());
    }

    @Override
    public void mapTypesToFile(Set<String> set, File iFile) {
        this._typesToFile.put(iFile, set);
    }

    @Override
    public Map<File, Set<String>> getTypesToFile() {
        return this._typesToFile;
    }
}

