/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json.schema;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import manifold.api.gen.SrcAnnotationExpression;
import manifold.api.gen.SrcArgument;
import manifold.api.gen.SrcMemberAccessExpression;
import manifold.api.json.IJsonList;
import manifold.api.json.IJsonParentType;
import manifold.api.json.IJsonType;
import manifold.api.json.Json;
import manifold.api.json.JsonIssue;
import manifold.api.json.JsonListType;
import manifold.api.json.Token;
import manifold.api.json.schema.JsonEnumType;
import manifold.api.json.schema.JsonUnionType;
import manifold.api.json.schema.LazyRefJsonType;
import manifold.api.json.schema.TypeAttributes;
import manifold.api.type.ActualName;
import manifold.api.type.SourcePosition;
import manifold.api.type.TypeReference;
import manifold.util.JsonUtil;
import manifold.util.ManStringUtil;

public abstract class JsonSchemaType
implements IJsonParentType,
Cloneable {
    protected static final String FIELD_FILE_URL = "__FILE_URL_";
    private final State _state;
    private TypeAttributes _typeAttributes;

    protected JsonSchemaType(String name, URL source, JsonSchemaType parent, TypeAttributes attr) {
        this._state = new State(name, parent, source);
        this._typeAttributes = attr;
    }

    public String getFqn() {
        String result = "";
        if (!this.isParentRoot()) {
            result = this.getParent().getFqn();
            result = result + '.';
        }
        return result + JsonUtil.makeIdentifier(this.getLabel());
    }

    public final void resolveRefs() {
        if (this._state._resolveState != ResolveState.Unresolved) {
            return;
        }
        this._state._resolveState = ResolveState.Resolving;
        try {
            this.resolveRefsImpl();
        }
        finally {
            this._state._resolveState = ResolveState.Resolved;
        }
    }

    protected void resolveRefsImpl() {
        List<IJsonType> definitions = this.getDefinitions();
        if (definitions != null && !definitions.isEmpty()) {
            ArrayList<IJsonType> resolved = new ArrayList<IJsonType>();
            for (IJsonType type : definitions) {
                if (type instanceof JsonSchemaType) {
                    ((JsonSchemaType)type).resolveRefs();
                } else if (type instanceof LazyRefJsonType) {
                    type = ((LazyRefJsonType)type).resolve();
                }
                resolved.add(type);
            }
            this._state._definitions = resolved;
        }
    }

    protected boolean isParentRoot() {
        return this.getParent() == null || this.getParent().getParent() == null && !this.getParent().getName().equals("definitions");
    }

    public URL getFile() {
        return this._state._file != null ? this._state._file : (this._state._parent != null ? this._state._parent.getFile() : null);
    }

    public String getLabel() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this._state._name;
    }

    @Override
    public String getIdentifier() {
        return JsonUtil.makeIdentifier(this.getName());
    }

    public Token getToken() {
        return this._state._token;
    }

    public void setToken(Token token) {
        this._state._token = token;
    }

    @Override
    public JsonSchemaType getParent() {
        return this._state._parent;
    }

    public void setParent(IJsonParentType parent) {
        this._state._parent = (JsonSchemaType)parent;
    }

    @Override
    public List<IJsonType> getDefinitions() {
        return this._state._definitions;
    }

    @Override
    public void setDefinitions(List<IJsonType> definitions) {
        this._state._definitions = definitions;
    }

    protected boolean isSchemaType() {
        return this._state._bSchemaType;
    }

    protected void setJsonSchema() {
        this._state._bSchemaType = true;
    }

    @Override
    public TypeAttributes getTypeAttributes() {
        return this._typeAttributes;
    }

    @Override
    public JsonSchemaType copyWithAttributes(TypeAttributes attributes) {
        if (this.getTypeAttributes().equals(attributes)) {
            return this;
        }
        try {
            JsonSchemaType copy = (JsonSchemaType)this.clone();
            copy._typeAttributes = copy._typeAttributes.overrideWith(attributes);
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean mergeInnerTypes(IJsonParentType other, IJsonParentType mergedType, Map<String, IJsonParentType> innerTypes) {
        for (Map.Entry<String, IJsonParentType> e : innerTypes.entrySet()) {
            String name = e.getKey();
            IJsonType innerType = other.findChild(name);
            innerType = innerType != null ? Json.mergeTypes(e.getValue(), innerType) : (IJsonType)e.getValue();
            if (innerType != null) {
                mergedType.addChild(name, (IJsonParentType)innerType);
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public List<JsonIssue> getIssues() {
        if (this.getParent() != null) {
            return this.getParent().getIssues();
        }
        return this._state._issues;
    }

    @Override
    public void addIssue(JsonIssue issue) {
        if (this.getParent() != null) {
            this.getParent().addIssue(issue);
            return;
        }
        if (this._state._issues.isEmpty()) {
            this._state._issues = new ArrayList();
        }
        this._state._issues.add(issue);
    }

    protected void indent(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
    }

    protected void addTypeReferenceAnnotation(StringBuilder sb, int indent, JsonSchemaType type) {
        SrcAnnotationExpression annotation = new SrcAnnotationExpression(TypeReference.class.getName()).addArgument("value", String.class, (Object)this.getPropertyType(type, false, true));
        annotation.render(sb, indent);
    }

    protected boolean addSourcePositionAnnotation(StringBuilder sb, int indent, String name, Token token) {
        SrcAnnotationExpression annotation = new SrcAnnotationExpression(SourcePosition.class.getName()).addArgument((SrcArgument)new SrcArgument(new SrcMemberAccessExpression(this.getIdentifier(), FIELD_FILE_URL)).name("url")).addArgument("feature", String.class, (Object)name).addArgument("offset", Integer.TYPE, (Object)token.getOffset()).addArgument("length", Integer.TYPE, (Object)name.length());
        annotation.render(sb, indent);
        return true;
    }

    protected String addActualNameAnnotation(StringBuilder sb, int indent, String name, boolean capitalize) {
        String identifier = this.makeIdentifier(name, capitalize);
        if (!identifier.equals(name)) {
            this.indent(sb, indent);
            sb.append("@").append(ActualName.class.getName()).append("( \"").append(name).append("\" )\n");
        }
        return identifier;
    }

    protected String makeMemberIdentifier(IJsonType type) {
        return this.makeIdentifier(type.getName(), false);
    }

    protected String makeIdentifier(String name, boolean capitalize) {
        return capitalize ? ManStringUtil.capitalize(JsonUtil.makeIdentifier(name)) : JsonUtil.makeIdentifier(name);
    }

    protected void renderFileField(StringBuilder sb, int indent) {
        this.renderFileField(sb, indent, null);
    }

    protected void renderFileField(StringBuilder sb, int indent, String modifiers) {
        this.indent(sb, indent);
        sb.append(modifiers == null ? "" : modifiers + " ").append("String ").append(FIELD_FILE_URL).append(" = \"").append(this.getFile() == null ? "null" : this.getFile().toString()).append("\";\n");
    }

    protected String getPropertyType(IJsonType propertyType) {
        return this.getPropertyType(propertyType, false, false);
    }

    protected String getPropertyType(IJsonType propertyType, boolean qualifiedWithMe, boolean param) {
        JsonEnumType enumType;
        String name = propertyType instanceof JsonListType ? (param ? List.class.getTypeName() + '<' + this.getPropertyType(((JsonListType)propertyType).getComponentType(), qualifiedWithMe, param) + '>' : this.getNameRelativeFromMe(propertyType, qualifiedWithMe)) : (propertyType instanceof JsonUnionType ? ((enumType = ((JsonUnionType)propertyType).getCollapsedEnumType()) != null ? this.getNameRelativeFromMe(enumType, qualifiedWithMe) : Object.class.getSimpleName()) : (propertyType instanceof JsonSchemaType ? this.getNameRelativeFromMe(propertyType, qualifiedWithMe) : propertyType.getIdentifier()));
        return name;
    }

    protected IJsonType getConstituentQnComponent(IJsonType constituentType) {
        if (constituentType instanceof JsonListType) {
            return this.getConstituentQnComponent(((JsonListType)constituentType).getComponentType());
        }
        return constituentType;
    }

    private String getNameRelativeFromMe(IJsonType type, boolean qualifiedWithMe) {
        IJsonType parent = this.getParentFromMe(type, qualifiedWithMe);
        if (parent == null) {
            return type.getIdentifier();
        }
        return this.getNameRelativeFromMe(parent, qualifiedWithMe) + '.' + type.getIdentifier();
    }

    private IJsonType getParentFromMe(IJsonType type, boolean qualifiedWithMe) {
        IJsonParentType parent = type.getParent();
        if (parent != null) {
            if (parent.getIdentifier().equals("definitions")) {
                return this.getParentFromMe(parent, qualifiedWithMe);
            }
            if (parent == this) {
                return qualifiedWithMe ? this : null;
            }
        }
        return parent;
    }

    protected String getConstituentQn(IJsonType constituentType, IJsonType propertyType) {
        return this.getConstituentQn(constituentType, propertyType, false);
    }

    protected String getConstituentQn(IJsonType constituentType, IJsonType propertyType, boolean param) {
        String qn = this.getPropertyType(constituentType, false, param);
        while (propertyType instanceof JsonListType) {
            qn = (param ? List.class.getTypeName() : IJsonList.class.getTypeName()) + '<' + qn + '>';
            propertyType = ((JsonListType)propertyType).getComponentType();
        }
        return qn;
    }

    protected boolean isCollapsedUnionEnum(IJsonType type) {
        while (type instanceof JsonListType) {
            type = ((JsonListType)type).getComponentType();
        }
        JsonEnumType enumType = type instanceof JsonUnionType ? ((JsonUnionType)type).getCollapsedEnumType() : null;
        return enumType != null;
    }

    protected String removeGenerics(String specificPropertyType) {
        String rawSpecificPropertyType = specificPropertyType;
        int iAngle = specificPropertyType.indexOf("<");
        if (iAngle > 0 && (rawSpecificPropertyType = rawSpecificPropertyType.substring(0, iAngle)).contains(IJsonList.class.getSimpleName())) {
            rawSpecificPropertyType = List.class.getSimpleName();
        }
        return rawSpecificPropertyType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonSchemaType that = (JsonSchemaType)o;
        return this.getName().equals(that.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    static enum ResolveState {
        Unresolved,
        Resolving,
        Resolved;

    }

    private static class State {
        private final String _name;
        private JsonSchemaType _parent;
        private final URL _file;
        private List<IJsonType> _definitions;
        private List<JsonIssue> _issues;
        private boolean _bSchemaType;
        private ResolveState _resolveState;
        private Token _token;

        private State(String name, JsonSchemaType parent, URL file) {
            this._name = name;
            this._parent = parent;
            this._file = file;
            this._issues = Collections.emptyList();
            this._resolveState = ResolveState.Unresolved;
        }
    }
}

