/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import manifold.api.json.schema.IJsonFormatTypeResolver;
import manifold.util.concurrent.LocklessLazyVar;

public class FormatTypeResolvers {
    private static final LocklessLazyVar<List<IJsonFormatTypeResolver>> _formatResolvers = LocklessLazyVar.make(FormatTypeResolvers::loadFormatTypeResolvers);

    public static List<IJsonFormatTypeResolver> get() {
        return _formatResolvers.get();
    }

    private static List<IJsonFormatTypeResolver> loadFormatTypeResolvers() {
        try {
            List<IJsonFormatTypeResolver> resolvers = FormatTypeResolvers.loadFormatTypeResolvers(FormatTypeResolvers.class.getClassLoader());
            resolvers.addAll(FormatTypeResolvers.loadFormatTypeResolvers(Thread.currentThread().getContextClassLoader()));
            return resolvers;
        }
        catch (ServiceConfigurationError e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    private static List<IJsonFormatTypeResolver> loadFormatTypeResolvers(ClassLoader cl) {
        ArrayList<IJsonFormatTypeResolver> resolvers = new ArrayList<IJsonFormatTypeResolver>();
        ServiceLoader<IJsonFormatTypeResolver> loader = ServiceLoader.load(IJsonFormatTypeResolver.class, cl);
        for (IJsonFormatTypeResolver resolver : loader) {
            resolvers.add(resolver);
        }
        return resolvers;
    }
}

