/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json.schema;

import manifold.api.json.schema.Base64Encoding;
import manifold.api.json.schema.IJsonFormatTypeResolver;
import manifold.api.json.schema.JsonFormatType;
import manifold.api.json.schema.OctetEncoding;
import manifold.ext.api.ICallHandler;

public class BinaryFormatResolver
implements IJsonFormatTypeResolver {
    private static final JsonFormatType BINARY = new JsonFormatType("binary", OctetEncoding.class);
    private static final JsonFormatType BYTE = new JsonFormatType("byte", Base64Encoding.class);

    @Override
    public JsonFormatType resolveType(String format) {
        if (BINARY.getFormat().equals(format)) {
            return BINARY;
        }
        if (BYTE.getFormat().equals(format)) {
            return BYTE;
        }
        return null;
    }

    @Override
    public Object coerce(Object value, Class<?> type) {
        if (type == OctetEncoding.class && value instanceof String) {
            return OctetEncoding.encoded((String)value);
        }
        if (type == Base64Encoding.class && value instanceof String) {
            return Base64Encoding.encoded((String)value);
        }
        if ((value instanceof OctetEncoding || value instanceof Base64Encoding) && type == String.class) {
            return value.toString();
        }
        return ICallHandler.UNHANDLED;
    }

    @Override
    public Object toBindingValue(Object value) {
        if (value instanceof OctetEncoding || value instanceof Base64Encoding) {
            return value.toString();
        }
        return ICallHandler.UNHANDLED;
    }
}

