/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json.schema;

import java.math.BigDecimal;
import java.math.BigInteger;
import manifold.api.json.schema.IJsonFormatTypeResolver;
import manifold.api.json.schema.JsonFormatType;
import manifold.ext.api.ICallHandler;

public class BigNumberFormatResolver
implements IJsonFormatTypeResolver {
    private static final JsonFormatType BIG_INTEGER = new JsonFormatType("big-integer", BigInteger.class);
    private static final JsonFormatType BIG_DECIMAL = new JsonFormatType("big-decimal", BigDecimal.class);

    @Override
    public JsonFormatType resolveType(String format) {
        if (BIG_INTEGER.getFormat().equals(format)) {
            return BIG_INTEGER;
        }
        if (BIG_DECIMAL.getFormat().equals(format)) {
            return BIG_DECIMAL;
        }
        return null;
    }

    @Override
    public Object coerce(Object value, Class<?> type) {
        if (type == BigInteger.class && value instanceof String) {
            return "0".equals(value) ? BigInteger.ZERO : new BigInteger((String)value);
        }
        if (type == BigDecimal.class && value instanceof String) {
            return "0".equals(value) ? BigDecimal.ZERO : new BigDecimal((String)value);
        }
        if ((value instanceof BigInteger || value instanceof BigDecimal) && type == String.class) {
            return value.toString();
        }
        return ICallHandler.UNHANDLED;
    }

    @Override
    public Object toBindingValue(Object value) {
        if (value instanceof BigInteger || value instanceof BigDecimal) {
            return value.toString();
        }
        return ICallHandler.UNHANDLED;
    }
}

