/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.util.List;
import java.util.Map;
import javax.script.ScriptException;
import manifold.api.json.Token;
import manifold.api.json.TokenType;
import manifold.ext.DataBindings;
import manifold.ext.ReflectionRuntimeMethods;
import manifold.ext.extensions.java.lang.Object.ManObjectExt;
import manifold.util.Pair;
import manifold.util.ReflectUtil;
import org.snakeyaml.engine.v1.api.Dump;
import org.snakeyaml.engine.v1.api.DumpSettings;
import org.snakeyaml.engine.v1.api.DumpSettingsBuilder;
import org.snakeyaml.engine.v1.api.Load;
import org.snakeyaml.engine.v1.api.LoadSettings;
import org.snakeyaml.engine.v1.api.LoadSettingsBuilder;
import org.snakeyaml.engine.v1.api.StreamDataWriter;
import org.snakeyaml.engine.v1.common.FlowStyle;
import org.snakeyaml.engine.v1.constructor.BaseConstructor;
import org.snakeyaml.engine.v1.constructor.StandardConstructor;
import org.snakeyaml.engine.v1.exceptions.ConstructorException;
import org.snakeyaml.engine.v1.exceptions.Mark;
import org.snakeyaml.engine.v1.exceptions.MarkedYamlEngineException;
import org.snakeyaml.engine.v1.nodes.MappingNode;
import org.snakeyaml.engine.v1.nodes.Node;
import org.snakeyaml.engine.v1.nodes.NodeTuple;

public class Yaml {
    public static Object fromYaml(String yaml) {
        return Yaml.fromYaml(yaml, false, false);
    }

    public static Object fromYaml(String yaml, boolean withBigNumbers, boolean withTokens) {
        try {
            return Yaml.parseYaml(yaml, withBigNumbers, withTokens);
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
        catch (MarkedYamlEngineException me) {
            Mark mark = me.getContextMark().isPresent() ? me.getContextMark().get() : null;
            throw new RuntimeException(new ScriptException(me.getMessage(), null, mark == null ? 0 : mark.getLine(), mark == null ? 0 : mark.getColumn()));
        }
    }

    public static void toYaml(Object jsonValue, final StringBuilder target) {
        DumpSettings settings = new DumpSettingsBuilder().setBestLineBreak("\n").setMultiLineFlow(true).setDefaultFlowStyle(FlowStyle.BLOCK).setIndent(2).build();
        new Dump(settings).dump(jsonValue, new StreamDataWriter(){

            @Override
            public void write(String str) {
                target.append(str);
            }

            @Override
            public void write(String str, int offset, int length) {
                target.append(str, offset, offset + length);
            }
        });
    }

    private static Object parseYaml(String yaml, boolean withBigNumbers, boolean withTokens) throws ScriptException {
        LoadSettings loadSettings = new LoadSettingsBuilder().setUseMarks(true).setDefaultMap(DataBindings::new).build();
        Load load = new Load(loadSettings, new MyConstructor(loadSettings, withTokens));
        return load.loadFromString(yaml);
    }

    private static class MyConstructor
    extends StandardConstructor {
        private final boolean _withTokens;

        MyConstructor(LoadSettings settings, boolean withTokens) {
            super(settings);
            this._withTokens = withTokens;
        }

        @Override
        protected void constructMapping2ndStep(MappingNode node, Map<Object, Object> mapping) {
            if (!this._withTokens) {
                super.constructMapping2ndStep(node, mapping);
                return;
            }
            this.flattenMapping(node);
            List<NodeTuple> nodeValue = node.getValue();
            for (NodeTuple tuple : nodeValue) {
                Node keyNode = tuple.getKeyNode();
                Node valueNode = tuple.getValueNode();
                Object key = this.constructObject(keyNode);
                if (key != null) {
                    try {
                        key.hashCode();
                    }
                    catch (Exception e) {
                        throw new ConstructorException("while constructing a mapping", node.getStartMark(), "found unacceptable key " + key, tuple.getKeyNode().getStartMark(), e);
                    }
                }
                Object value = this.constructObject(valueNode);
                value = this.makeTokensValue(keyNode, valueNode, value);
                if (keyNode.isRecursive()) {
                    String inner = "RecursiveTuple";
                    inner = '$' + inner;
                    ReflectUtil.ConstructorRef constructor = ReflectUtil.constructor(BaseConstructor.class.getTypeName() + inner, Object.class, Object.class);
                    Object recursiveTuple = constructor.newInstance(key, value);
                    Object element = constructor.newInstance(mapping, recursiveTuple);
                    List maps2fill = (List)ReflectionRuntimeMethods.getField_Object(ManObjectExt.jailbreak(this), "maps2fill");
                    maps2fill.add(0, element);
                    continue;
                }
                mapping.put(key, value);
            }
        }

        private Object makeTokensValue(Node keyNode, Node valueNode, Object value) {
            Token valueToken;
            Token keyToken = this.makeToken(keyNode);
            if (keyToken != null && (valueToken = this.makeToken(valueNode)) != null) {
                value = new Pair<Token[], Object>(new Token[]{keyToken, valueToken}, value);
            }
            return value;
        }

        private Token makeToken(Node node) {
            if (node.getStartMark().isPresent()) {
                Mark mark = node.getStartMark().get();
                return new Token(TokenType.STRING, node.getTag().getValue(), mark.getIndex(), mark.getLine(), mark.getColumn());
            }
            return null;
        }
    }
}

