/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.script.ScriptException;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFile;
import manifold.api.host.IManifoldHost;
import manifold.api.json.ErrantType;
import manifold.api.json.IJsonParentType;
import manifold.api.json.IJsonType;
import manifold.api.json.Json;
import manifold.api.json.JsonIssueContainer;
import manifold.api.json.JsonStructureType;
import manifold.api.json.schema.IllegalSchemaTypeName;
import manifold.api.json.schema.TypeAttributes;
import manifold.api.type.AbstractSingleFileModel;
import manifold.api.type.ResourceFileTypeManifold;
import manifold.ext.DataBindings;
import manifold.internal.javac.IIssue;
import manifold.internal.javac.SourceJavaFileObject;
import manifold.util.JavacDiagnostic;

public class JsonModel
extends AbstractSingleFileModel {
    private IJsonParentType _type;
    private JsonIssueContainer _issues;

    public JsonModel(IManifoldHost host, String fqn, Set<IFile> files) {
        super(host, fqn, files);
        this.init();
    }

    private void init() {
        block9: {
            Object jsonValue;
            this._issues = null;
            try {
                jsonValue = this.load();
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof ScriptException) {
                    this._issues = new JsonIssueContainer((ScriptException)cause, this.getFile());
                }
                jsonValue = new DataBindings();
            }
            try {
                try {
                    IJsonType type = Json.transformJsonObject(this.getHost(), this.getFile().getBaseName(), this.getFile().toURI().toURL(), null, jsonValue);
                    if (type instanceof IJsonParentType) {
                        this._type = (IJsonParentType)type;
                        break block9;
                    }
                    this._type = new JsonStructureType(null, this.getFile().toURI().toURL(), this.getFile().getBaseName(), new TypeAttributes());
                }
                catch (IllegalSchemaTypeName e) {
                    this._type = new ErrantType(this.getFile().toURI().toURL(), e.getTypeName());
                    if (this._issues == null) {
                        this._issues = new JsonIssueContainer(this.getFile());
                    }
                    this._issues.addIssues(e);
                }
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected Object load() {
        return Json.fromJson(ResourceFileTypeManifold.getContent(this.getFile()), false, true);
    }

    public IJsonParentType getType() {
        return this._type;
    }

    @Override
    public void updateFile(IFile file) {
        super.updateFile(file);
        this.init();
    }

    void report(DiagnosticListener<JavaFileObject> errorHandler) {
        if (errorHandler == null) {
            return;
        }
        List<IIssue> issues = this.getIssues();
        if (issues.isEmpty()) {
            return;
        }
        SourceJavaFileObject file = new SourceJavaFileObject(this.getFile().toURI());
        for (IIssue issue : issues) {
            Diagnostic.Kind kind = issue.getKind() == IIssue.Kind.Error ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING;
            errorHandler.report(new JavacDiagnostic(file, kind, issue.getStartOffset(), issue.getLine(), issue.getColumn(), issue.getMessage()));
        }
    }

    private List<IIssue> getIssues() {
        ArrayList<IIssue> allIssues = new ArrayList<IIssue>();
        if (this._issues != null) {
            allIssues.addAll(this._issues.getIssues());
        }
        if (this._type != null) {
            allIssues.addAll(this._type.getIssues());
        }
        return allIssues;
    }
}

