/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import manifold.api.json.IJsonParentType;
import manifold.api.json.IJsonType;
import manifold.api.json.schema.Type;
import manifold.api.json.schema.TypeAttributes;
import manifold.ext.RuntimeMethods;

public class JsonBasicType
implements IJsonType {
    private final Type _type;
    private Class<?> _javaClass;
    private final TypeAttributes _typeAttributes;

    public JsonBasicType(Type type, TypeAttributes typeAttributes) {
        this._type = type;
        this._typeAttributes = typeAttributes;
        boolean nullable = typeAttributes.getNullable() != null && typeAttributes.getNullable() != false;
        switch (type) {
            case String: {
                this._javaClass = String.class;
                break;
            }
            case Number: {
                this._javaClass = nullable ? Double.class : Double.TYPE;
                break;
            }
            case Integer: {
                this._javaClass = nullable ? Integer.class : Integer.TYPE;
                break;
            }
            case Boolean: {
                this._javaClass = nullable ? Boolean.class : Boolean.TYPE;
                break;
            }
            case Null: {
                this._javaClass = Void.class;
                break;
            }
            default: {
                throw new IllegalArgumentException(type.getName() + " is not a simple type.");
            }
        }
        Object defaultValue = typeAttributes.getDefaultValue();
        if (defaultValue != null) {
            this._typeAttributes.setDefaultValue(RuntimeMethods.coerce(defaultValue, this._javaClass));
        }
    }

    private JsonBasicType(Type type) {
        this(type, new TypeAttributes(true));
    }

    public static JsonBasicType get(Object jsonObj) {
        if (jsonObj == null) {
            return null;
        }
        Class<?> cls = jsonObj.getClass();
        if (cls == Byte.TYPE || cls == Short.TYPE || cls == Integer.TYPE || cls == Long.TYPE || cls == Byte.class || cls == Short.class || cls == Integer.class || cls == Long.class || cls == BigInteger.class) {
            return new JsonBasicType(Type.Integer);
        }
        if (cls == Float.TYPE || cls == Double.TYPE || cls == Float.class || cls == Double.class || cls == BigDecimal.class) {
            return new JsonBasicType(Type.Number);
        }
        if (cls == Boolean.TYPE || cls == Boolean.class) {
            return new JsonBasicType(Type.Boolean);
        }
        return new JsonBasicType(Type.String);
    }

    @Override
    public String getName() {
        return this._javaClass.getSimpleName();
    }

    @Override
    public String getIdentifier() {
        return this._javaClass.getSimpleName();
    }

    public Type getJsonType() {
        return this._type;
    }

    @Override
    public IJsonParentType getParent() {
        return null;
    }

    @Override
    public TypeAttributes getTypeAttributes() {
        return this._typeAttributes;
    }

    @Override
    public IJsonType copyWithAttributes(TypeAttributes attributes) {
        if (this.getTypeAttributes().equals(attributes)) {
            return this;
        }
        return new JsonBasicType(this._type, this.getTypeAttributes().overrideWith(attributes));
    }

    @Override
    public IJsonType merge(IJsonType that) {
        if (!(that instanceof JsonBasicType)) {
            return that.merge(this);
        }
        JsonBasicType other = (JsonBasicType)that;
        if (this._javaClass == String.class || other._javaClass == String.class) {
            return new JsonBasicType(Type.String, this.getTypeAttributes().blendWith(other.getTypeAttributes()));
        }
        if (this._javaClass == Void.class) {
            return other;
        }
        if (other._javaClass == Void.class) {
            return this;
        }
        if (this._type == other._type) {
            return new JsonBasicType(this._type, this.getTypeAttributes().blendWith(other.getTypeAttributes()));
        }
        if (this._type == Type.Integer && other._type == Type.Number || this._type == Type.Number && other._type == Type.Integer) {
            return new JsonBasicType(Type.Number, this.getTypeAttributes().blendWith(other.getTypeAttributes()));
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonBasicType that = (JsonBasicType)o;
        return this._type == that._type && Objects.equals(this._javaClass, that._javaClass) && Objects.equals(this._typeAttributes, that._typeAttributes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._type, this._javaClass, this._typeAttributes});
    }
}

