/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.gen;

import java.util.ArrayList;
import java.util.List;
import manifold.api.gen.SrcExpression;
import manifold.api.gen.SrcStatement;
import manifold.api.gen.SrcStatementBlock;
import manifold.api.gen.SrcSwitchCase;

public class SrcSwitchStatement
extends SrcStatement<SrcSwitchStatement> {
    private SrcExpression _expr;
    private List<SrcSwitchCase> _cases = new ArrayList<SrcSwitchCase>();
    private SrcStatement _default;

    public SrcSwitchStatement expr(SrcExpression expr) {
        this._expr = expr;
        return this;
    }

    public SrcSwitchStatement defaultCase(SrcStatement defaultStmt) {
        this._default = defaultStmt;
        return this;
    }

    public SrcSwitchStatement addCase(SrcSwitchCase aCase) {
        this._cases.add(aCase);
        return this;
    }

    @Override
    public StringBuilder render(StringBuilder sb, int indent) {
        return this.render(sb, indent, false);
    }

    public StringBuilder render(StringBuilder sb, int indent, boolean sameLine) {
        this.indent(sb, indent);
        sb.append("switch(").append(this._expr).append(") { \n");
        for (SrcSwitchCase caseStmt : this._cases) {
            caseStmt.render(sb, indent + 2);
        }
        if (this._default != null) {
            this.indent(sb, indent + 2);
            sb.append("default:\n");
            if (this._default instanceof SrcStatementBlock) {
                ((SrcStatementBlock)this._default).render(sb, indent, false);
            } else {
                this._default.render(sb, indent + 2);
            }
        }
        sb.append(this.indent(sb, indent)).append("}\n");
        return sb;
    }
}

