/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.gen;

import com.sun.tools.javac.code.Type;
import java.lang.reflect.Array;
import manifold.api.gen.SrcAnnotated;
import manifold.api.gen.SrcType;
import manifold.util.ManEscapeUtil;

public abstract class SrcElement {
    public static final int INDENT = 2;
    private SrcAnnotated _owner;

    public SrcElement() {
    }

    public SrcElement(SrcAnnotated owner) {
        this._owner = owner;
    }

    public abstract StringBuilder render(StringBuilder var1, int var2);

    public SrcAnnotated getOwner() {
        return this._owner;
    }

    public void setOwner(SrcAnnotated owner) {
        this._owner = owner;
    }

    public String indent(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
        return "";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.render(sb, 0);
        return sb.toString();
    }

    public static String makeCompileTimeConstantValue(SrcType type, Object value) {
        String result;
        if (value == null) {
            result = "null";
        } else if (value instanceof Class) {
            result = ((Class)value).getName() + ".class";
        } else if (value instanceof Type) {
            result = ((Type)value).tsym.getQualifiedName().toString() + ".class";
        } else if (value instanceof String) {
            result = String.class.getName().equals(type.getName()) || String.class.getSimpleName().equals(type.getName()) ? "\"" + ManEscapeUtil.escapeForJava(value.toString()) + "\"" : (type.isEnum() ? type.getName() + '.' + value : (type.getName().equals(Character.TYPE.getName()) ? "'" + ManEscapeUtil.escapeForJava(value.toString()) + "'" : (String)value));
        } else if (value instanceof Character) {
            result = "'" + ManEscapeUtil.escapeForJava(value.toString()) + "'";
        } else if (value.getClass().isArray()) {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            int len = Array.getLength(value);
            for (int i = 0; i < len; ++i) {
                Object v = Array.get(value, i);
                sb.append(i > 0 ? ", " : "").append(SrcElement.makeCompileTimeConstantValue(type.getComponentType(), v));
            }
            sb.append("}");
            result = sb.toString();
        } else {
            result = value.toString();
        }
        return result;
    }
}

