/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.gen;

import java.util.ArrayList;
import java.util.List;
import manifold.api.gen.SrcArgument;
import manifold.api.gen.SrcExpression;
import manifold.api.gen.SrcType;

public class SrcAnnotationExpression
extends SrcExpression<SrcAnnotationExpression> {
    private String _fqn;
    private List<SrcArgument> _arguments = new ArrayList<SrcArgument>();

    public SrcAnnotationExpression(String fqn) {
        this._fqn = fqn;
    }

    public SrcAnnotationExpression(Class type) {
        this._fqn = type.getName();
    }

    public SrcAnnotationExpression addArgument(SrcArgument arg) {
        this._arguments.add(arg);
        return this;
    }

    public SrcAnnotationExpression addArgument(String paramName, Class type, Object value) {
        this._arguments.add((SrcArgument)new SrcArgument(type, value).name(paramName));
        return this;
    }

    public SrcAnnotationExpression addArgument(String paramName, SrcType type, Object value) {
        this._arguments.add((SrcArgument)new SrcArgument(type, value).name(paramName));
        return this;
    }

    @Override
    public SrcAnnotationExpression copy() {
        SrcAnnotationExpression copy = new SrcAnnotationExpression(this._fqn);
        for (SrcArgument expr : this._arguments) {
            copy.addArgument(expr.copy());
        }
        return copy;
    }

    public String getAnnotationType() {
        return this._fqn;
    }

    public List<SrcArgument> getArguments() {
        return this._arguments;
    }

    public SrcArgument getArgument(String paramName) {
        for (SrcArgument arg : this._arguments) {
            String argName = arg.getSimpleName();
            if (!(argName != null && !argName.isEmpty() ? paramName.equals(argName) : paramName == null || paramName.isEmpty() || paramName.equals("value"))) continue;
            return arg;
        }
        return null;
    }

    @Override
    public StringBuilder render(StringBuilder sb, int indent) {
        return this.render(sb, indent, false);
    }

    public StringBuilder render(StringBuilder sb, int indent, boolean sameLine) {
        this.indent(sb, indent);
        sb.append('@').append(this._fqn);
        this.renderArgumenets(sb, this._arguments, indent, sameLine);
        return sb;
    }
}

