/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.fs.physical;

import java.io.File;
import java.net.URI;
import manifold.api.fs.IDirectory;
import manifold.api.fs.IFileSystem;
import manifold.api.fs.IResource;
import manifold.api.fs.ResourcePath;
import manifold.api.fs.physical.IFileMetadata;
import manifold.api.fs.physical.IPhysicalFileSystem;
import manifold.api.fs.physical.PhysicalDirectoryImpl;

public class PhysicalResourceImpl
implements IResource {
    protected final ResourcePath _path;
    protected final IPhysicalFileSystem _backingFileSystem;
    private final IFileSystem _fs;

    protected PhysicalResourceImpl(IFileSystem fs, ResourcePath path, IPhysicalFileSystem backingFileSystem) {
        this._fs = fs;
        this._path = path;
        this._backingFileSystem = backingFileSystem;
    }

    @Override
    public IFileSystem getFileSystem() {
        return this._fs;
    }

    @Override
    public IDirectory getParent() {
        if (this._path.getParent() == null) {
            return null;
        }
        return new PhysicalDirectoryImpl(this.getFileSystem(), this._path.getParent(), this._backingFileSystem);
    }

    @Override
    public String getName() {
        return this._path.getName();
    }

    @Override
    public boolean exists() {
        return this.getIFileMetadata().exists();
    }

    @Override
    public boolean delete() {
        return this._backingFileSystem.delete(this._path);
    }

    @Override
    public URI toURI() {
        return this.toJavaFile().toURI();
    }

    @Override
    public ResourcePath getPath() {
        return this._path;
    }

    @Override
    public boolean isChildOf(IDirectory dir) {
        return dir.getPath().isChild(this._path);
    }

    @Override
    public boolean isDescendantOf(IDirectory dir) {
        return dir.getPath().isDescendant(this._path);
    }

    @Override
    public File toJavaFile() {
        return new File(this._path.getPathString());
    }

    @Override
    public boolean isJavaFile() {
        return true;
    }

    @Override
    public boolean isInJar() {
        return false;
    }

    @Override
    public boolean create() {
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IResource) {
            return this._path.equals(((IResource)obj).getPath());
        }
        return false;
    }

    public String toString() {
        return this.getPath().getFileSystemPathString();
    }

    protected IFileMetadata getIFileMetadata() {
        return this._backingFileSystem.getFileMetadata(this._path);
    }
}

