/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.fs.def;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import manifold.api.fs.FileFactory;
import manifold.api.fs.IDirectory;
import manifold.api.fs.IFile;
import manifold.api.fs.IFileSystem;
import manifold.api.fs.IProtocolAdapter;
import manifold.api.fs.IResource;
import manifold.api.fs.def.JavaDirectoryImpl;
import manifold.api.fs.def.JavaFileImpl;
import manifold.api.fs.jar.JarFileDirectoryImpl;
import manifold.api.fs.url.URLFileImpl;
import manifold.api.host.IManifoldHost;
import manifold.api.service.BaseService;
import manifold.util.ManStringUtil;

public class FileSystemImpl
extends BaseService
implements IFileSystem {
    private final IManifoldHost _host;
    private final FileFactory _fileFactory;
    private Map<File, IDirectory> _cachedDirInfo;
    private IFileSystem.CachingMode _cachingMode;
    private IDirectoryResourceExtractor _iDirectoryResourceExtractor;
    private IFileResourceExtractor _iFileResourceExtractor;
    private Map<String, IProtocolAdapter> _protocolAdapters;
    public static boolean USE_NEW_API = false;
    static final Object CACHED_FILE_SYSTEM_LOCK = new Object();
    private static final Set<String> FILE_SUFFIXES = new HashSet<String>();

    public FileSystemImpl(IManifoldHost host, IFileSystem.CachingMode cachingMode) {
        this._host = host;
        this._fileFactory = new FileFactory(this);
        this._cachedDirInfo = new HashMap<File, IDirectory>();
        this._cachingMode = cachingMode;
        this._iDirectoryResourceExtractor = new IDirectoryResourceExtractor();
        this._iFileResourceExtractor = new IFileResourceExtractor();
        this._protocolAdapters = new ConcurrentHashMap<String, IProtocolAdapter>();
        this.loadProtocolAdapters();
    }

    @Override
    public IManifoldHost getHost() {
        return this._host;
    }

    @Override
    public FileFactory getFileFactory() {
        return this._fileFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDirectory getIDirectory(File dir) {
        if (USE_NEW_API) {
            return this._fileFactory.getIDirectory(dir);
        }
        if (dir == null) {
            return null;
        }
        dir = FileSystemImpl.normalizeFile(dir);
        Object object = CACHED_FILE_SYSTEM_LOCK;
        synchronized (object) {
            IDirectory directory = this._cachedDirInfo.get(dir);
            if (directory == null) {
                directory = this.createDir(dir);
                this._cachedDirInfo.put(dir, directory);
            }
            return directory;
        }
    }

    @Override
    public IFile getIFile(File file) {
        if (USE_NEW_API) {
            return this._fileFactory.getIFile(file);
        }
        if (file == null) {
            return null;
        }
        return new JavaFileImpl(this, FileSystemImpl.normalizeFile(file));
    }

    public static File normalizeFile(File file) {
        String absolutePath = file.getAbsolutePath();
        ArrayList<String> components = new ArrayList<String>();
        boolean reallyNormalized = false;
        int lastIndex = 0;
        for (int i = 0; i < absolutePath.length(); ++i) {
            char c = absolutePath.charAt(i);
            if (c != '/' && c != '\\') continue;
            String component = absolutePath.substring(lastIndex, i);
            if (component.equals(".")) {
                reallyNormalized = true;
            } else if (component.equals("..")) {
                components.remove(components.size() - 1);
                reallyNormalized = true;
            } else {
                components.add(component);
            }
            lastIndex = i + 1;
        }
        String component = absolutePath.substring(lastIndex);
        if (component.equals(".")) {
            reallyNormalized = true;
        } else if (component.equals("..")) {
            components.remove(components.size() - 1);
            reallyNormalized = true;
        } else {
            components.add(component);
        }
        return reallyNormalized ? new File(ManStringUtil.join(components, "/")) : file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCachingMode(IFileSystem.CachingMode cachingMode) {
        Object object = CACHED_FILE_SYSTEM_LOCK;
        synchronized (object) {
            this._cachingMode = cachingMode;
            for (IDirectory dir : this._cachedDirInfo.values()) {
                if (!(dir instanceof JavaDirectoryImpl)) continue;
                ((JavaDirectoryImpl)dir).setCachingMode(cachingMode);
            }
        }
    }

    private IDirectory createDir(File dir) {
        if ((dir.getName().toLowerCase().endsWith(".jar") || dir.getName().toLowerCase().endsWith(".zip") || dir.getName().equals("bundlefile")) && dir.isFile()) {
            return new JarFileDirectoryImpl(this, dir);
        }
        return new JavaDirectoryImpl(this, dir, this._cachingMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAllCaches() {
        if (USE_NEW_API) {
            this._fileFactory.getDefaultPhysicalFileSystem().clearAllCaches();
            return;
        }
        Object object = CACHED_FILE_SYSTEM_LOCK;
        synchronized (object) {
            for (IDirectory dir : this._cachedDirInfo.values()) {
                dir.clearCaches();
            }
        }
    }

    static boolean isDirectory(File f) {
        String name = f.getName();
        if (FileSystemImpl.isAssumedFileSuffix(FileSystemImpl.getFileSuffix(name))) {
            return false;
        }
        return f.isDirectory();
    }

    private static String getFileSuffix(String name) {
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            return null;
        }
        return name.substring(dotIndex + 1);
    }

    @Override
    public IDirectory getIDirectory(URL url) {
        if (url == null) {
            return null;
        }
        IProtocolAdapter protocolAdapter = this._protocolAdapters.get(url.getProtocol());
        if (protocolAdapter != null) {
            return protocolAdapter.getIDirectory(url);
        }
        return (IDirectory)this._iDirectoryResourceExtractor.getClassResource(url);
    }

    @Override
    public IFile getIFile(URL url) {
        if (url == null) {
            return null;
        }
        IProtocolAdapter protocolAdapter = this._protocolAdapters.get(url.getProtocol());
        if (protocolAdapter != null) {
            return protocolAdapter.getIFile(url);
        }
        if (USE_NEW_API) {
            return this._fileFactory.getIFile(url);
        }
        return (IFile)this._iFileResourceExtractor.getClassResource(url);
    }

    private void loadProtocolAdapters() {
        ServiceLoader<IProtocolAdapter> adapters = ServiceLoader.load(IProtocolAdapter.class, this.getClass().getClassLoader());
        for (IProtocolAdapter adapter : adapters) {
            for (String protocol : adapter.getSupportedProtocols()) {
                this._protocolAdapters.put(protocol, adapter);
            }
        }
    }

    private void loadProtocolAdapter(Collection<IProtocolAdapter> adapters, String adapterName) {
        try {
            Class<IProtocolAdapter> adapterClass = Class.forName(adapterName, true, Thread.currentThread().getContextClassLoader()).asSubclass(IProtocolAdapter.class);
            adapters.add(adapterClass.newInstance());
        }
        catch (ClassNotFoundException adapterClass) {
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isAssumedFileSuffix(String suffix) {
        return FILE_SUFFIXES.contains(suffix);
    }

    static {
        FILE_SUFFIXES.add("class");
        FILE_SUFFIXES.add("eti");
        FILE_SUFFIXES.add("etx");
        FILE_SUFFIXES.add("gif");
        FILE_SUFFIXES.add("gr");
        FILE_SUFFIXES.add("grs");
        FILE_SUFFIXES.add("gs");
        FILE_SUFFIXES.add("gst");
        FILE_SUFFIXES.add("gsx");
        FILE_SUFFIXES.add("gti");
        FILE_SUFFIXES.add("gx");
        FILE_SUFFIXES.add("jar");
        FILE_SUFFIXES.add("java");
        FILE_SUFFIXES.add("pcf");
        FILE_SUFFIXES.add("png");
        FILE_SUFFIXES.add("properties");
        FILE_SUFFIXES.add("tti");
        FILE_SUFFIXES.add("ttx");
        FILE_SUFFIXES.add("txt");
        FILE_SUFFIXES.add("wsdl");
        FILE_SUFFIXES.add("xml");
        FILE_SUFFIXES.add("xsd");
    }

    private class IDirectoryResourceExtractor
    extends ResourceExtractor<IDirectory> {
        private IDirectoryResourceExtractor() {
        }

        @Override
        protected IDirectory getIResourceFromJarDirectoryAndEntryName(IDirectory jarFS, String entryName) {
            return jarFS.dir(entryName);
        }

        @Override
        protected IDirectory getIResourceFromJavaFile(URL location) {
            return FileSystemImpl.this.getHost().getFileSystem().getIDirectory(this.getFileFromURL(location));
        }

        @Override
        IDirectory getIResourceFromURL(URL location) {
            return null;
        }
    }

    private class IFileResourceExtractor
    extends ResourceExtractor<IFile> {
        private IFileResourceExtractor() {
        }

        @Override
        IFile getIResourceFromJarDirectoryAndEntryName(IDirectory jarFS, String entryName) {
            return jarFS.file(entryName);
        }

        @Override
        IFile getIResourceFromJavaFile(URL location) {
            return FileSystemImpl.this.getHost().getFileSystem().getIFile(this.getFileFromURL(location));
        }

        @Override
        IFile getIResourceFromURL(URL location) {
            return new URLFileImpl(FileSystemImpl.this, location);
        }
    }

    private abstract class ResourceExtractor<J extends IResource> {
        private ResourceExtractor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        J getClassResource(URL _url) {
            J res;
            if (_url == null) {
                return null;
            }
            if (_url.getProtocol().equals("file")) {
                return this.getIResourceFromJavaFile(_url);
            }
            if (_url.getProtocol().equals("jar")) {
                IDirectory jarFileDirectory;
                URL jarFileUrl;
                JarURLConnection urlConnection;
                try {
                    urlConnection = (JarURLConnection)_url.openConnection();
                    jarFileUrl = urlConnection.getJarFileURL();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                File dir = new File(jarFileUrl.getFile());
                Object object = CACHED_FILE_SYSTEM_LOCK;
                synchronized (object) {
                    jarFileDirectory = (IDirectory)FileSystemImpl.this._cachedDirInfo.get(dir);
                    if (jarFileDirectory == null) {
                        jarFileDirectory = FileSystemImpl.this.createDir(dir);
                        FileSystemImpl.this._cachedDirInfo.put(dir, jarFileDirectory);
                    }
                }
                return this.getIResourceFromJarDirectoryAndEntryName(jarFileDirectory, urlConnection.getEntryName());
            }
            if (_url.getProtocol().equals("http") && (res = this.getIResourceFromURL(_url)) != null) {
                return res;
            }
            throw new RuntimeException("Unrecognized protocol: " + _url.getProtocol());
        }

        abstract J getIResourceFromURL(URL var1);

        abstract J getIResourceFromJarDirectoryAndEntryName(IDirectory var1, String var2);

        abstract J getIResourceFromJavaFile(URL var1);

        protected File getFileFromURL(URL url) {
            try {
                URI uri = url.toURI();
                if (uri.getFragment() != null) {
                    uri = new URI(uri.getScheme(), uri.getSchemeSpecificPart(), null);
                }
                return new File(uri);
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Unable to parse URL " + url.toExternalForm(), ex);
            }
        }
    }
}

