/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.fs;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import manifold.api.fs.IDirectory;
import manifold.api.fs.IFile;
import manifold.api.fs.IFileSystem;
import manifold.api.fs.ResourcePath;
import manifold.api.fs.jar.JarFileDirectoryImpl;
import manifold.api.fs.physical.IPhysicalFileSystem;
import manifold.api.fs.physical.PhysicalDirectoryImpl;
import manifold.api.fs.physical.PhysicalFileImpl;
import manifold.api.fs.physical.fast.FastPhysicalFileSystem;

public class FileFactory {
    private IFileSystem _fs;
    private IPhysicalFileSystem _defaultPhysicalFileSystem;

    public FileFactory(IFileSystem fs) {
        this._fs = fs;
        this._defaultPhysicalFileSystem = this.createDefaultPhysicalFileSystem();
    }

    public IFileSystem getFileSystem() {
        return this._fs;
    }

    public IDirectory getIDirectory(File f) {
        if (f.getName().endsWith(".jar") && f.isFile()) {
            return new JarFileDirectoryImpl(this.getFileSystem(), f);
        }
        return new PhysicalDirectoryImpl(this.getFileSystem(), ResourcePath.parse(f.getAbsolutePath()), this._defaultPhysicalFileSystem);
    }

    public IFile getIFile(File f) {
        return new PhysicalFileImpl(this.getFileSystem(), ResourcePath.parse(f.getAbsolutePath()), this._defaultPhysicalFileSystem);
    }

    public IDirectory getIDirectory(String absolutePath) {
        if (absolutePath.endsWith(".jar") && new File(absolutePath).isFile()) {
            return new JarFileDirectoryImpl(this._fs, new File(absolutePath));
        }
        return new PhysicalDirectoryImpl(this.getFileSystem(), ResourcePath.parse(absolutePath), this._defaultPhysicalFileSystem);
    }

    public IFile getIFile(String absolutePath) {
        return new PhysicalFileImpl(this.getFileSystem(), ResourcePath.parse(absolutePath), this._defaultPhysicalFileSystem);
    }

    public IFile getIFile(URL url) {
        try {
            return this.getIFile(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public IFile getIFile(URI uri) {
        return this.getIFile(uri, true);
    }

    public IFile getIFile(URL url, boolean bCreateIfNotExists) {
        try {
            return this.getIFile(url.toURI(), bCreateIfNotExists);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public IFile getIFile(URI uri, boolean bCreateIfNotExists) {
        if (uri.getScheme().equals("file")) {
            try {
                if (uri.getFragment() != null) {
                    uri = new URI(uri.getScheme(), uri.getSchemeSpecificPart(), null);
                }
                return this.getIFile(new File(uri));
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Unable to parse URI " + uri, ex);
            }
        }
        if (uri.getScheme().equals("jar")) {
            File jarFile;
            String path = uri.getPath();
            path = path == null ? uri.getSchemeSpecificPart() : path;
            int idx = path.lastIndexOf(33);
            String filePath = path.substring(idx + 1);
            String jarPath = path.substring(0, idx);
            try {
                jarFile = this.getIFile(new URL(jarPath)).toJavaFile();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            JarFileDirectoryImpl jarFileDirectory = new JarFileDirectoryImpl(this._fs, jarFile);
            if (bCreateIfNotExists) {
                return jarFileDirectory.getOrCreateFile(filePath);
            }
            return jarFileDirectory.file(filePath);
        }
        throw new RuntimeException("Unrecognized protocol: " + uri.getScheme());
    }

    public IPhysicalFileSystem getDefaultPhysicalFileSystem() {
        return this._defaultPhysicalFileSystem;
    }

    public IPhysicalFileSystem getRootPhysicalFileSystem() {
        return this._defaultPhysicalFileSystem;
    }

    public void setDefaultPhysicalFileSystem(IPhysicalFileSystem fileSystem) {
        this._defaultPhysicalFileSystem = fileSystem;
    }

    private IPhysicalFileSystem createDefaultPhysicalFileSystem() {
        return new FastPhysicalFileSystem();
    }
}

