/*
 * This file is part of flare, licensed under the MIT License (MIT).
 *
 * Copyright (c) vectrix.space <https://vectrix.space/>
 * Copyright (c) contributors
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package space.vectrix.flare.fastutil;

import it.unimi.dsi.fastutil.doubles.AbstractDoubleSet;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.doubles.DoubleSpliterator;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

/* package */ final class Double2ObjectSyncMapSet extends AbstractDoubleSet implements DoubleSet {
  private static final long serialVersionUID = 1;
  private final Double2ObjectSyncMap<Boolean> map;
  private final DoubleSet set;

  /* package */ Double2ObjectSyncMapSet(final @NonNull Double2ObjectSyncMap<Boolean> map) {
    this.map = map;
    this.set = map.keySet();
  }

  @Override
  public void clear() {
    this.map.clear();
  }

  @Override
  public int size() {
    return this.map.size();
  }

  @Override
  public boolean isEmpty() {
    return this.map.isEmpty();
  }

  @Override
  public boolean contains(final double key) {
    return this.map.containsKey(key);
  }

  @Override
  public boolean remove(final double key) {
    return this.map.remove(key) != null;
  }

  @Override
  public boolean add(final double key) {
    return this.map.put(key, Boolean.TRUE) == null;
  }

  @Override
  public boolean containsAll(final @NonNull DoubleCollection collection) {
    return this.set.containsAll(collection);
  }

  @Override
  public boolean removeAll(final @NonNull DoubleCollection collection) {
    return this.set.removeAll(collection);
  }

  @Override
  public boolean retainAll(final @NonNull DoubleCollection collection) {
    return this.set.retainAll(collection);
  }

  @Override
  public @NonNull DoubleIterator iterator() {
    return this.set.iterator();
  }

  @Override
  public @NonNull DoubleSpliterator spliterator() {
    return this.set.spliterator();
  }

  @Override
  public double[] toArray(double[] original) {
    return this.set.toArray(original);
  }

  @Override
  public double[] toDoubleArray() {
    return this.set.toDoubleArray();
  }

  @Override
  public boolean equals(final @Nullable Object other) {
    return other == this || this.set.equals(other);
  }

  @Override
  public @NonNull String toString() {
    return this.set.toString();
  }

  @Override
  public int hashCode() {
    return this.set.hashCode();
  }
}
