/*
 * Decompiled with CFR 0.152.
 */
package space.arim.dazzleconf.ext.snakeyaml;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.comments.CommentLine;
import org.yaml.snakeyaml.comments.CommentType;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.Tag;
import space.arim.dazzleconf.ext.snakeyaml.SnakeYamlOptions;
import space.arim.dazzleconf.ext.snakeyaml.YamlWriter;
import space.arim.dazzleconf.factory.CommentedWrapper;

final class FullWriter
implements YamlWriter {
    private final Writer writer;
    private final Yaml yaml;

    FullWriter(Writer writer, Yaml yaml) {
        this.writer = writer;
        this.yaml = yaml;
    }

    @Override
    public void writeData(Map<String, Object> configMap, List<String> commentHeader) throws IOException {
        Node mapNode = this.mapToNode(configMap);
        if (!commentHeader.isEmpty()) {
            mapNode.setBlockComments(this.convertComments(commentHeader));
        }
        try {
            this.yaml.serialize(mapNode, this.writer);
        }
        catch (YAMLException ex) {
            throw this.yamlToIoException(ex);
        }
    }

    private Node mapToNode(Map<?, Object> configMap) {
        ArrayList keyValuePairs = new ArrayList(configMap.size());
        configMap.forEach((key, value) -> {
            Node keyNode = this.yaml.represent(key);
            if (value instanceof CommentedWrapper) {
                CommentedWrapper commentWrapper = (CommentedWrapper)value;
                keyNode.setBlockComments(this.convertComments(commentWrapper.getComments()));
                value = commentWrapper.getValue();
            }
            Node valueNode = this.valueToNode(value);
            keyValuePairs.add(new NodeTuple(keyNode, valueNode));
        });
        return new MappingNode(Tag.MAP, keyValuePairs, DumperOptions.FlowStyle.AUTO);
    }

    private Node valueToNode(Object value) {
        if (value instanceof Map) {
            Map map = (Map)value;
            return this.mapToNode(map);
        }
        return this.yaml.represent(value);
    }

    private List<CommentLine> convertComments(List<String> comments) {
        ArrayList<CommentLine> commentLines = new ArrayList<CommentLine>(comments.size());
        for (String comment : comments) {
            commentLines.add(new CommentLine(null, null, " " + comment, CommentType.BLOCK));
        }
        return commentLines;
    }

    static final class Factory
    implements YamlWriter.Factory {
        static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        @Override
        public YamlWriter newWriter(SnakeYamlOptions yamlOptions, Writer writer) {
            return new FullWriter(writer, yamlOptions.yamlSupplier().get());
        }

        @Override
        public boolean supportsComments() {
            return true;
        }
    }
}

