/*
 * Decompiled with CFR 0.152.
 */
package space.arim.dazzleconf.ext.snakeyaml;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Supplier;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.representer.Representer;
import space.arim.dazzleconf.ext.snakeyaml.CommentMode;

public final class SnakeYamlOptions {
    private final Supplier<Yaml> yamlSupplier;
    private final CommentMode commentMode;
    private final boolean useCommentingWriter;
    private final Charset charset;

    SnakeYamlOptions(Supplier<Yaml> yamlSupplier, CommentMode commentMode, boolean useCommentingWriter, Charset charset) {
        this.yamlSupplier = yamlSupplier;
        this.commentMode = commentMode;
        this.useCommentingWriter = useCommentingWriter;
        this.charset = charset;
    }

    public Supplier<Yaml> yamlSupplier() {
        return this.yamlSupplier;
    }

    public CommentMode commentMode() {
        return this.commentMode;
    }

    @Deprecated
    public boolean useCommentingWriter() {
        return this.useCommentingWriter;
    }

    public Charset charset() {
        return this.charset;
    }

    public String toString() {
        return "SnakeYamlOptions{yamlSupplier=" + this.yamlSupplier + ", commentMode=" + this.commentMode + ", useCommentingWriter=" + this.useCommentingWriter + ", charset=" + this.charset + '}';
    }

    public static class Builder {
        private Supplier<Yaml> yamlSupplier = () -> {
            Representer representer = new Representer();
            representer.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            return new Yaml(representer);
        };
        private CommentMode commentMode = CommentMode.headerOnly();
        private boolean useCommentingWriter;
        private Charset charset = StandardCharsets.UTF_8;

        public Builder yamlSupplier(Supplier<Yaml> yamlSupplier) {
            this.yamlSupplier = Objects.requireNonNull(yamlSupplier, "yamlSupplier");
            return this;
        }

        public Builder commentMode(CommentMode commentMode) {
            this.commentMode = Objects.requireNonNull(commentMode, "commentMode");
            return this;
        }

        @Deprecated
        public Builder useCommentingWriter(boolean useCommentingWriter) {
            this.useCommentingWriter = useCommentingWriter;
            this.commentMode = useCommentingWriter ? CommentMode.alternativeWriter() : CommentMode.headerOnly();
            return this;
        }

        public Builder charset(Charset charset) {
            this.charset = Objects.requireNonNull(charset, "charset");
            return this;
        }

        public SnakeYamlOptions build() {
            return new SnakeYamlOptions(this.yamlSupplier, this.commentMode, this.useCommentingWriter, this.charset);
        }

        public String toString() {
            return "Builder{yamlSupplier=" + this.yamlSupplier + ", commentMode=" + this.commentMode + ", useCommentingWriter=" + this.useCommentingWriter + ", charset=" + this.charset + '}';
        }
    }
}

