/*
 * Decompiled with CFR 0.152.
 */
package space.arim.dazzleconf.ext.snakeyaml;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;
import space.arim.dazzleconf.ext.snakeyaml.CommentedWriter;
import space.arim.dazzleconf.ext.snakeyaml.SnakeYamlOptions;
import space.arim.dazzleconf.ext.snakeyaml.YamlWriter;

final class BasicWriter
implements YamlWriter {
    private final Writer writer;
    private final Yaml yaml;
    private final CommentedWriter commentWriter;

    BasicWriter(Writer writer, Yaml yaml, CommentedWriter commentWriter) {
        this.writer = writer;
        this.yaml = yaml;
        this.commentWriter = commentWriter;
    }

    @Override
    public void writeData(Map<String, Object> configMap, List<String> headerComments) throws IOException {
        this.commentWriter.writeComments(headerComments);
        try {
            this.yaml.dump(configMap, this.writer);
        }
        catch (YAMLException ex) {
            throw this.yamlToIoException(ex);
        }
    }

    static final class Factory
    implements YamlWriter.Factory {
        static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        @Override
        public YamlWriter newWriter(SnakeYamlOptions yamlOptions, Writer writer) {
            return new BasicWriter(writer, yamlOptions.yamlSupplier().get(), new CommentedWriter(writer, " # %s"));
        }

        @Override
        public boolean supportsComments() {
            return false;
        }
    }
}

